/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.util;

import java.util.ArrayList;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.BogieController;
import jp.ngt.rtm.entity.train.util.FormationEntry;
import jp.ngt.rtm.entity.train.util.FormationManager;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.network.PacketFormation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Formation {
    public final long id;
    public FormationEntry[] entries;
    private EntityTrainBase controlCar;
    private byte direction;
    private float speed;

    public Formation(long par1, int par2) {
        this.id = par1;
        this.entries = new FormationEntry[par2];
        FormationManager.getInstance().setFormation(par1, this);
    }

    public static Formation readFromNBT(NBTTagCompound nbt, boolean withEntries) {
        long fid = nbt.func_74763_f("FormationId");
        int num = nbt.func_74762_e("Size");
        Formation formation = new Formation(fid, num);
        if (withEntries) {
            NBTTagList tagList = nbt.func_150295_c("Entries", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                FormationEntry entry = FormationEntry.readFromNBT(tagList.func_150305_b(i));
                if (entry == null) continue;
                formation.setEntry(entry, i);
                entry.train.setFormation(formation);
            }
        }
        return formation;
    }

    public void writeToNBT(NBTTagCompound nbt, boolean withEntries) {
        nbt.func_74772_a("FormationId", this.id);
        nbt.func_74768_a("Size", this.entries.length);
        if (withEntries) {
            NBTTagList tagList = new NBTTagList();
            for (FormationEntry entry : this.entries) {
                if (entry == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                entry.writeToNBT(tag);
                tagList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("Entries", (NBTBase)tagList);
        }
    }

    public int size() {
        return this.entries.length;
    }

    public FormationEntry get(int par1) {
        return this.entries[par1];
    }

    private void setEntry(FormationEntry entry, int par2) {
        this.entries[par2] = entry;
    }

    public FormationEntry getEntry(EntityTrainBase par1) {
        for (FormationEntry entry : this.entries) {
            if (entry == null || !par1.equals(entry.train)) continue;
            return entry;
        }
        return null;
    }

    public void setTrain(EntityTrainBase par1, int par3, int par5) {
        this.setEntry(new FormationEntry(par1, par3, par5), par3);
        if (!par1.func_130014_f_().field_72995_K) {
            this.sendPacket();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setFormationData(EntityTrainBase par1, byte par3, byte par5) {
        FormationEntry entry = this.getEntry(par1);
        if (entry == null) {
            this.setTrain(par1, par3, par5);
        } else {
            entry.entryId = par3;
            entry.dir = par5;
        }
    }

    private void reallocation() {
        int i = 0;
        for (FormationEntry entry : this.entries) {
            if (entry != null) {
                entry.updateFormationData(this, i);
            }
            ++i;
        }
        this.sendPacket();
    }

    private void reverse() {
        NGTUtil.reverse((Object[])this.entries);
        for (FormationEntry entry : this.entries) {
            entry.dir = (byte)(entry.dir ^ 1);
        }
    }

    private void addAll(FormationEntry[] par1) {
        ArrayList list = new ArrayList();
        NGTUtil.addArray(list, (Object[])this.entries);
        NGTUtil.addArray(list, (Object[])par1);
        this.entries = list.toArray(new FormationEntry[list.size()]);
    }

    private void trim(int start, int end) {
        FormationEntry[] array = new FormationEntry[end - start + 1];
        int j = 0;
        for (int i = start; i <= end; ++i) {
            array[j] = this.entries[i];
            ++j;
        }
        this.entries = array;
    }

    public void connectTrain(EntityTrainBase par1, EntityTrainBase par2, int par3, int par4, Formation par5) {
        boolean flag0;
        FormationEntry entry = this.getEntry(par1);
        if (entry == null) {
            return;
        }
        boolean i0 = false;
        boolean bl = flag0 = par3 == entry.dir;
        if (flag0) {
            this.reverse();
        }
        entry = par5.getEntry(par2);
        boolean bl2 = flag0 = par4 == entry.dir;
        if (!flag0) {
            par5.reverse();
        }
        this.addAll(par5.entries);
        this.reallocation();
        for (FormationEntry entry2 : this.entries) {
            this.setSpeed(0.0f);
            entry2.train.setNotch(-8);
            entry2.train.setVehicleState(TrainState.TrainStateType.Role, TrainState.Role_Center.data);
        }
        FormationManager.getInstance().removeFormation(par5.id);
    }

    public void onRemovedTrain(EntityTrainBase par1) {
        if (this.entries.length <= 1) {
            FormationManager.getInstance().removeFormation(this.id);
            return;
        }
        FormationEntry entry = this.getEntry(par1);
        if (entry == null) {
            return;
        }
        if (entry.entryId == 0) {
            this.trim(1, this.entries.length - 1);
        } else if (entry.entryId == this.entries.length - 1) {
            this.trim(0, this.entries.length - 2);
        } else {
            int size = this.entries.length - entry.entryId - 1;
            Formation formation = new Formation(FormationManager.getInstance().getNewFormationId(), size);
            int j = 0;
            for (int i = entry.entryId + 1; i < this.entries.length; ++i) {
                formation.setEntry(this.entries[i], j);
                ++j;
            }
            this.trim(0, entry.entryId - 1);
            formation.reallocation();
        }
        this.reallocation();
    }

    public void onDisconnectedTrain(EntityTrainBase par1, int par2) {
        FormationEntry entry = this.getEntry(par1);
        if (entry == null) {
            return;
        }
        boolean b0 = par2 == entry.dir;
        int i0 = b0 ? entry.entryId : entry.entryId + 1;
        int size = this.entries.length - i0;
        Formation formation = new Formation(FormationManager.getInstance().getNewFormationId(), size);
        int j = 0;
        for (int i = i0; i < this.entries.length; ++i) {
            formation.setEntry(this.entries[i], j);
        }
        formation.reallocation();
        this.trim(0, i0 - 1);
        this.reallocation();
    }

    private EntityTrainBase getControlCar() {
        if (this.controlCar == null || !this.controlCar.isControlCar()) {
            for (FormationEntry entry : this.entries) {
                if (!entry.train.isControlCar()) continue;
                this.controlCar = entry.train;
                break;
            }
        }
        return this.controlCar;
    }

    public int getNotch() {
        return this.getControlCar() == null ? 0 : this.getControlCar().getNotch();
    }

    public void setSpeed(float par1) {
        if (par1 == this.speed) {
            return;
        }
        for (FormationEntry entry : this.entries) {
            entry.train.setSpeed_NoSync(par1);
        }
        this.speed = par1;
    }

    public void setTrainDirection(byte par1, EntityTrainBase par2) {
        FormationEntry entry = this.getEntry(par2);
        if (entry == null) {
            return;
        }
        this.direction = (byte)(par1 ^ entry.dir);
        byte b0 = 0;
        for (FormationEntry entry2 : this.entries) {
            if (entry2 == null) continue;
            b0 = (byte)(this.direction ^ entry2.dir);
            entry2.train.setTrainDirection_NoSync(b0);
        }
    }

    public void setTrainStateData(TrainState.TrainStateType type, byte data, EntityTrainBase par2) {
        for (FormationEntry entry : this.entries) {
            if (type == TrainState.TrainStateType.Role) {
                if (data == TrainState.Role_Front.data) {
                    this.controlCar = par2;
                }
                if (par2.equals(entry.train)) {
                    entry.train.setTrainStateData_NoSync(type, data);
                    continue;
                }
                if (entry.train.getVehicleState(TrainState.TrainStateType.Role) != data) continue;
                entry.train.setTrainStateData_NoSync(type, TrainState.Role_Center.data);
                continue;
            }
            if (type == TrainState.TrainStateType.Door) {
                int stateR = data & 1;
                int stateL = data >> 1;
                int data2 = entry.train.getTrainDirection() == 0 ? stateL << 1 | stateR : stateR << 1 | stateL;
                entry.train.setTrainStateData_NoSync(type, (byte)data2);
                continue;
            }
            entry.train.setTrainStateData_NoSync(type, data);
        }
    }

    public boolean containBogie(EntityBogie bogie) {
        for (FormationEntry entry : this.entries) {
            EntityTrainBase train = entry.train;
            if (train.getBogie(0) != bogie && train.getBogie(1) != bogie) continue;
            return true;
        }
        return false;
    }

    private void sendPacket() {
        RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketFormation(this));
    }

    public boolean isFrontCar(EntityTrainBase train) {
        EntityTrainBase front = this.direction == 0 ? this.entries[0].train : this.entries[this.entries.length - 1].train;
        return train.equals(front);
    }

    public void updateTrainMovement() {
        EntityTrainBase prevTrain = null;
        for (int i = 0; i < this.entries.length; ++i) {
            int index;
            int n = index = this.direction == 0 ? i : this.entries.length - i - 1;
            if (this.entries[index] == null) continue;
            EntityTrainBase train = this.entries[index].train;
            BogieController.MotionState state = BogieController.MotionState.STOP;
            if (train.existBogies()) {
                state = train.bogieController.moveTrainWithBogie(train, prevTrain, this.speed, false);
            }
            train.updateTrainMovement(state);
            prevTrain = train;
        }
    }
}

