/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.util;

import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.Formation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class FormationEntry
implements Comparable<FormationEntry> {
    public final EntityTrainBase train;
    public byte entryId;
    public byte dir;
    private float mileage;
    private byte jointCount = (byte)-1;

    public FormationEntry(EntityTrainBase par1, int par2, int par3) {
        this.train = par1;
        this.entryId = (byte)par2;
        this.dir = (byte)par3;
    }

    public static FormationEntry readFromNBT(NBTTagCompound nbt) {
        int trainId = nbt.func_74762_e("TrainId");
        byte pos = nbt.func_74771_c("EntryPos");
        byte dir = nbt.func_74771_c("EntryDir");
        while (NGTUtil.getClientWorld() == null || NGTUtilClient.getMinecraft().field_71439_g == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        World world = NGTUtil.getClientWorld();
        EntityTrainBase entity = (EntityTrainBase)world.func_73045_a(trainId);
        if (entity == null) {
            return null;
        }
        return new FormationEntry(entity, pos, dir);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TrainId", this.train.func_145782_y());
        nbt.func_74774_a("EntryPos", this.entryId);
        nbt.func_74774_a("EntryDir", this.dir);
    }

    public void updateFormationData(Formation par1, int i) {
        this.entryId = (byte)i;
        this.train.setFormation(par1);
    }

    @Override
    public int compareTo(FormationEntry obj) {
        return this.entryId - obj.entryId;
    }
}

