/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.util;

import java.util.HashMap;
import java.util.Map;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.Formation;
import jp.ngt.rtm.entity.train.util.FormationData;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;

public final class FormationManager {
    private static final String SAVE_NAME = "rtm_formations";
    private final boolean isRemote;
    private FormationData saveData;
    private final Map<Long, Formation> formationMap = new HashMap<Long, Formation>();

    public FormationManager(boolean par1) {
        this.isRemote = par1;
    }

    public static FormationManager getInstance() {
        return RTMCore.proxy.getFormationManager();
    }

    public void loadData(World world) {
        if (world instanceof WorldServer && world.field_73011_w.getDimension() == 0) {
            FormationData data = (FormationData)world.func_72943_a(FormationData.class, SAVE_NAME);
            if (data == null) {
                data = new FormationData(SAVE_NAME);
                world.func_72823_a(SAVE_NAME, (WorldSavedData)data);
            }
            this.saveData = data;
        }
    }

    public Map<Long, Formation> getFormations() {
        return this.formationMap;
    }

    public Formation getFormation(long id) {
        return this.formationMap.get(id);
    }

    public void setFormation(long id, Formation formation) {
        this.formationMap.put(id, formation);
        if (!this.isRemote && this.saveData != null) {
            this.saveData.func_76185_a();
        }
    }

    public void removeFormation(long id) {
        this.formationMap.remove(id);
        if (!this.isRemote && this.saveData != null) {
            this.saveData.func_76185_a();
        }
    }

    public long getNewFormationId() {
        return System.currentTimeMillis();
    }

    public Formation createNewFormation(EntityTrainBase par1) {
        long newId = this.getNewFormationId();
        Formation formation = new Formation(newId, 1);
        formation.setTrain(par1, 0, 0);
        return formation;
    }
}

