/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.util;

import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.util.ColorUtil;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class ColFace {
    public Vec3[] vertices;
    public Vec3 normal;
    private Vec3[] vNormal;
    public Vec3[] vtxExpanded;
    public Vec3 center;
    public int color = -1;

    @SideOnly(value=Side.CLIENT)
    public void setData(Face face) {
        int vtxCount = face.vertices.length / 3 + 2;
        this.vertices = new Vec3[vtxCount];
        this.vNormal = new Vec3[vtxCount];
        for (int i = 0; i < vtxCount; ++i) {
            int idx0 = i < 2 ? i : i + (i - 2) * 2;
            this.vertices[i] = face.vertices[idx0].toVec();
            this.vNormal[i] = face.vertexNormals[idx0].toVec();
        }
        this.normal = face.faceNormal.toVec();
        this.init();
    }

    public void init() {
        double expand = 0.125;
        int len = this.vertices.length;
        this.vtxExpanded = new Vec3[len];
        for (int i = 0; i < len; ++i) {
            Vec3 v0 = this.vertices[i];
            Vec3 v1 = this.vertices[(i + 1) % len];
            Vec3 v2 = this.vertices[(i + 2) % len];
            Vec3 v01n = v1.sub(v0).normalize();
            Vec3 v21n = v1.sub(v2).normalize();
            this.vtxExpanded[(i + 1) % len] = v1.add(v01n.multi(expand).add(v21n.multi(expand)));
        }
        Vec3 sum = Vec3.ZERO;
        for (Vec3 vec : this.vertices) {
            sum = sum.add(vec);
        }
        this.center = sum.multi(1.0 / (double)this.vertices.length);
    }

    public ColFace rotateAroundX(float rotation) {
        ColFace face = this.copy();
        for (int i = 0; i < face.vertices.length; ++i) {
            face.vertices[i] = face.vertices[i].rotateAroundX(rotation);
        }
        return face;
    }

    public ColFace rotateAroundY(float rotation) {
        ColFace face = this.copy();
        for (int i = 0; i < face.vertices.length; ++i) {
            face.vertices[i] = face.vertices[i].rotateAroundY(rotation);
        }
        return face;
    }

    public ColFace copy() {
        ColFace face = new ColFace();
        face.vertices = new Vec3[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            face.vertices[i] = this.vertices[i];
        }
        face.normal = this.normal;
        return face;
    }

    public Vec3 getCollisionVec(Vec3 sphereCenter, float r) {
        double dot;
        Vec3 vX;
        this.color = -1;
        Vec3 vZ = this.vertices[0];
        Vec3 vN = this.normal;
        Vec3 vQ = sphereCenter.sub(vZ);
        boolean isFrontSide = this.isSameDir(vQ.sub(vX = vQ.sub(vN.multi(dot = vQ.dotProduct(vN)))), vN);
        if (isFrontSide) {
            Vec3 vZX = vZ.add(vX);
            boolean inFace = true;
            for (int i = 0; i < this.vtxExpanded.length; ++i) {
                Vec3 v1 = this.vtxExpanded[(i + 1) % this.vtxExpanded.length];
                Vec3 v0 = this.vtxExpanded[i];
                Vec3 cross = v1.sub(v0).crossProduct(vZX.sub(v0));
                boolean isSameDir = this.isSameDir(vN, cross);
                if (isSameDir) continue;
                inFace = false;
                break;
            }
            if (inFace) {
                this.color = 0;
                return vZX;
            }
        }
        return Vec3.ZERO;
    }

    private boolean isSameDir(Vec3 v1, Vec3 v2) {
        return v1.dotProduct(v2) > 0.0;
    }

    public AxisAlignedBB toBox(Entity myself) {
        double minX = this.vertices[0].getX();
        double maxX = this.vertices[0].getX();
        double minY = this.vertices[0].getY();
        double maxY = this.vertices[0].getY();
        double minZ = this.vertices[0].getZ();
        double maxZ = this.vertices[0].getZ();
        for (Vec3 vtx : this.vertices) {
            minX = vtx.getX() < minX ? vtx.getX() : minX;
            maxX = vtx.getX() > maxX ? vtx.getX() : maxX;
            minY = vtx.getY() < minY ? vtx.getY() : minY;
            maxY = vtx.getY() > maxY ? vtx.getY() : maxY;
            minZ = vtx.getZ() < minZ ? vtx.getZ() : minZ;
            maxZ = vtx.getZ() > maxZ ? vtx.getZ() : maxZ;
        }
        double thickness = 0.25;
        if (maxX - minX < thickness) {
            if (this.normal.getX() >= 0.0) {
                minX -= this.normal.getX() * thickness;
            } else {
                maxX += this.normal.getX() * thickness;
            }
        }
        if (maxY - minY < thickness) {
            if (this.normal.getY() >= 0.0) {
                minY -= this.normal.getY() * thickness;
            } else {
                maxY += this.normal.getY() * thickness;
            }
        }
        if (maxZ - minZ < thickness) {
            if (this.normal.getZ() >= 0.0) {
                minZ -= this.normal.getZ() * thickness;
            } else {
                maxZ += this.normal.getZ() * thickness;
            }
        }
        AxisAlignedBB aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        double offsetY = myself instanceof EntityVehicleBase ? (double)((EntityVehicleBase)myself).getVehicleYOffset() : 0.0;
        return aabb.func_72317_d(myself.field_70165_t, myself.field_70163_u + offsetY, myself.field_70161_v);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFrame(NGTTessellator tessellator, boolean mustRender) {
        int col;
        int n = col = mustRender && this.color < 0 ? 0 : this.color;
        if (col >= 0) {
            float lineWidth = col > 0 ? 15.0f : 5.0f;
            GL11.glLineWidth((float)lineWidth);
            tessellator.setColorRGBA_I(col, 255);
            for (int i = 0; i < this.vertices.length; ++i) {
                Vec3 v0 = this.vertices[i];
                tessellator.addVertex((float)v0.getX(), (float)v0.getY(), (float)v0.getZ());
                Vec3 v1 = this.vertices[(i + 1) % this.vertices.length];
                tessellator.addVertex((float)v1.getX(), (float)v1.getY(), (float)v1.getZ());
            }
            GL11.glLineWidth((float)5.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderNormal(NGTTessellator tessellator) {
        this.renderNormal(tessellator, this.normal, this.center, 65535);
        for (int i = 0; i < this.vNormal.length; ++i) {
            this.renderNormal(tessellator, this.vNormal[i], this.vertices[i], 0xFF00FF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderNormal(NGTTessellator tessellator, Vec3 vec, Vec3 rootVec, int color) {
        float scale = 0.125f;
        tessellator.setColorRGBA_I(color, 255);
        tessellator.addVertex((float)rootVec.getX(), (float)rootVec.getY(), (float)rootVec.getZ());
        float x = (float)(rootVec.getX() + vec.getX() * 0.125);
        float y = (float)(rootVec.getY() + vec.getY() * 0.125);
        float z = (float)(rootVec.getZ() + vec.getZ() * 0.125);
        tessellator.addVertex(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void addColor(int value) {
        this.color = ColorUtil.add((int)this.color, (int)value);
    }
}

