/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import java.util.List;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.cfg.VehicleConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicle;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityTrolley
extends EntityMinecartEmpty
implements IResourceSelector {
    private ResourceState<ModelSetVehicle> state = new ResourceState(RTMResource.VEHICLE_TROLLEY, this);
    int count;

    public EntityTrolley(World world) {
        super(world);
        this.field_70144_Y = 0.9f;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("State", (NBTBase)this.getResourceState().writeToNBT());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.getResourceState().readFromNBT(nbt.func_74775_l("State"));
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            this.updateResourceState();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    public final void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70159_w *= 0.9;
            this.field_70179_y *= 0.9;
            EntityTrolley entity = this.getNearestTrolley();
            if (entity != null) {
                this.applyAttraction(entity);
            }
            this.count = 0;
        }
        ++this.count;
    }

    private EntityTrolley getNearestTrolley() {
        double range = 3.0;
        Vec3 myMotion = this.getMotionVec();
        List list = this.func_130014_f_().func_72872_a(EntityTrolley.class, new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 3.0, this.field_70161_v + 3.0));
        EntityTrolley target = null;
        double distance = Double.MAX_VALUE;
        for (EntityTrolley entity : list) {
            double d0;
            Vec3 difVec;
            double angle;
            if (entity == this || !(Math.abs(angle = (double)NGTMath.wrapAngle((float)((float)NGTMath.toDegrees((double)myMotion.getAngle(difVec = new Vec3(this.field_70165_t - entity.field_70165_t, this.field_70163_u - entity.field_70163_u, this.field_70161_v - entity.field_70161_v)))))) <= 90.0) || !(distance > (d0 = difVec.length()))) continue;
            target = entity;
            distance = d0;
        }
        return target;
    }

    private void applyAttraction(EntityTrolley entity) {
        Vec3 myMotion = this.getMotionVec();
        Vec3 difVec = new Vec3(this.field_70165_t - entity.field_70165_t, this.field_70163_u - entity.field_70163_u, this.field_70161_v - entity.field_70161_v);
        float conDis = ((VehicleConfig)this.getResourceState().getResourceSet().getConfig()).connectionDistance + ((VehicleConfig)entity.getResourceState().getResourceSet().getConfig()).connectionDistance;
        double distance = difVec.length();
        if (distance <= (double)conDis * 1.5 && distance >= (double)conDis) {
            double coe = 0.7;
            double d0 = myMotion.length() * 0.7 * (distance / (double)conDis);
            Vec3 addVec = difVec.multi(distance);
            entity.field_70159_w += addVec.getX() * d0;
            entity.field_70181_x += addVec.getY() * d0;
            entity.field_70179_y += addVec.getZ() * d0;
            entity.func_70018_K();
        } else if (distance < (double)conDis * 0.9) {
            double coe = 0.5;
            entity.field_70159_w *= 0.5;
            entity.field_70181_x *= 0.5;
            entity.field_70179_y *= 0.5;
            entity.func_70018_K();
        }
    }

    protected Vec3 getMotionVec() {
        return new Vec3(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (this.field_70170_p.field_72995_K) {
                player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdSelectEntityModel, player.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public ResourceState<ModelSetVehicle> getResourceState() {
        return this.state;
    }

    @Override
    public void updateResourceState() {
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            PacketNBT.sendToClient((Entity)this);
        }
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_145782_y(), -1, 0};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityPlayer player;
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityPlayer && PermissionManager.INSTANCE.hasPermission((ICommandSender)(player = (EntityPlayer)source.func_76346_g()), "editVehicle")) {
            this.func_70106_y();
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_70099_a(new ItemStack(RTMItem.itemVehicle, 1, 3), 0.5f);
            }
        }
        return true;
    }
}

