/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.entity.EntityCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.parts.EntityFloor;
import jp.ngt.rtm.entity.train.util.Formation;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.entity.vehicle.IUpdateVehicle;
import jp.ngt.rtm.entity.vehicle.VehicleNGTO;
import jp.ngt.rtm.entity.vehicle.VehicleTrackerEntry;
import jp.ngt.rtm.entity.vehicle.WeatherEffectDummy;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.ScriptExecuter;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.network.PacketSetTrainState;
import jp.ngt.rtm.network.PacketVehicleMovement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicleBase<T extends ModelSetVehicleBase>
extends EntityCustom
implements IResourceSelector {
    public static final int MAX_SEAT_ROTATION = 45;
    public static final int MAX_DOOR_MOVE = 60;
    public static final int MAX_PANTOGRAPH_MOVE = 40;
    public static final float TO_ANGULAR_VELOCITY = 114.59156f;
    private ResourceState<T> state = new ResourceState(this.getSubType(), this);
    private ScriptExecuter executer = new ScriptExecuter();
    protected List<EntityFloor> vehicleFloors = new ArrayList<EntityFloor>();
    protected final IUpdateVehicle soundUpdater;
    private boolean floorLoaded;
    private boolean tracked;
    private EntityLivingBase rider;
    public float rotationRoll;
    public float prevRotationRoll;
    @SideOnly(value=Side.CLIENT)
    public int seatRotation;
    @SideOnly(value=Side.CLIENT)
    public int rollsignAnimation;
    @SideOnly(value=Side.CLIENT)
    public int rollsignV;
    @SideOnly(value=Side.CLIENT)
    public int doorMoveL;
    @SideOnly(value=Side.CLIENT)
    public int doorMoveR;
    @SideOnly(value=Side.CLIENT)
    public int pantograph_F;
    @SideOnly(value=Side.CLIENT)
    public int pantograph_B;
    @SideOnly(value=Side.CLIENT)
    public float wheelRotationR;
    @SideOnly(value=Side.CLIENT)
    public float wheelRotationL;
    @SideOnly(value=Side.CLIENT)
    protected int vehiclePosRotationInc;
    @SideOnly(value=Side.CLIENT)
    protected double vehicleX;
    @SideOnly(value=Side.CLIENT)
    protected double vehicleY;
    @SideOnly(value=Side.CLIENT)
    protected double vehicleZ;
    @SideOnly(value=Side.CLIENT)
    protected float vehicleYaw;
    @SideOnly(value=Side.CLIENT)
    protected float vehiclePitch;
    @SideOnly(value=Side.CLIENT)
    protected float vehicleRoll;

    public EntityVehicleBase(World world) {
        super(world);
        this.field_70158_ak = true;
        if (!NGTUtil.isServer()) {
            EntityVehicleBase.func_184227_b((double)16.0);
        }
        this.field_70156_m = true;
        IUpdateVehicle iUpdateVehicle = this.soundUpdater = world != null ? RTMCore.proxy.getSoundUpdater(this) : null;
        if (world.field_72995_K) {
            world.func_72942_c((Entity)new WeatherEffectDummy(world, this));
        }
        for (TrainState.TrainStateType type : TrainState.TrainStateType.values()) {
            this.setVehicleState(type, type.min);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74782_a("State", (NBTBase)this.getResourceState().writeToNBT());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.getResourceState().readFromNBT(nbt.func_74775_l("State"));
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            this.updateResourceState();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity par1) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void syncData() {
        this.updateResourceState();
    }

    public void setFloor(EntityFloor par1) {
        this.vehicleFloors.add(par1);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            for (EntityFloor floor : this.vehicleFloors) {
                if (floor == null) continue;
                floor.func_70106_y();
            }
            RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketVehicleMovement((Entity)this, true));
        }
    }

    public final void func_70071_h_() {
        this.onVehicleUpdate();
    }

    protected void onVehicleUpdate() {
        super.func_70071_h_();
        this.prevRotationRoll = this.rotationRoll;
        if (this.field_70170_p.field_72995_K) {
            if (this.soundUpdater != null) {
                this.soundUpdater.update();
            }
            this.updateAnimation();
            this.updatePosAndRotationClient();
        } else {
            Entity passenger;
            if (!this.tracked) {
                this.tracked = VehicleTrackerEntry.trackingVehicle((Entity)this);
            }
            if (!this.floorLoaded) {
                this.setupFloors();
            }
            if ((passenger = this.getFirstPassenger()) != null) {
                if (this.rider == null && passenger instanceof EntityLivingBase) {
                    this.rider = (EntityLivingBase)passenger;
                }
            } else if (this.rider != null) {
                this.rider = null;
            }
            this.executer.execScript(this);
            this.updateBlockCollisionState();
            this.updateEntityCollisionState();
            this.updateFallState();
            this.updateMovement();
        }
    }

    protected void updateBlockCollisionState() {
    }

    protected void updateEntityCollisionState() {
    }

    protected void updateFallState() {
        this.field_70181_x -= 0.05;
    }

    protected void updateMovement() {
        this.applyPhysicalEffect();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected void applyPhysicalEffect() {
        this.field_70159_w *= (double)0.99f;
        this.field_70181_x *= (double)0.95f;
        this.field_70179_y *= (double)0.99f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updatePosAndRotationClient() {
        if (this.vehiclePosRotationInc > 0) {
            float roll;
            float d0 = 1.0f / (float)this.vehiclePosRotationInc;
            this.field_70165_t += (this.vehicleX - this.field_70165_t) * (double)d0;
            this.field_70163_u += (this.vehicleY - this.field_70163_u) * (double)d0;
            this.field_70161_v += (this.vehicleZ - this.field_70161_v) * (double)d0;
            this.field_70177_z += NGTMath.wrapAngle((float)((float)((double)this.vehicleYaw - (double)this.field_70177_z))) * d0;
            this.field_70125_A = (float)((double)this.field_70125_A + ((double)this.vehiclePitch - (double)this.field_70125_A) * (double)d0);
            this.rotationRoll = roll = this.getRoll() + (this.vehicleRoll - this.getRoll()) * d0;
            --this.vehiclePosRotationInc;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() <= 0;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public Entity func_184179_bs() {
        return null;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        this.removePassengerFromVehicle(passenger);
    }

    protected void removePassengerFromVehicle(Entity passenger) {
        this.fixRiderPosOnDismount(passenger, (Entity)this);
    }

    public void fixRiderPosOnDismount(Entity passenger, Entity ridingEntity) {
        AxisAlignedBB vehicleAABB = null;
        try {
            ModelSetBase set = (ModelSetBase)this.getResourceState().getResourceSet();
            vehicleAABB = set.getCollisionObj().getSizeBox();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            vehicleAABB = new AxisAlignedBB(-1.5, 0.0, -2.0, 1.5, 3.0, 2.0);
        }
        Vec3 vec = PooledVec3.create((double)(ridingEntity.field_70165_t - this.field_70165_t), (double)(ridingEntity.field_70163_u - this.field_70163_u), (double)(ridingEntity.field_70161_v - this.field_70161_v));
        vec = vec.rotateAroundY(-this.field_70177_z);
        float yawDif = NGTMath.wrapAngle((float)(-passenger.field_70177_z - this.field_70177_z));
        double fixX = (double)yawDif >= 0.0 ? vehicleAABB.field_72336_d + 0.5 : vehicleAABB.field_72340_a - 0.5;
        vec = PooledVec3.create((double)fixX, (double)vec.getY(), (double)vec.getZ());
        vec = vec.rotateAroundY(this.field_70177_z);
        if (vec.length() <= 16.0) {
            double z;
            double y;
            double maxY = 5.0;
            double x = this.field_70165_t + vec.getX();
            double newY = this.getDismountY(x, y = this.field_70163_u + vec.getY(), z = this.field_70161_v + vec.getZ(), y + 5.0);
            if (newY - y >= 5.0) {
                vec = PooledVec3.create((double)(-fixX), (double)vec.getY(), (double)vec.getZ());
                vec = vec.rotateAroundY(this.field_70177_z);
                x = this.field_70165_t + vec.getX();
                y = this.field_70163_u + vec.getY();
                z = this.field_70161_v + vec.getZ();
                newY = this.getDismountY(x, y, z, y + 5.0);
            }
            passenger.func_70634_a(x, y, z);
        }
    }

    private double getDismountY(double x, double y, double z, double maxY) {
        while (y < maxY && !this.field_70170_p.func_175623_d(new BlockPos(x, y, z))) {
            y += 1.0;
        }
        return y;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vec3 vec = this.getRiderPos(passenger);
            vec = vec.rotateAroundZ(-this.rotationRoll);
            vec = vec.rotateAroundX(this.field_70125_A);
            vec = vec.rotateAroundY(this.field_70177_z);
            double x = this.field_70165_t + vec.getX();
            double y = this.field_70163_u + vec.getY();
            double z = this.field_70161_v + vec.getZ();
            passenger.func_70107_b(x, y, z);
            passenger.field_70177_z -= NGTMath.wrapAngle((float)(this.field_70177_z - this.field_70126_B));
            passenger.field_70125_A -= NGTMath.wrapAngle((float)(this.field_70125_A - this.field_70127_C));
        }
    }

    public Vec3 getRiderPos(Entity passenger) {
        float[] pos = ((VehicleBaseConfig)((ModelSetVehicleBase)this.getResourceState().getResourceSet()).getConfig()).getPlayerPos()[this.getRiderPosIndex()];
        return PooledVec3.create((double)pos[0], (double)((double)pos[1] + passenger.func_70033_W()), (double)pos[2]);
    }

    protected int getRiderPosIndex() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entity) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int par6, boolean par10) {
        this.vehiclePosRotationInc = par6;
        this.vehicleX = x;
        this.vehicleY = y;
        this.vehicleZ = z;
        this.vehicleYaw = yaw;
        this.vehiclePitch = pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRollAndSpeed(float speed, float roll) {
        this.setSpeed(speed);
        this.vehicleRoll = roll;
    }

    public float getRoll() {
        return this.rotationRoll;
    }

    public abstract float getSpeed();

    public abstract void setSpeed(float var1);

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateAnimation() {
        ModelSetVehicleBase modelSet = (ModelSetVehicleBase)this.getResourceState().getResourceSet();
        ModelConfig cfg = modelSet.getConfig();
        float speed = this.getSpeed();
        float f0 = speed * 114.59156f * ((VehicleBaseConfig)cfg).wheelRotationSpeed * this.getMoveDir();
        this.wheelRotationR = (this.wheelRotationR + f0) % 360.0f;
        this.wheelRotationL = (this.wheelRotationL + f0) % 360.0f;
        byte doorState = this.getVehicleState(TrainState.TrainStateType.Door);
        boolean doorROpen = (doorState & 1) == 1;
        this.doorMoveR = this.updateDoorAnimation(modelSet, doorROpen, this.doorMoveR);
        boolean doorLOpen = (doorState & 2) == 2;
        this.doorMoveL = this.updateDoorAnimation(modelSet, doorLOpen, this.doorMoveL);
        byte pantoState = this.getVehicleState(TrainState.TrainStateType.Pantograph);
        if (pantoState == TrainState.Pantograph_Down.data) {
            if (this.pantograph_F < 40) {
                ++this.pantograph_F;
            }
            if (this.pantograph_B < 40) {
                ++this.pantograph_B;
            }
        } else {
            int[] ia = this.getPantographMaxHeight();
            if (this.pantograph_F > ia[0]) {
                --this.pantograph_F;
            } else if (this.pantograph_F < ia[0]) {
                ++this.pantograph_F;
            }
            if (this.pantograph_B > ia[1]) {
                --this.pantograph_B;
            } else if (this.pantograph_B < ia[1]) {
                ++this.pantograph_B;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getRollsignAnimation() {
        return (float)this.rollsignAnimation / 16.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRollsignAnimation(int par1) {
        this.rollsignV = par1 * 16;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSeatRotation() {
        return (float)this.seatRotation / 45.0f;
    }

    protected int[] getPantographMaxHeight() {
        return new int[]{0, 0};
    }

    protected int updateDoorAnimation(ModelSetVehicleBase modelSet, boolean isOpen, int move) {
        if (isOpen) {
            if (move < 60) {
                if (move == 0) {
                    RTMCore.proxy.playSound((Entity)this, ((VehicleBaseConfig)modelSet.getConfig()).sound_DoorOpen, 1.0f, 1.0f);
                }
                ++move;
            }
        } else if (move > 0) {
            if (move == 60) {
                RTMCore.proxy.playSound((Entity)this, ((VehicleBaseConfig)modelSet.getConfig()).sound_DoorClose, 1.0f, 1.0f);
            }
            --move;
        }
        return move;
    }

    public float getMoveDir() {
        return 1.0f;
    }

    private void setupFloors() {
        for (EntityFloor entity : this.vehicleFloors) {
            if (entity == null) continue;
            entity.func_70106_y();
        }
        ModelSetVehicleBase set = (ModelSetVehicleBase)this.getResourceState().getResourceSet();
        this.floorLoaded = true;
        for (int i = 0; i < ((VehicleBaseConfig)set.getConfig()).getSlotPos().length; ++i) {
            float[] fa = ((VehicleBaseConfig)set.getConfig()).getSlotPos()[i];
            EntityFloor floor = new EntityFloor(this.field_70170_p, this, new float[]{fa[0], fa[1] + this.getVehicleYOffset(), fa[2]}, (byte)fa[3]);
            if (!this.field_70170_p.func_72838_d((Entity)floor)) {
                this.floorLoaded = false;
                break;
            }
            this.vehicleFloors.add(floor);
        }
    }

    public String func_70005_c_() {
        return this.getResourceState().getName();
    }

    @Override
    public ResourceState<T> getResourceState() {
        return this.state;
    }

    @Override
    public void updateResourceState() {
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            PacketNBT.sendToClient((Entity)this);
            this.floorLoaded = false;
        }
        if (this.field_70170_p.field_72995_K) {
            this.soundUpdater.onModelChanged();
        }
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_145782_y(), -1, 0};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }

    protected abstract ResourceType getSubType();

    @SideOnly(value=Side.CLIENT)
    protected boolean useInteriorLight() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return super.func_70070_b();
    }

    public float getVehicleYOffset() {
        return 0.0f;
    }

    public Formation getFormation() {
        return null;
    }

    @Deprecated
    public byte getTrainStateData(int id) {
        return this.getVehicleState(TrainState.getStateType(id));
    }

    @Deprecated
    public void setTrainStateData(int id, byte data) {
        this.setVehicleState(TrainState.getStateType(id), data);
    }

    public byte getVehicleState(TrainState.TrainStateType type) {
        return (byte)this.getResourceState().getDataMap().getInt(type.toString());
    }

    public void setVehicleState(TrainState.TrainStateType type, byte data) {
        this.getResourceState().getDataMap().setInt(type.toString(), data, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void syncVehicleState(TrainState.TrainStateType type, byte data) {
        RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketSetTrainState(this, type, data));
    }

    public VehicleNGTO getNGTO() {
        return null;
    }
}

