/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.NGTWorld;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.entity.vehicle.VehicleNGTO;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.render.PartsRenderer;
import jp.ngt.rtm.render.RenderPass;
import jp.ngt.rtm.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class RenderVehicleBase
extends Render<EntityVehicleBase> {
    protected static final int DAYLIGHT_LIMIT = 7;
    protected Vector3f lightVecF = new Vector3f();

    public RenderVehicleBase(RenderManager renderManager) {
        super(renderManager);
    }

    protected void renderVehicleBase(EntityVehicleBase vehicle, double par2, double par4, double par6, float par8, float par9) {
        VehicleNGTO vngto;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        double x = par2;
        double y = par4;
        double z = par6;
        GL11.glTranslatef((float)((float)x), (float)((float)y + vehicle.getVehicleYOffset()), (float)((float)z));
        float yaw = vehicle.field_70126_B + NGTMath.wrapAngle((float)(vehicle.field_70177_z - vehicle.field_70126_B)) * par9;
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        float pitch = vehicle.field_70127_C + (vehicle.field_70125_A - vehicle.field_70127_C) * par9;
        GL11.glRotatef((float)(-pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        float roll = vehicle.prevRotationRoll + (vehicle.rotationRoll - vehicle.prevRotationRoll) * par9;
        GL11.glRotatef((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            this.debugCollision(vehicle);
        }
        if ((vngto = vehicle.getNGTO()) != null) {
            this.renderVehicleNGTO((EntityVehicle)vehicle, vngto, par9);
        } else {
            ModelSetVehicleBase modelSet = (ModelSetVehicleBase)vehicle.getResourceState().getResourceSet();
            if (modelSet != null) {
                float[] fa = ((VehicleBaseConfig)modelSet.getConfig()).offset;
                GL11.glTranslated((double)fa[0], (double)fa[1], (double)fa[2]);
                this.renderVehicleMain(vehicle, modelSet, par9);
            } else {
                RTMCore.proxy.renderMissingModel();
            }
        }
        GL11.glPopMatrix();
    }

    protected void renderVehicleMain(EntityVehicleBase vehicle, ModelSetVehicleBase modelSet, float par4) {
        int pass = MinecraftForgeClient.getRenderPass();
        boolean smoothing = ((VehicleBaseConfig)modelSet.getConfig()).smoothing;
        boolean culling = ((VehicleBaseConfig)modelSet.getConfig()).doCulling;
        if (smoothing) {
            GL11.glShadeModel((int)7425);
        }
        if (!culling) {
            GL11.glDisable((int)2884);
        }
        if (pass == 0) {
            this.renderBodyNormal(vehicle, modelSet, par4);
        } else if (pass == 1) {
            if (modelSet.modelObj.light) {
                this.renderBodyLight(vehicle, modelSet, par4);
            }
            if (modelSet.modelObj.alphaBlend) {
                this.renderBodyTransparent(vehicle, modelSet, par4);
            }
        }
        if (!culling) {
            GL11.glEnable((int)2884);
        }
        if (smoothing) {
            GL11.glShadeModel((int)7424);
        }
        if (pass == 1) {
            if (modelSet.rollsignTexture != null) {
                this.renderRollsign(vehicle, modelSet);
            }
            if (!NGTUtilClient.usingShader()) {
                GL11.glDisable((int)2884);
                this.renderLightEffect(vehicle, modelSet);
                GL11.glEnable((int)2884);
            }
        }
    }

    private void preRenderBody(ModelSetVehicleBase modelSet, byte lightState, boolean useInteriorLighting, boolean customLighting) {
        VehicleBaseConfig.Light[] lights = ((VehicleBaseConfig)modelSet.getConfig()).interiorLights;
        if (lightState > 0 && useInteriorLighting) {
            GLHelper.setLightmapMaxBrightness();
            float r = lightState == TrainState.InteriorLight_On.data ? 1.0f : -1.0f;
            for (int k = 0; k < lights.length; ++k) {
                float[] pos = lights[k].pos;
                RenderUtil.enableCustomLighting(k, pos[0], pos[1], pos[2], r, 1.0f, 1.0f);
            }
        } else if (customLighting) {
            GLHelper.setLightmapMaxBrightness();
            RenderUtil.enableCustomLighting(3, 128.0f, 256.0f, 128.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void postRenderBody(ModelSetVehicleBase modelSet, boolean useInteriorLighting, boolean customLighting) {
        VehicleBaseConfig.Light[] lights = ((VehicleBaseConfig)modelSet.getConfig()).interiorLights;
        if (useInteriorLighting) {
            for (int k = 0; k < lights.length; ++k) {
                RenderUtil.disableCustomLighting(k);
            }
            GLHelper.enableLighting();
        } else if (customLighting) {
            RenderUtil.disableCustomLighting(3);
            GLHelper.enableLighting();
        }
    }

    private void renderBody(EntityVehicleBase vehicle, ModelSetVehicleBase modelSet, RenderPass pass, float par4) {
        modelSet.modelObj.preRender();
        modelSet.modelObj.renderWithTexture(vehicle, pass, par4);
        modelSet.modelObj.postRender();
    }

    private void renderBodyNormal(EntityVehicleBase vehicle, ModelSetVehicleBase modelSet, float par4) {
        GL11.glAlphaFunc((int)514, (float)1.0f);
        int value = this.getLightValue(vehicle);
        byte state = vehicle.getVehicleState(TrainState.TrainStateType.InteriorLight);
        boolean useInteriorLighting = ((VehicleBaseConfig)modelSet.getConfig()).interiorLights != null && value < 7;
        boolean customLighting = modelSet.modelObj.useShader;
        this.preRenderBody(modelSet, state, useInteriorLighting, customLighting);
        boolean canUseColor = ((VehicleBaseConfig)modelSet.getConfig()).useCustomColor;
        if (canUseColor) {
            GLHelper.setColor((int)vehicle.getResourceState().color, (int)255);
        }
        this.renderBody(vehicle, modelSet, RenderPass.NORMAL, par4);
        if (canUseColor) {
            GLHelper.setColor((int)0xFFFFFF, (int)255);
        }
        this.postRenderBody(modelSet, useInteriorLighting, customLighting);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    private void renderBodyLight(EntityVehicleBase vehicle, ModelSetVehicleBase modelSet, float par4) {
        boolean isTrain = vehicle instanceof EntityTrainBase;
        int dir = 0;
        byte mode = 0;
        boolean isFrontEmpty = false;
        boolean isBackEmpty = false;
        if (isTrain) {
            EntityTrainBase train = (EntityTrainBase)vehicle;
            dir = train.getTrainDirection();
            mode = train.getVehicleState(TrainState.TrainStateType.Light);
            isFrontEmpty = train.getConnectedTrain(dir) == null;
            isBackEmpty = train.getConnectedTrain(1 - dir) == null;
        }
        for (int i = 0; i < 3; ++i) {
            RenderPass pass;
            boolean isLightON;
            boolean doRender = false;
            if (isTrain && ((TrainConfig)modelSet.getConfig()).isSingleTrain && isFrontEmpty && isBackEmpty) {
                switch (i) {
                    case 0: {
                        doRender = mode == 0 || mode == 1;
                        break;
                    }
                    case 1: {
                        doRender = mode == 1 && dir == 0 || mode == 2;
                        break;
                    }
                    case 2: {
                        doRender = mode == 1 && dir == 1 || mode == 2;
                    }
                }
            } else {
                switch (i) {
                    case 0: {
                        doRender = mode == 0 || mode == 1;
                        break;
                    }
                    case 1: {
                        doRender = mode == 1 && isFrontEmpty || mode == 2;
                        break;
                    }
                    case 2: {
                        boolean bl = doRender = mode == 1 && !isFrontEmpty && isBackEmpty || mode == 2;
                    }
                }
            }
            if (!doRender) continue;
            boolean bl = isLightON = i > 0;
            if (isLightON) {
                GLHelper.disableLighting();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                GLHelper.setLightmapMaxBrightness();
            }
            switch (i) {
                case 1: {
                    pass = RenderPass.LIGHT_FRONT;
                    break;
                }
                case 2: {
                    pass = RenderPass.LIGHT_BACK;
                    break;
                }
                default: {
                    pass = RenderPass.LIGHT;
                }
            }
            this.renderBody(vehicle, modelSet, pass, par4);
            if (!isLightON) continue;
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GLHelper.enableLighting();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (modelSet.modelObj.renderer.shouldRenderOutline(vehicle)) {
            GLHelper.disableLighting();
            GLHelper.setLightmapMaxBrightness();
            modelSet.modelObj.renderWithTexture(vehicle, RenderPass.OUTLINE, par4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLHelper.enableLighting();
        }
    }

    private void renderBodyTransparent(EntityVehicleBase vehicle, ModelSetVehicleBase modelSet, float par4) {
        GL11.glAlphaFunc((int)513, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderBody(vehicle, modelSet, RenderPass.TRANSPARENT, par4);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    protected void renderRollsign(EntityVehicleBase vehicle, ModelSetVehicleBase modelset) {
        GL11.glPushMatrix();
        this.func_110776_a(modelset.rollsignTexture);
        for (int i = 0; i < ((VehicleBaseConfig)modelset.getConfig()).rollsigns.length; ++i) {
            VehicleBaseConfig.Rollsign rollsign = ((VehicleBaseConfig)modelset.getConfig()).rollsigns[i];
            if (!rollsign.disableLighting) {
                GLHelper.disableLighting();
                GLHelper.setLightmapMaxBrightness();
            }
            float f0 = (rollsign.uv[3] - rollsign.uv[2]) / (float)((VehicleBaseConfig)modelset.getConfig()).rollsignNames.length;
            float uMin = rollsign.uv[0];
            float uMax = rollsign.uv[1];
            float f1 = 0.0f;
            if (vehicle instanceof EntityTrainBase) {
                EntityTrainBase train = (EntityTrainBase)vehicle;
                f1 = rollsign.doAnimation ? train.getRollsignAnimation() : (float)train.getVehicleState(TrainState.TrainStateType.Destination);
            }
            float vMin = rollsign.uv[2] + f0 * f1;
            float vMax = rollsign.uv[2] + f0 * (f1 + 1.0f);
            NGTTessellator tessellator = NGTTessellator.instance;
            tessellator.startDrawingQuads();
            for (int j = 0; j < ((VehicleBaseConfig)modelset.getConfig()).rollsigns[i].pos.length; ++j) {
                tessellator.addVertexWithUV(rollsign.pos[j][3][0], rollsign.pos[j][3][1], rollsign.pos[j][3][2], uMin, vMin);
                tessellator.addVertexWithUV(rollsign.pos[j][2][0], rollsign.pos[j][2][1], rollsign.pos[j][2][2], uMin, vMax);
                tessellator.addVertexWithUV(rollsign.pos[j][1][0], rollsign.pos[j][1][1], rollsign.pos[j][1][2], uMax, vMax);
                tessellator.addVertexWithUV(rollsign.pos[j][0][0], rollsign.pos[j][0][1], rollsign.pos[j][0][2], uMax, vMin);
            }
            tessellator.draw();
            if (rollsign.disableLighting) continue;
            GLHelper.enableLighting();
        }
        GL11.glPopMatrix();
    }

    private int getLightValue(EntityVehicleBase vehicle) {
        int blockLight;
        int skyLight2;
        World world = NGTUtil.getClientWorld();
        int x = NGTMath.floor((double)vehicle.field_70165_t);
        int y = NGTMath.floor((double)(vehicle.field_70163_u + 0.5));
        int z = NGTMath.floor((double)vehicle.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        int skyLight1 = NGTMath.floor((float)(world.func_72971_b(1.0f) * 15.0f));
        int skyLight = skyLight1 * (skyLight2 = world.func_175642_b(EnumSkyBlock.SKY, pos)) / 15;
        return skyLight > (blockLight = world.func_175642_b(EnumSkyBlock.BLOCK, pos)) ? skyLight : blockLight;
    }

    private void renderLightEffect(EntityVehicleBase vehicle, ModelSetVehicleBase modelset) {
        boolean b2;
        boolean isTrain = vehicle instanceof EntityTrainBase;
        int dir = 0;
        byte mode = vehicle.getVehicleState(TrainState.TrainStateType.Light);
        boolean b0 = false;
        boolean b1 = false;
        if (isTrain) {
            EntityTrainBase train = (EntityTrainBase)vehicle;
            dir = train.getTrainDirection();
            b0 = train.getConnectedTrain(dir) == null;
            b1 = train.getConnectedTrain(1 - dir) == null;
        } else {
            b1 = true;
            b0 = true;
        }
        if (((VehicleBaseConfig)modelset.getConfig()).headLights == null || ((VehicleBaseConfig)modelset.getConfig()).tailLights == null || mode <= 0) {
            return;
        }
        GL11.glPushMatrix();
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        int value = this.getLightValue(vehicle);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        int renderModeHead = -1;
        int renderModeTail = -1;
        boolean bl = b2 = isTrain && ((TrainConfig)modelset.getConfig()).isSingleTrain && b0 && b1;
        if (b2) {
            int n = mode == 1 ? dir : (renderModeHead = mode == 2 ? 2 : -1);
            renderModeTail = mode == 1 ? 1 - dir : (mode == 2 ? 2 : -1);
        } else {
            renderModeHead = mode == 1 && b0 || mode == 2 ? 0 : -1;
            renderModeTail = mode == 1 && !b0 && b1 || mode == 2 ? 0 : -1;
        }
        Vec3 vec = PooledVec3.create((double)0.0, (double)0.0, (double)1.0);
        vec = vec.rotateAroundY(vehicle.field_70177_z);
        vec = vec.rotateAroundZ(vehicle.field_70125_A);
        this.lightVecF.set((float)vec.getX(), (float)vec.getY(), (float)vec.getZ());
        if (renderModeHead >= 0) {
            for (VehicleBaseConfig.Light light : ((VehicleBaseConfig)modelset.getConfig()).headLights) {
                if (light.type == 1 && value > 7) continue;
                this.renderLightEffect(vehicle, this.lightVecF, light, renderModeHead);
            }
        }
        if (renderModeTail >= 0) {
            for (VehicleBaseConfig.Light light : ((VehicleBaseConfig)modelset.getConfig()).tailLights) {
                if (light.type == 1 && value > 7) continue;
                this.renderLightEffect(vehicle, this.lightVecF, light, renderModeTail);
            }
        }
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GLHelper.enableLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderLightEffect(EntityVehicleBase vehicle, Vector3f normal, VehicleBaseConfig.Light light, int mode) {
        if (mode == 2) {
            this.renderLightEffect(vehicle, normal, light, 0);
            this.renderLightEffect(vehicle, normal, light, 1);
            return;
        }
        Vec3 vec = PooledVec3.create((double)light.pos[0], (double)light.pos[1], (double)light.pos[2]);
        vec = vec.rotateAroundY(vehicle.field_70177_z);
        vec = vec.rotateAroundZ(vehicle.field_70125_A);
        vec = vec.add(vehicle.field_70165_t, vehicle.field_70163_u, vehicle.field_70161_v);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)light.pos[0], (float)light.pos[1], (float)(mode == 0 ? light.pos[2] : -light.pos[2]));
        if (mode == 1) {
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        }
        PartsRenderer.renderLightEffectS(normal, vec.getX(), vec.getY(), vec.getZ(), light.r, 0.0625f, 16.0f, light.color, light.type, mode == 1);
        if (mode == 1) {
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        }
        GL11.glPopMatrix();
    }

    protected void renderVehicleNGTO(EntityVehicle vehicle, VehicleNGTO vngto, float par4) {
        boolean smoothing;
        GL11.glScalef((float)vngto.scale, (float)vngto.scale, (float)vngto.scale);
        GL11.glTranslatef((float)vngto.offsetX, (float)vngto.offsetY, (float)vngto.offsetZ);
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass < 0 || pass > 1) {
            return;
        }
        if (vngto.glLists == null) {
            vngto.glLists = new GLObject[2];
        }
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        this.func_110776_a(TextureMap.field_110575_b);
        boolean bl = smoothing = NGTUtilClient.getMinecraft().field_71474_y.field_74348_k != 0;
        if (smoothing) {
            GL11.glShadeModel((int)7425);
        }
        if (!GLHelper.isValid((GLObject)vngto.glLists[pass])) {
            vngto.glLists[pass] = GLHelper.generateGLList((GLObject)vngto.glLists[pass]);
            GLHelper.startCompile((GLObject)vngto.glLists[pass]);
            NGTWorld world = new NGTWorld(vehicle.func_130014_f_(), vngto.ngto);
            NGTObjectRenderer.INSTANCE.renderNGTObject((IBlockAccessNGT)world, vngto.ngto, false, 0, pass);
            GLHelper.endCompile();
        } else {
            GLHelper.callList((GLObject)vngto.glLists[pass]);
        }
        if (smoothing) {
            GL11.glShadeModel((int)7424);
        }
        GLHelper.enableLighting();
        NGTUtilClient.getMinecraft().field_71460_t.func_180436_i();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected ResourceLocation getEntityTexture(EntityVehicleBase par1) {
        return null;
    }

    protected boolean bindEntityTexture(EntityVehicleBase entiy) {
        return false;
    }

    public void doRender(EntityVehicleBase par1, double par2, double par4, double par6, float par8, float par9) {
    }

    public boolean shouldRender(EntityVehicleBase entity, ICamera camera, double camX, double camY, double camZ) {
        return false;
    }

    private void debugCollision(EntityVehicleBase vehicle) {
        ModelSetVehicleBase modelSet;
        if (MinecraftForgeClient.getRenderPass() == 1 && (modelSet = (ModelSetVehicleBase)vehicle.getResourceState().getResourceSet()) != null && modelSet.getCollisionObj() != null) {
            modelSet.getCollisionObj().checkAndRenderCollision((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Entity)vehicle, vehicle.getResourceState().exclusionParts);
        }
    }
}

