/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.event;

import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.ClientProxy;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMSound;
import jp.ngt.rtm.block.decoration.DecorationStore;
import jp.ngt.rtm.entity.RenderBullet;
import jp.ngt.rtm.entity.npc.EntityNPC;
import jp.ngt.rtm.entity.train.parts.EntityFloor;
import jp.ngt.rtm.gui.GuiIngameCustom;
import jp.ngt.rtm.gui.camera.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RTMEventHandlerClient {
    private final GuiIngameCustom guiInGame;

    public RTMEventHandlerClient(Minecraft par1) {
        this.guiInGame = new GuiIngameCustom(par1);
    }

    @SubscribeEvent
    public void onTick(RenderWorldLastEvent event) {
        byte viewMode = ClientProxy.getViewMode((EntityPlayer)NGTUtilClient.getMinecraft().field_71439_g);
        if (viewMode == 4) {
            Camera.INSTANCE.onRenderWorldPost();
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Pre event) {
        byte viewMode = ClientProxy.getViewMode((EntityPlayer)NGTUtilClient.getMinecraft().field_71439_g);
        if (viewMode == 4) {
            Camera.INSTANCE.onRenderGameOverlayPre();
        }
        this.guiInGame.onRenderGui(event);
    }

    @SubscribeEvent
    public void onUpdateFOV(FOVUpdateEvent event) {
        event.setNewfov(RTMCore.proxy.getFov(event.getEntity(), event.getFov()));
    }

    @SubscribeEvent
    public void onLoadSound(SoundLoadEvent event) {
        RTMSound.registerSoundDomains();
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        DecorationStore.INSTANCE.onTextureStitch(event.getMap());
    }

    private boolean isPlayerSittingSeat(EntityPlayer player, byte type) {
        return player.func_184218_aH() && player.func_184187_bx() instanceof EntityFloor && ((EntityFloor)player.func_184187_bx()).getSeatType() == type;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (this.isPlayerSittingSeat(event.getEntityPlayer(), (byte)3)) {
            GL11.glPushMatrix();
            event.getRenderer().func_177087_b().field_78093_q = false;
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (this.isPlayerSittingSeat(event.getEntityPlayer(), (byte)3)) {
            event.getRenderer().func_177087_b().field_78093_q = true;
            GL11.glPopMatrix();
        }
        RenderBullet.onPlayerRender(event.getEntityPlayer(), false);
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        this.renderEntityPre(event.getEntity(), event.getRenderer(), event.getX(), event.getY(), event.getZ());
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Post event) {
        EntityLivingBase entity = event.getEntity();
        this.renderEntityPost(entity, event.getRenderer(), event.getX(), event.getY(), event.getZ());
        if (entity instanceof EntityNPC) {
            RenderBullet.onNPCRender((EntityNPC)entity, event.getX(), event.getY(), event.getZ());
        }
    }

    @SubscribeEvent
    public void onRenderPlayerHand(RenderHandEvent event) {
        EntityPlayerSP player = NGTUtilClient.getMinecraft().field_71439_g;
        byte viewMode = ClientProxy.getViewMode((EntityPlayer)player);
        if (viewMode >= 0 && viewMode < 3) {
            event.setCanceled(true);
        }
        RenderBullet.onPlayerRender((EntityPlayer)player, true);
    }

    public void renderEntityPre(EntityLivingBase entity, RenderLivingBase renderer, double x, double y, double z) {
        if (!this.isPlayerWearedNVD(entity)) {
            return;
        }
        GLHelper.disableLighting();
        GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
        GLHelper.setLightmapMaxBrightness();
    }

    public void renderEntityPost(EntityLivingBase entity, RenderLivingBase renderer, double x, double y, double z) {
        if (!this.isPlayerWearedNVD(entity)) {
            return;
        }
        GLHelper.enableLighting();
    }

    private boolean isPlayerWearedNVD(EntityLivingBase entity) {
        EntityPlayerSP viewer = NGTUtilClient.getMinecraft().field_71439_g;
        return entity != viewer && ClientProxy.getViewMode((EntityPlayer)viewer) == 3;
    }
}

