/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.event;

import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.npc.macro.MacroRecorder;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.train.util.EnumNotch;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.entity.vehicle.EntityPlane;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import jp.ngt.rtm.network.PacketRTMKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public final class RTMKeyHandlerClient {
    private static final String CATG_RTM = "key.rtm.category";
    public static final RTMKeyHandlerClient INSTANCE = new RTMKeyHandlerClient();
    public static final KeyBinding KEY_HORN = new KeyBinding("key.rtm.horn", 25, "key.rtm.category");
    public static final KeyBinding KEY_CHIME = new KeyBinding("key.rtm.chime", 23, "key.rtm.category");
    public static final KeyBinding KEY_ATS = new KeyBinding("key.rtm.ats", 51, "key.rtm.category");
    public static final KeyBinding KEY_EB = new KeyBinding("key.rtm.eb", 6, "key.rtm.category");
    public static final KeyBinding KEY_CHIME_NEXT = new KeyBinding("key.rtm.chime_next", 205, "key.rtm.category");
    public static final KeyBinding KEY_CHIME_PREV = new KeyBinding("key.rtm.chime_prev", 203, "key.rtm.category");
    private boolean sneaking;

    private RTMKeyHandlerClient() {
    }

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_HORN);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_CHIME);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_ATS);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_EB);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_CHIME_NEXT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_CHIME_PREV);
    }

    public void onTickStart() {
        Minecraft mc = NGTUtilClient.getMinecraft();
        EntityPlayerSP player = mc.field_71439_g;
        if (Keyboard.isKeyDown((int)mc.field_71474_y.field_74314_A.func_151463_i())) {
            if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityVehicle) {
                this.sendKeyToServer((byte)9, "");
            }
        } else if (Keyboard.isKeyDown((int)mc.field_71474_y.field_74311_E.func_151463_i()) && player.func_184218_aH() && player.func_184187_bx() instanceof EntityPlane && !player.func_184187_bx().field_70122_E) {
            this.sendKeyToServer((byte)10, "");
        }
    }

    public void onTickEnd() {
    }

    @SubscribeEvent
    public void keyDown(InputEvent.KeyInputEvent event) {
        Minecraft mc = NGTUtilClient.getMinecraft();
        EntityPlayerSP player = mc.field_71439_g;
        Entity riding = player.func_184187_bx();
        if (mc.field_71474_y.field_74368_y.func_151468_f()) {
            if (player.func_184218_aH() && riding instanceof EntityTrainBase) {
                ((EntityTrainBase)riding).syncNotch(1);
            }
        } else if (mc.field_71474_y.field_74351_w.func_151468_f()) {
            if (player.func_184218_aH() && riding instanceof EntityTrainBase) {
                ((EntityTrainBase)riding).syncNotch(-1);
            }
        } else if (!mc.field_71474_y.field_74314_A.func_151470_d()) {
            if (mc.field_71474_y.field_74311_E.func_151470_d()) {
                if (player.func_184218_aH() && riding instanceof EntityPlane && ((EntityPlane)riding).disableUnmount()) {
                    this.unpressKey(mc.field_71474_y.field_74311_E);
                }
            } else if (KEY_HORN.func_151468_f()) {
                if (player.func_184218_aH()) {
                    if (riding instanceof EntityTrainBase) {
                        this.playSound((EntityPlayer)player, (byte)2);
                    } else if (riding instanceof EntityArtillery) {
                        this.sendKeyToServer((byte)5, "");
                    }
                }
            } else if (KEY_CHIME.func_151468_f()) {
                this.playSound((EntityPlayer)player, (byte)3);
            } else if (mc.field_71474_y.field_151445_Q.func_151470_d()) {
                if (player.func_184218_aH() && riding instanceof EntityVehicleBase) {
                    mc.field_71474_y.field_151445_Q.func_151468_f();
                    this.sendKeyToServer((byte)4, "");
                }
            } else if (KEY_ATS.func_151468_f()) {
                this.sendKeyToServer((byte)6, "");
            }
        }
        if (player.func_184218_aH() && riding instanceof EntityTrainBase) {
            EntityTrainBase train = (EntityTrainBase)riding;
            if (KEY_EB.func_151468_f()) {
                train.syncVehicleState(TrainState.TrainStateType.Notch, (byte)EnumNotch.emergency_brake.id);
                this.playSound((EntityPlayer)player, (byte)2);
                NGTLog.showChatMessage((ITextComponent)new TextComponentString("Push EB"));
            } else if (KEY_CHIME_NEXT.func_151468_f()) {
                TrainState.TrainStateType type = TrainState.TrainStateType.Announcement;
                int i0 = train.getVehicleState(type) + 1;
                i0 = i0 < type.min ? type.max : (i0 > type.max ? 0 : i0);
                train.syncVehicleState(type, (byte)i0);
                NGTLog.showChatMessage((ITextComponent)new TextComponentString("Next chime"));
            } else if (KEY_CHIME_PREV.func_151468_f()) {
                TrainState.TrainStateType type = TrainState.TrainStateType.Announcement;
                int i0 = train.getVehicleState(type) - 1;
                i0 = i0 < type.min ? type.max : (i0 > type.max ? 0 : i0);
                train.syncVehicleState(type, (byte)i0);
                NGTLog.showChatMessage((ITextComponent)new TextComponentString("Prev chime"));
            }
        }
    }

    private void unpressKey(KeyBinding key) {
        NGTUtil.getMethod(KeyBinding.class, (Object)key, (String)"unpressKey", (String)"func_74505_d", (Class[])new Class[0], (Object[])new Object[0]);
    }

    private void sendKeyToServer(byte keyCode, String sound) {
        EntityPlayerSP player = NGTUtilClient.getMinecraft().field_71439_g;
        RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketRTMKey((EntityPlayer)player, keyCode, sound));
    }

    private void playSound(EntityPlayer player, byte key) {
        EntityTrainBase train;
        ModelSetTrain modelset;
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityTrainBase && (modelset = (ModelSetTrain)(train = (EntityTrainBase)player.func_184187_bx()).getResourceState().getResourceSet()) != null) {
            String sound = "";
            if (key == 2) {
                sound = ((TrainConfig)modelset.getConfig()).sound_Horn;
                MacroRecorder.INSTANCE.recHorn(player.field_70170_p);
            } else if (key == 3) {
                byte index = train.getVehicleState(TrainState.TrainStateType.Announcement);
                String[][] sa0 = ((TrainConfig)modelset.getConfig()).sound_Announcement;
                if (sa0 != null && index < sa0.length) {
                    sound = sa0[index][1];
                    MacroRecorder.INSTANCE.recChime(player.field_70170_p, sa0[index][1]);
                }
            }
            if (!sound.isEmpty()) {
                this.sendKeyToServer(key, sound);
            }
        }
    }
}

