/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.event;

import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public final class RTMKeyHandlerServer {
    public static final RTMKeyHandlerServer INSTANCE = new RTMKeyHandlerServer();

    private RTMKeyHandlerServer() {
    }

    public void onKeyDown(EntityPlayer player, byte keyCode, String sound) {
        switch (keyCode) {
            case 9: {
                this.setVehicleState(player, 1);
                break;
            }
            case 10: {
                this.setVehicleState(player, -1);
                break;
            }
            case 2: {
                this.playSound(player, sound, 10000.0f);
                break;
            }
            case 3: {
                this.playSound(player, sound, 1.0f);
                break;
            }
            case 4: {
                player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdTrainControlPanel, player.field_70170_p, player.func_184187_bx().func_145782_y(), 0, 0);
                break;
            }
            case 5: {
                if (!player.func_184218_aH() || !(player.func_184187_bx() instanceof EntityArtillery)) break;
                ((EntityArtillery)player.func_184187_bx()).onFireKeyDown(player);
                break;
            }
            case 6: {
                this.setATS(player);
            }
        }
    }

    private void setVehicleState(EntityPlayer player, int updown) {
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)player.func_184187_bx();
            vehicle.setUpDown(updown);
        }
    }

    private void playSound(EntityPlayer player, String sound, float vol) {
        EntityTrainBase train = this.getRidingTrain(player);
        if (train != null && sound != null) {
            RTMCore.proxy.playSound((Entity)train, sound, vol, 1.0f);
        }
    }

    private void setATS(EntityPlayer player) {
        EntityTrainBase train = this.getRidingTrain(player);
        if (train != null) {
            int signal = train.getSignal();
            if (signal == 1) {
                train.setSignal2(-1);
            } else if (signal == -1 && train.getNotch() == -8) {
                train.setSignal2(0);
            }
        }
    }

    private EntityTrainBase getRidingTrain(EntityPlayer player) {
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityTrainBase) {
            return (EntityTrainBase)player.func_184187_bx();
        }
        return null;
    }
}

