/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.gui.GuiSelectModel;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.DataEntry;
import jp.ngt.rtm.modelpack.state.DataFormatter;
import jp.ngt.rtm.modelpack.state.IDataFilter;
import jp.ngt.rtm.modelpack.state.ResourceState;

public class DataMapEditor
extends JFrame {
    private static final int DATA_COL = 2;
    private final GuiSelectModel parentGui;
    private final Map<String, IDataFilter> filterMap = new HashMap<String, IDataFilter>();

    public DataMapEditor(GuiSelectModel gui) {
        this.parentGui = gui;
        this.init();
        this.setVisible(true);
    }

    private void init() {
        int scale = NGTUtilClient.getMinecraft().field_71440_d / 720;
        scale = scale <= 0 ? 1 : scale;
        int fontSize = 16 * scale;
        Font font = new Font("Arial", 0, fontSize);
        this.setDefaultCloseOperation(2);
        this.setBounds(32, 32, 480 * scale, 640 * scale);
        this.setTitle("DataMap Editor");
        ResourceState state = this.parentGui.selector.getResourceState();
        TreeMap<String, DataEntry> map = new TreeMap<String, DataEntry>();
        map.putAll(state.dataMap.getEntries());
        String[][] rowData = new String[map.size()][3];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            rowData[i++] = new String[]{(String)entry.getKey(), ((DataEntry)entry.getValue()).getType().key, ((DataEntry)entry.getValue()).toString()};
            IDataFilter filter = ((ResourceSet)state.getResourceSet()).dataFormatter.getFilter((String)entry.getKey());
            if (filter == null) continue;
            this.filterMap.put((String)entry.getKey(), filter);
        }
        String[] columnNames = new String[]{"Key", "Type", "Data"};
        DMEditorTable table = new DMEditorTable(font, fontSize, rowData, columnNames);
        JScrollPane scrollPane = new JScrollPane(table);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton buttonOK = new JButton("OK");
        buttonOK.setFont(font);
        buttonOK.addActionListener(event -> {
            for (int j = 0; j < rowData.length; ++j) {
                String key = (String)table.getModel().getValueAt(j, 0);
                String value = String.format("(%s)%s", (String)table.getModel().getValueAt(j, 1), (String)table.getModel().getValueAt(j, 2));
                state.dataMap.set(key, value, 3);
            }
            this.parentGui.argField.func_146180_a(state.getArg());
            this.parentGui.saveData(state);
            this.dispose();
        });
        buttonPanel.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setFont(font);
        buttonCancel.addActionListener(event -> this.dispose());
        buttonPanel.add(buttonCancel);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public class DMECellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final String[][] suggestions;
        private JTextField text;
        private JComboBox combo;
        private Object value;
        private Component editor;

        public DMECellEditor(Font font, String[][] sug) {
            this.suggestions = sug;
            this.text = new JTextField();
            this.text.setFont(font);
            this.text.setBorder(BorderFactory.createEmptyBorder());
            this.combo = new JComboBox();
            this.combo.setFont(font);
            this.combo.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Object getCellEditorValue() {
            return this.getCellValue();
        }

        @Override
        public boolean stopCellEditing() {
            if (this.editor instanceof JComboBox && this.combo.isEditable()) {
                this.combo.actionPerformed(new ActionEvent(this, 0, ""));
            }
            this.value = this.getCellValue();
            return super.stopCellEditing();
        }

        private Object getCellValue() {
            if (this.editor instanceof JComboBox) {
                return ((JComboBox)this.editor).getSelectedItem();
            }
            if (this.editor instanceof JTextField) {
                return ((JTextField)this.editor).getText();
            }
            return "";
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String[] sa = this.suggestions[row];
            if (sa.length > 0) {
                this.combo.removeAllItems();
                for (String s : sa) {
                    this.combo.addItem(s);
                }
                this.combo.setSelectedItem(value);
                this.editor = this.combo;
            } else {
                this.text.setText(value.toString());
                this.editor = this.text;
            }
            return this.editor;
        }
    }

    public class DMEditorTable
    extends JTable {
        public DMEditorTable(Font font, int fontSize, final String[][] rowData, String[] columnNames) {
            super(new DefaultTableModel(rowData, columnNames){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 2;
                }

                @Override
                public void setValueAt(Object aValue, int row, int column) {
                    if (column == 2) {
                        String key = rowData[row][0];
                        IDataFilter filter = (IDataFilter)DataMapEditor.this.filterMap.get(key);
                        if (filter != null && !filter.check(aValue)) {
                            return;
                        }
                    }
                    super.setValueAt(aValue, row, column);
                }
            });
            this.setFont(font);
            this.setRowHeight(fontSize);
            DataFormatter formatter = ((ResourceSet)((DataMapEditor)DataMapEditor.this).parentGui.selector.getResourceState().getResourceSet()).dataFormatter;
            String[][] array = new String[rowData.length][];
            for (int i = 0; i < array.length; ++i) {
                String[] suggestions = formatter.getSuggestions(rowData[i][0]);
                array[i] = suggestions == null || suggestions.length == 0 ? new String[0] : suggestions;
            }
            this.getColumnModel().getColumn(2).setCellEditor(new DMECellEditor(font, array));
        }
    }
}

