/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.io.IOException;
import java.util.List;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.entity.npc.EntityNPC;
import jp.ngt.rtm.entity.npc.Menu;
import jp.ngt.rtm.entity.npc.MenuEntry;
import jp.ngt.rtm.gui.GuiNPC;
import jp.ngt.rtm.network.PacketSyncItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiSalesperson
extends GuiNPC {
    private final int MIN_SLOT_INDEX = 40;
    private final int MENU_BUTTON_ROW = 7;
    protected final boolean isOwner;
    protected final Menu menu;
    private MenuEntry selectedMenu;
    private int amountMoney = 0;
    private boolean showMenu = false;
    private int pageIndex = 0;
    private int maxPage = 0;
    private int selectedRow = 0;
    private String message = "";
    private final GuiButton[] delButtons = new GuiButton[7];
    private final MenuEntry[] menuItems = new MenuEntry[7];
    private final GuiButton[] decButtons = new GuiButton[7];
    private final GuiButton[] addButtons = new GuiButton[7];
    private final int[] itemCounts = new int[7];

    public GuiSalesperson(EntityPlayer par1, EntityNPC par2) {
        super(par1, par2);
        this.isOwner = par1.equals((Object)par2.func_70902_q());
        this.menu = new Menu(par2.getMenu());
        this.selectedMenu = this.menu.get(0);
        this.message = I18n.func_135052_a((String)"gui.npc.put_money", (Object[])new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.showMenu) {
            this.field_146292_n.add(new GuiButtonItem(200, this.field_147003_i + 90, this.field_147009_r + 26, 20, 20));
            this.field_146292_n.add(new GuiButton(201, this.field_147003_i + 85, this.field_147009_r + 49, 40, 20, I18n.func_135052_a((String)"gui.npc.buy", (Object[])new Object[0])));
            GuiButton button = new GuiButton(202, this.field_147003_i + 130, this.field_147009_r + 49, 40, 20, I18n.func_135052_a((String)"gui.npc.register", (Object[])new Object[0]));
            button.field_146124_l = this.isOwner;
            this.field_146292_n.add(button);
        } else {
            this.field_146292_n.clear();
            this.field_146292_n.add(new GuiButton(300, this.field_147003_i + this.field_146999_f / 2 - 20, this.field_147009_r + this.field_147000_g - 25, 40, 20, I18n.func_135052_a((String)"gui.npc.close", (Object[])new Object[0])));
            this.field_146292_n.add(new GuiButton(301, this.field_147003_i + this.field_146999_f - 70, this.field_147009_r + 5, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(302, this.field_147003_i + this.field_146999_f - 25, this.field_147009_r + 5, 20, 20, ">"));
            GuiButton bImport = new GuiButton(303, this.field_147003_i + 5, this.field_147009_r + 5, 40, 20, I18n.func_135052_a((String)"gui.npc.import", (Object[])new Object[0]));
            GuiButton bExport = new GuiButton(304, this.field_147003_i + 50, this.field_147009_r + 5, 40, 20, I18n.func_135052_a((String)"gui.npc.export", (Object[])new Object[0]));
            bImport.field_146124_l = this.isOwner;
            bExport.field_146124_l = this.isOwner;
            this.field_146292_n.add(bImport);
            this.field_146292_n.add(bExport);
            List<MenuEntry> list = this.menu.getList();
            for (int i = 0; i < 7; ++i) {
                int menuIndex = this.pageIndex * 7 + i;
                if (menuIndex < list.size()) {
                    int y = this.field_147009_r + 30 + i * 24;
                    this.delButtons[i] = new GuiButton(1000 + i, this.field_147003_i + 5, y, 20, 20, "X");
                    this.field_146292_n.add(this.delButtons[i]);
                    this.menuItems[i] = list.get(menuIndex);
                    this.decButtons[i] = new GuiButton(2000 + i, this.field_147003_i + this.field_146999_f - 60, y, 20, 20, "-");
                    this.field_146292_n.add(this.decButtons[i]);
                    this.addButtons[i] = new GuiButton(3000 + i, this.field_147003_i + this.field_146999_f - 25, y, 20, 20, "+");
                    this.field_146292_n.add(this.addButtons[i]);
                } else {
                    this.delButtons[i] = null;
                    this.menuItems[i] = null;
                    this.decButtons[i] = null;
                    this.addButtons[i] = null;
                }
                this.itemCounts[i] = 0;
            }
            this.maxPage = (this.menu.getList().size() - 1) / 7;
            this.selectRow(0);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (!this.showMenu) {
            if (button.field_146127_k == 200) {
                this.setPage(0);
            } else if (button.field_146127_k == 201) {
                if (!this.buy()) {
                    this.message = I18n.func_135052_a((String)"gui.npc.can_not_buy", (Object[])new Object[0]);
                }
            } else if (button.field_146127_k == 202) {
                this.message = this.registerItem() ? I18n.func_135052_a((String)"gui.npc.reg_successful", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.npc.reg_failed", (Object[])new Object[0]);
            }
        } else if (button.field_146127_k == 300) {
            MenuEntry entry = this.menuItems[this.selectedRow];
            int count = this.itemCounts[this.selectedRow];
            if (count > 0) {
                ItemStack item = entry.item.func_77946_l();
                item.func_190920_e(item.func_190916_E() * count);
                this.selectedMenu = new MenuEntry(item, entry.price * count);
            }
            this.setPage(-1);
        } else if (button.field_146127_k == 301) {
            if (this.pageIndex >= 1) {
                this.setPage(--this.pageIndex);
            }
        } else if (button.field_146127_k == 302) {
            if (this.pageIndex < this.maxPage) {
                this.setPage(++this.pageIndex);
            }
        } else if (button.field_146127_k == 303) {
            this.menu.importFromText();
            this.setPage(this.pageIndex);
        } else if (button.field_146127_k == 304) {
            this.menu.exportToText();
        } else if (button.field_146127_k >= 1000) {
            int count;
            int menuButtonType = button.field_146127_k / 1000;
            int menuIndex = button.field_146127_k % 1000;
            if (menuButtonType == 1) {
                int idx = this.pageIndex * 7 + menuIndex;
                this.menu.remove(idx);
                this.setPage(this.pageIndex);
            } else if (menuButtonType == 2) {
                int count2 = this.itemCounts[menuIndex];
                if (count2 > 0) {
                    this.itemCounts[menuIndex] = --count2;
                    this.selectRow(menuIndex);
                }
            } else if (menuButtonType == 3 && (count = this.itemCounts[menuIndex]) < this.menuItems[menuIndex].maxCount) {
                this.itemCounts[menuIndex] = ++count;
                this.selectRow(menuIndex);
            }
        }
    }

    private void setPage(int page) {
        if (page < 0) {
            this.showMenu = false;
        } else {
            this.pageIndex = page;
            this.showMenu = true;
        }
        this.func_73866_w_();
    }

    private void selectRow(int index) {
        this.selectedRow = index;
        boolean notSelected = this.itemCounts[this.selectedRow] <= 0;
        for (int i = 0; i < 7 && this.delButtons[i] != null; ++i) {
            boolean isSelected = this.selectedRow == i || notSelected;
            this.delButtons[i].field_146124_l = this.isOwner;
            this.addButtons[i].field_146124_l = this.itemCounts[i] < this.menuItems[i].maxCount && isSelected;
            this.decButtons[i].field_146124_l = this.itemCounts[i] > 0 && isSelected;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.npc.setMenu(this.menu.toString());
            PacketNBT.sendToServer((Entity)this.npc);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.showMenu) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            int money = this.selectedMenu.price - this.amountMoney;
            this.field_146289_q.func_78276_b(String.format("\uffe5%d", money), this.field_147003_i + 115, this.field_147009_r + 32, 0);
            this.field_146289_q.func_78276_b(this.message, this.field_147003_i + 83, this.field_147009_r + 72, 0xFF0000);
        } else {
            int i;
            this.func_146276_q_();
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73733_a(x0, y0, x0 + this.field_146999_f, y0 + this.field_147000_g, -2039584, -2039584);
            for (i = 0; i < this.field_146292_n.size(); ++i) {
                ((GuiButton)this.field_146292_n.get(i)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            this.field_146289_q.func_78276_b(String.format("%d/%d", this.pageIndex, this.maxPage), this.field_147003_i + this.field_146999_f - 45, this.field_147009_r + 10, 0);
            for (i = 0; i < 7 && this.menuItems[i] != null; ++i) {
                int y = this.field_147009_r + 35 + i * 24;
                MenuEntry entry = this.menuItems[i];
                GuiSalesperson.drawItem(this.field_146297_k, entry.item, this.field_147003_i + 27, y - 3);
                this.field_146289_q.func_78276_b(entry.item.func_82833_r(), this.field_147003_i + 50, y - 5, 0);
                this.field_146289_q.func_78276_b(String.format("\uffe5%d", entry.price), this.field_147003_i + 50, y + 5, 0);
                this.field_146289_q.func_78276_b(String.format("%d", this.itemCounts[i]), this.field_147003_i + this.field_146999_f - 35, y, 0);
            }
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slot, slotId, mouseButton, type);
        this.amountMoney = this.countMoney(false);
        this.message = this.amountMoney > 0 ? I18n.func_135052_a((String)"gui.npc.push_buy", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.npc.put_money", (Object[])new Object[0]);
    }

    private boolean buy() {
        int amount = this.countMoney(false);
        if (amount < this.selectedMenu.price) {
            return false;
        }
        this.countMoney(true);
        boolean passed = false;
        amount -= this.selectedMenu.price;
        block0: for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            int maxId;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (slot.field_75222_d < 40 || slot.func_75216_d()) continue;
            if (!passed) {
                this.changeSlot(this.selectedMenu.item.func_77946_l(), i);
                passed = true;
                continue;
            }
            if (amount <= 0) break;
            for (int id = maxId = RTMItem.MoneyType.values().length - 1; id >= 0; --id) {
                int price = RTMItem.MoneyType.getPrice(id);
                if (amount < price) continue;
                int count = amount / price;
                amount -= count * price;
                this.changeSlot(new ItemStack(RTMItem.money, count, id), i);
                continue block0;
            }
        }
        return true;
    }

    private boolean registerItem() {
        ItemStack item = ((Slot)this.field_147002_h.field_75151_b.get(40)).func_75211_c();
        int price = this.countMoney(false);
        if (!item.func_190926_b() && !this.isMoney(item) && price > 0) {
            return this.menu.add(new MenuEntry(item.func_77946_l(), price));
        }
        return false;
    }

    private int countMoney(boolean pay) {
        int amount = 0;
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            ItemStack item;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (slot.field_75222_d < 40 || !this.isMoney(item = slot.func_75211_c())) continue;
            amount += RTMItem.MoneyType.getPrice(item.func_77952_i()) * item.func_190916_E();
            if (!pay) continue;
            this.changeSlot(ItemStack.field_190927_a, i);
        }
        return amount;
    }

    private boolean isMoney(ItemStack item) {
        return item.func_77973_b() == RTMItem.money;
    }

    private void changeSlot(ItemStack item, int id) {
        RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketSyncItem(this.player, item, id));
    }

    private static void drawItem(Minecraft mc, ItemStack item, int x, int y) {
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, item, x, y);
        mc.func_175599_af().func_180453_a(mc.field_71466_p, item, x, y, null);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
    }

    public class GuiButtonItem
    extends GuiButton {
        public GuiButtonItem(int buttonId, int x, int y, int widthIn, int heightIn) {
            super(buttonId, x, y, widthIn, heightIn, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            GuiSalesperson.drawItem(mc, ((GuiSalesperson)GuiSalesperson.this).selectedMenu.item, this.field_146128_h + 2, this.field_146129_i + 2);
        }
    }
}

