/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.entity.fluid.EntityFluid;
import jp.ngt.rtm.entity.fluid.FluidType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBucketLiquid
extends ItemCustom {
    private static final FluidType[] FLUID_LIST = new FluidType[]{FluidType.PIG_IRON, FluidType.STEEL};
    public static final int MAX_COUNT = 16;

    public ItemBucketLiquid() {
        this.field_77777_bU = 1;
        this.func_77656_e(15);
        this.func_77627_a(true);
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        EntityPlayer player;
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        RayTraceResult mop = this.func_77621_a(world, player = holder.getPlayer(), false);
        if (mop == null) {
            return holder.success();
        }
        FluidType type = ItemBucketLiquid.getFluidType(holder.getItemStack());
        if (type != null) {
            int amount = 16 - itemStack.func_77952_i();
            holder.setItemStack(ItemBucketLiquid.useBucket(world, player, mop, type, amount, holder.getItemStack(), player.field_71075_bZ.field_75098_d));
        }
        return holder.success();
    }

    public static ItemStack useBucket(World world, EntityPlayer player, RayTraceResult target, FluidType type, int amount, ItemStack item, boolean isCreative) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            float temp;
            int x = target.func_178782_a().func_177958_n();
            int y = target.func_178782_a().func_177956_o();
            int z = target.func_178782_a().func_177952_p();
            if (type != null) {
                x += target.field_178784_b.func_176730_m().func_177958_n();
                y += target.field_178784_b.func_176730_m().func_177956_o();
                z += target.field_178784_b.func_176730_m().func_177952_p();
            }
            if (type != null && player.func_175151_a(new BlockPos(x, y, z), target.field_178784_b, item) && ItemBucketLiquid.setFluid(world, x, y, z, type, amount, temp = ItemBucketLiquid.getTemperture(item))) {
                return isCreative ? item : new ItemStack(Items.field_151133_ar);
            }
        }
        return item;
    }

    public static boolean setFluid(World world, int x, int y, int z, FluidType type, int amount, float tempreture) {
        return ItemBucketLiquid.setFluid(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, type, amount, tempreture);
    }

    public static boolean setFluid(World world, double x, double y, double z, FluidType type, int amount, float temperture) {
        if (!world.field_72995_K) {
            double fluc = 0.75;
            for (int i = 0; i < amount; ++i) {
                double d0 = (double)(i + 1) / (double)amount;
                EntityFluid fluid = new EntityFluid(world);
                fluid.func_70107_b(x + (world.field_73012_v.nextDouble() - 0.5) * fluc * d0, y, z + (world.field_73012_v.nextDouble() - 0.5) * fluc * d0);
                fluid.setTemperture(temperture);
                fluid.setFluidType(type);
                world.func_72838_d((Entity)fluid);
            }
        }
        return true;
    }

    public static boolean pickupFluid(EntityPlayer player, EntityFluid fluid) {
        int count = 0;
        if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.bucketLiquid)) {
            count = 16 - player.func_184614_ca().func_77952_i();
            if (count >= 16) {
                return false;
            }
            if (ItemBucketLiquid.getFluidType(player.func_184614_ca()) != fluid.getFluidType()) {
                return false;
            }
        }
        int oldCount = count;
        if (!player.func_130014_f_().field_72995_K) {
            List list = player.func_130014_f_().func_72872_a(EntityFluid.class, fluid.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0));
            for (EntityFluid fluid2 : list) {
                if (fluid2.getFluidType() != fluid.getFluidType() || count >= 16) continue;
                fluid2.func_70106_y();
                ++count;
            }
            if (!player.func_184812_l_() && count > oldCount) {
                ItemStack itemstack = ItemBucketLiquid.getItem(fluid.getFluidType(), count - 1, fluid.getTemperature());
                player.func_184611_a(EnumHand.MAIN_HAND, itemstack);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (FluidType type : FLUID_LIST) {
            list.add((Object)ItemBucketLiquid.getItem(type, 15, type.meltingPoint));
        }
    }

    protected void addInformation(ItemArgHolderBase.ItemArgHolder holder, List<String> list, ITooltipFlag flag) {
        FluidType type = ItemBucketLiquid.getFluidType(holder.getItemStack());
        if (type != null) {
            list.add(TextFormatting.GRAY + type.toString());
            int amount = 16 - holder.getItemStack().func_77952_i();
            list.add(TextFormatting.GRAY + String.format("%d/16", amount));
        }
    }

    private static ItemStack getItem(FluidType type, int amount, float temperture) {
        ItemStack itemstack = new ItemStack(RTMItem.bucketLiquid, 1, 16 - amount - 1);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("type", type.toString());
        nbt.func_74776_a("temperture", temperture);
        itemstack.func_77982_d(nbt);
        return itemstack;
    }

    @Nullable
    public static FluidType getFluidType(ItemStack stack) {
        String type;
        if (stack.func_77942_o() && (type = stack.func_77978_p().func_74779_i("type")) != null && !type.isEmpty()) {
            return FluidType.valueOf(type);
        }
        return null;
    }

    public static float getTemperture(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g("temperture");
        }
        return 0.0f;
    }
}

