/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.block.tileentity.TileEntityPaint;
import jp.ngt.rtm.item.PaintProperty;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPaintTool
extends ItemCustom {
    public ItemPaintTool() {
        this.func_77625_d(1);
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdPaintTool, world, player.func_145782_y(), 0, 0);
            }
        } else {
            player.func_184598_c(holder.getHand());
        }
        return holder.success();
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        return holder.pass();
    }

    public void usePaintTool(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int dir, float fx, float fy, float fz) {
        int i;
        if (world.field_72995_K) {
            return;
        }
        PaintProperty prop = PaintProperty.getProperty(itemStack);
        int[] ia = BlockUtil.facing[dir];
        int bx = (int)(fx * 16.0f);
        int by = (int)(fy * 16.0f);
        int bz = (int)(fz * 16.0f);
        int maxX = (bx + prop.radius) * (1 - ia[0]);
        int maxY = (by + prop.radius) * (1 - ia[1]);
        int maxZ = (bz + prop.radius) * (1 - ia[2]);
        int minX = (bx - prop.radius) * (1 - ia[0]);
        int minY = (by - prop.radius) * (1 - ia[1]);
        int minZ = (bz - prop.radius) * (1 - ia[2]);
        int n = i = minX >= 0 ? minX >> 4 : -(Math.abs(minX - 1) >> 4) - 1;
        while (i <= maxX >> 4) {
            int j;
            int n2 = j = minY >= 0 ? minY >> 4 : -(Math.abs(minY - 1) >> 4) - 1;
            while (j <= maxY >> 4) {
                int k;
                int n3 = k = minZ >= 0 ? minZ >> 4 : -(Math.abs(minZ - 1) >> 4) - 1;
                while (k <= maxZ >> 4) {
                    this.paint(world, x + i, y + j, z + k, dir, bx - (i << 4), by - (j << 4), bz - (k << 4), prop);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        float f0;
        EntityPlayer player;
        RayTraceResult mop;
        if (living instanceof EntityPlayer && (mop = (player = (EntityPlayer)living).func_174822_a((double)(f0 = player.field_71075_bZ.field_75098_d ? 5.0f : 4.5f), 0.0f)) != null) {
            int x = mop.func_178782_a().func_177958_n();
            int y = mop.func_178782_a().func_177956_o();
            int z = mop.func_178782_a().func_177952_p();
            float fx = (float)mop.field_72307_f.field_72450_a - (float)x;
            float fy = (float)mop.field_72307_f.field_72448_b - (float)y;
            float fz = (float)mop.field_72307_f.field_72449_c - (float)z;
            this.usePaintTool(stack, player, player.field_70170_p, x, y, z, mop.field_178784_b.func_176745_a(), fx, fy, fz);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    private void paint(World world, int x, int y, int z, int dir, int paintX, int paintY, int paintZ, PaintProperty prop) {
        IBlockState state = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (!state.func_185914_p()) {
            return;
        }
        int[] ia = BlockUtil.facing[dir];
        BlockPos pos = new BlockPos(x += ia[0], y += ia[1], z += ia[2]);
        Block block = BlockUtil.getBlock((IBlockAccess)world, (BlockPos)pos);
        if (block == Blocks.field_150350_a) {
            BlockUtil.setBlock((World)world, (BlockPos)pos, (Block)RTMBlock.paint, (int)0, (int)3);
        } else if (block != RTMBlock.paint) {
            return;
        }
        int p1 = -1;
        int p2 = -1;
        switch (dir) {
            case 0: 
            case 1: {
                p1 = paintX;
                p2 = paintZ;
                break;
            }
            case 2: 
            case 3: {
                p1 = paintX;
                p2 = paintY;
                break;
            }
            case 4: 
            case 5: {
                p1 = paintY;
                p2 = paintZ;
            }
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPaint) {
            TileEntityPaint paint = (TileEntityPaint)tile;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    PaintProperty.EnumPaintType type = PaintProperty.EnumPaintType.values()[prop.type];
                    boolean flag = false;
                    int alpha = prop.alpha;
                    int r = prop.radius - 1;
                    if (type == PaintProperty.EnumPaintType.pen_circle || type == PaintProperty.EnumPaintType.brush || type == PaintProperty.EnumPaintType.eraser_circle) {
                        int disQ = (i - p1) * (i - p1) + (j - p2) * (j - p2);
                        int rad2 = r * r;
                        boolean bl = flag = disQ <= rad2;
                        if (type == PaintProperty.EnumPaintType.brush && rad2 > 0) {
                            alpha -= alpha * disQ / rad2;
                        }
                    } else if (type == PaintProperty.EnumPaintType.pen_square || type == PaintProperty.EnumPaintType.eraser_square) {
                        boolean bl = flag = Math.abs(i - p1) <= r && Math.abs(j - p2) <= r;
                    }
                    if (!flag) continue;
                    if (type == PaintProperty.EnumPaintType.eraser_circle || type == PaintProperty.EnumPaintType.eraser_square) {
                        paint.clearColor(i, j, dir);
                        continue;
                    }
                    paint.setColor(prop.color, alpha, i, j, dir);
                }
            }
            paint.func_70296_d();
            BlockUtil.markBlockForUpdate((World)world, (BlockPos)paint.func_174877_v());
        }
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77619_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

