/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.RailConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetRail;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import jp.ngt.rtm.rail.BlockMarker;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRail
extends ItemWithModel {
    public ItemRail() {
        this.func_77625_d(1);
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        World world = holder.getWorld();
        IBlockState blockState = world.func_180495_p(holder.getBlockPos());
        if (blockState.func_177230_c() instanceof BlockMarker) {
            return holder.pass();
        }
        if (!world.field_72995_K) {
            TileEntityLargeRailCore core = BlockLargeRailBase.getCore((IBlockAccess)world, holder.getBlockPos());
            if (core != null) {
                ResourceStateRail state = this.getModelState(holder.getItemStack());
                core.getResourceState().readFromNBT(state.writeToNBT());
                core.sendPacket();
            } else {
                BlockPos newPos = holder.getBlockPos().func_177984_a();
                this.placeRail(world, newPos, holder.getItemStack(), holder.getPlayer());
            }
        }
        return holder.success();
    }

    public ResourceStateRail getModelState(ItemStack itemStack) {
        ResourceType type = this.getModelType(itemStack);
        if (type != null) {
            ResourceStateRail state = new ResourceStateRail(type, null);
            if (itemStack.func_77942_o()) {
                state.readFromNBT(itemStack.func_77978_p().func_74775_l("State"));
            } else {
                state.setResourceName(type.defaultName);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74782_a("State", (NBTBase)state.writeToNBT());
                itemStack.func_77982_d(nbt);
            }
            return state;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        List<ResourceSet> rails = ModelPackManager.INSTANCE.getModelList(RTMResource.RAIL);
        for (ResourceSet modelSet : rails) {
            RailConfig cfg = (RailConfig)modelSet.getConfig();
            if (cfg.defaultBallast == null) continue;
            for (RailConfig.BallastSet set : cfg.defaultBallast) {
                float h;
                Block block = Block.func_149684_b((String)set.blockName);
                int meta = set.blockMetadata;
                float f = h = set.height <= 0.0f ? 0.0625f : set.height;
                if (block == null) {
                    block = Blocks.field_150350_a;
                }
                ItemStack itemStack = new ItemStack(RTMItem.itemLargeRail, 1, 0);
                ResourceStateRail state = this.getModelState(itemStack);
                state.setResourceName(cfg.getName());
                state.setBlock(block, meta);
                state.setHeight(h);
                this.setModelState(itemStack, state);
                list.add((Object)itemStack);
            }
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        String s = super.func_77653_i(itemStack);
        ResourceStateRail state = this.getModelState(itemStack);
        if (state == null) {
            return s;
        }
        String localizedName = "";
        if (I18n.func_94522_b((String)state.unlocalizedName)) {
            localizedName = ", " + NGTUtil.translate((String)state.unlocalizedName);
        }
        return s + "(" + ((RailConfig)((ModelSetRail)state.getResourceSet()).getConfig()).getName() + localizedName + ")";
    }

    protected void addInformation(ItemArgHolderBase.ItemArgHolder holder, List list, ITooltipFlag flag) {
        super.addInformation(holder, list, flag);
        ResourceStateRail state = this.getModelState(holder.getItemStack());
        if (state == null) {
            return;
        }
        list.add(TextFormatting.GRAY + "Height:" + state.blockHeight);
        if (holder.getItemStack().func_77942_o() && holder.getItemStack().func_77978_p().func_74764_b("ShapeName")) {
            String shape = holder.getItemStack().func_77978_p().func_74779_i("ShapeName");
            list.add(TextFormatting.GRAY + shape);
        }
    }

    public static ItemStack getRailItem(ResourceStateRail prop) {
        ItemStack itemStack = new ItemStack(RTMItem.itemLargeRail, 1, 0);
        ((ItemRail)RTMItem.itemLargeRail).setModelState(itemStack, prop);
        return itemStack;
    }

    public static ResourceStateRail getDefaultProperty() {
        ResourceStateRail state = new ResourceStateRail(RTMResource.RAIL, null);
        state.setResourceToDefault();
        return state;
    }

    @Override
    protected ResourceType getModelType(ItemStack itemStack) {
        return RTMResource.RAIL;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        return RTMCore.guiIdSelectItemModel;
    }

    protected ResourceState getNewState(ItemStack itemStack, ResourceType type) {
        return new ResourceStateRail(type, null);
    }

    private static List<RailPosition> getRPFromItem(ItemStack stack) {
        ArrayList<RailPosition> list = new ArrayList<RailPosition>();
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            int size = nbt.func_74771_c("Size");
            for (int i = 0; i < size; ++i) {
                list.add(RailPosition.readFromNBT(nbt.func_74775_l("RP" + i)));
            }
        }
        return list;
    }

    private static void setRPToItem(ItemStack stack, RailPosition[] rps) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74774_a("Size", (byte)rps.length);
        for (int i = 0; i < rps.length; ++i) {
            nbt.func_74782_a("RP" + i, (NBTBase)rps[i].writeToNBT());
        }
    }

    public static ItemStack copyItemFromRail(TileEntityLargeRailCore core) {
        ItemStack stack = ItemRail.getRailItem(core.getResourceState());
        RailPosition[] rps = core.getRailPositions();
        ItemRail.setRPToItem(stack, rps);
        String shape = core.getRailShapeName();
        stack.func_77978_p().func_74778_a("ShapeName", shape);
        return stack;
    }

    private boolean placeRail(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        List<RailPosition> rps = ItemRail.getRPFromItem(stack);
        if (!rps.isEmpty()) {
            int dir = -BlockMarker.getFacing((EntityLivingBase)player, false) * 2 + 4;
            RailPosition topRP = rps.get(0);
            int difDir = dir - topRP.direction;
            int origX = topRP.blockX;
            int origY = topRP.blockY;
            int origZ = topRP.blockZ;
            for (RailPosition rp : rps) {
                double dif2X = (double)rp.blockX + 0.5 - ((double)origX + 0.5);
                double dif2Y = (double)rp.blockY + 0.5 - ((double)origY + 0.5);
                double dif2Z = (double)rp.blockZ + 0.5 - ((double)origZ + 0.5);
                Vec3 vec = PooledVec3.create((double)dif2X, (double)dif2Y, (double)dif2Z);
                vec = vec.rotateAroundY((float)difDir * 45.0f);
                rp.blockX = NGTMath.floor((double)((double)pos.func_177958_n() + 0.5 + vec.getX()));
                rp.blockY = NGTMath.floor((double)((double)pos.func_177956_o() + 0.5 + vec.getY()));
                rp.blockZ = NGTMath.floor((double)((double)pos.func_177952_p() + 0.5 + vec.getZ()));
                rp.direction = (byte)(rp.direction + difDir + 8 & 7);
                rp.anchorYaw = NGTMath.wrapAngle((float)(rp.anchorYaw + (float)difDir * 45.0f));
                rp.init();
            }
            ResourceStateRail state = this.getModelState(stack);
            boolean isCreative = player.field_71075_bZ.field_75098_d;
            return BlockMarker.createRail(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rps, state, true, isCreative);
        }
        return false;
    }
}

