/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityFreightCar;
import jp.ngt.rtm.entity.train.EntityTanker;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.EntityTrainDieselCar;
import jp.ngt.rtm.entity.train.EntityTrainElectricCar;
import jp.ngt.rtm.entity.train.EntityTrainTest;
import jp.ngt.rtm.entity.train.parts.EntityVehiclePart;
import jp.ngt.rtm.entity.train.util.FormationEntry;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.util.RailMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemTrain
extends ItemWithModel {
    private static final int SPLIT = 128;

    @Override
    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        if (holder.getWorld().field_72995_K) {
            List<TrainSet> trainSets = ItemTrain.getFormationFromItem(holder.getItemStack());
            if (!trainSets.isEmpty()) {
                return holder.success();
            }
            return super.onItemRightClick(holder);
        }
        return holder.success();
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        BlockPos pos = holder.getBlockPos();
        EntityPlayer player = holder.getPlayer();
        if (world.field_72995_K || !PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editVehicle")) {
            return holder.success();
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ResourceState state = this.getModelState(itemStack);
        RailMap rm0 = TileEntityLargeRailBase.getRailMapFromCoordinates(world, (Entity)player, x, y, z);
        if (rm0 == null) {
            return holder.success();
        }
        if (!this.checkObstacle((TrainConfig)((ModelSetTrain)state.getResourceSet()).getConfig(), player, world, x, y, z, rm0)) {
            return holder.success();
        }
        int spIndex = rm0.getNearlestPoint(128, (double)x + 0.5, (double)z + 0.5);
        float yw0 = NGTMath.wrapAngle((float)rm0.getRailRotation(128, spIndex));
        float yaw = EntityBogie.fixBogieYaw(-player.field_70177_z, yw0);
        float pitch = EntityBogie.fixBogiePitch(rm0.getRailPitch(128, spIndex), yw0, yaw);
        double posX = rm0.getRailPos(128, spIndex)[1];
        double posY = rm0.getRailHeight(128, spIndex);
        double posZ = rm0.getRailPos(128, spIndex)[0];
        List<TrainSet> trainSets = ItemTrain.getFormationFromItem(itemStack);
        if (trainSets.isEmpty()) {
            EntityTrainBase train = this.getTrain(itemStack, world);
            train.func_70080_a(posX, posY, posZ, yaw, pitch);
            train.getResourceState().readFromNBT(state.writeToNBT());
            train.spawnTrain(world);
            train.updateResourceState();
        } else {
            for (TrainSet set : trainSets) {
                Vec3 vec = PooledVec3.create((double)set.posX, (double)set.posY, (double)set.posZ);
                vec = vec.rotateAroundY(yaw);
                EntityTrainBase train = this.getTrain(itemStack, world);
                train.func_70080_a(posX + vec.getX(), posY + vec.getY(), posZ + vec.getZ(), yaw + set.yaw, pitch + set.pitch);
                train.getResourceState().setResourceName(set.modelName);
                train.spawnTrain(world);
                train.updateResourceState();
                train.getBogie((int)0).isActivated = true;
                train.getBogie((int)1).isActivated = true;
                train.setNotch(1);
            }
        }
        itemStack.func_190918_g(1);
        return holder.success();
    }

    private boolean checkObstacle(TrainConfig cfg, EntityPlayer player, World world, int x, int y, int z, RailMap rm0) {
        float range = cfg.trainDistance + 4.0f;
        List list = world.func_72839_b((Entity)player, new AxisAlignedBB((double)((float)x - range), (double)(y - 4), (double)((float)z - range), (double)((float)x + range + 1.0f), (double)(y + 8), (double)((float)z + range + 1.0f)));
        for (Entity entity : list) {
            if (!(entity instanceof EntityTrainBase) && !(entity instanceof EntityBogie) && !(entity instanceof EntityVehiclePart)) continue;
            double distanceSq = entity.func_70092_e((double)x, (double)y, (double)z);
            RailMap rm1 = TileEntityLargeRailBase.getRailMapFromCoordinates(world, (Entity)player, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(distanceSq < (double)(range * range)) || !rm0.equals(rm1)) continue;
            NGTLog.sendChatMessage((ICommandSender)player, (String)"message.train.obstacle", (Object[])new Object[]{entity.toString()});
            return false;
        }
        return true;
    }

    private EntityTrainBase getTrain(ItemStack itemStack, World world) {
        switch (itemStack.func_77952_i()) {
            case 1: {
                return new EntityTrainElectricCar(world, "");
            }
            case 2: {
                return new EntityFreightCar(world, "");
            }
            case 3: {
                return new EntityTanker(world, "");
            }
            case 127: {
                return new EntityTrainTest(world, "");
            }
        }
        return new EntityTrainDieselCar(world, "");
    }

    public String func_77667_c(ItemStack par1) {
        return this.func_77658_a() + "." + par1.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        list.add((Object)new ItemStack((Item)this, 1, 0));
        list.add((Object)new ItemStack((Item)this, 1, 1));
        list.add((Object)new ItemStack((Item)this, 1, 2));
        list.add((Object)new ItemStack((Item)this, 1, 3));
        list.add((Object)new ItemStack((Item)this, 1, 127));
    }

    @Override
    protected ResourceType getModelType(ItemStack itemStack) {
        switch (itemStack.func_77952_i()) {
            case 0: {
                return RTMResource.TRAIN_DC;
            }
            case 1: {
                return RTMResource.TRAIN_EC;
            }
            case 2: {
                return RTMResource.TRAIN_CC;
            }
            case 3: {
                return RTMResource.TRAIN_TC;
            }
            case 127: {
                return RTMResource.TRAIN_TEST;
            }
        }
        return RTMResource.TRAIN_DC;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        return RTMCore.guiIdSelectItemModel;
    }

    protected ResourceState getNewState(ItemStack itemStack, ResourceType type) {
        return new ResourceState(type, null);
    }

    protected void addInformation(ItemArgHolderBase.ItemArgHolder holder, List list, ITooltipFlag flag) {
        List<TrainSet> trainSets = ItemTrain.getFormationFromItem(holder.getItemStack());
        if (trainSets.isEmpty()) {
            super.addInformation(holder, list, flag);
        } else {
            StringBuilder sb = new StringBuilder("{");
            for (TrainSet set : trainSets) {
                sb.append(set.modelName);
                sb.append(",");
            }
            sb.append("}");
            list.add(TextFormatting.GRAY + sb.toString());
        }
    }

    private static ItemStack getItem(ResourceType type) {
        if (type == RTMResource.TRAIN_DC) {
            return new ItemStack(RTMItem.itemtrain, 1, 0);
        }
        if (type == RTMResource.TRAIN_EC) {
            return new ItemStack(RTMItem.itemtrain, 1, 1);
        }
        if (type == RTMResource.TRAIN_CC) {
            return new ItemStack(RTMItem.itemtrain, 1, 2);
        }
        if (type == RTMResource.TRAIN_TC) {
            return new ItemStack(RTMItem.itemtrain, 1, 3);
        }
        if (type == RTMResource.TRAIN_TEST) {
            return new ItemStack(RTMItem.itemtrain, 1, 127);
        }
        return new ItemStack(RTMItem.itemtrain, 1, 0);
    }

    public static ItemStack convertFormationAsItem(EntityTrainBase train) {
        ItemStack stack = ItemTrain.getItem(train.getResourceState().type);
        NBTTagList tagList = new NBTTagList();
        for (FormationEntry entry : train.getFormation().entries) {
            if (entry == null) continue;
            EntityTrainBase train2 = entry.train;
            Vec3 vec = PooledVec3.create((double)(train2.field_70165_t - train.field_70165_t), (double)(train2.field_70163_u - train.field_70163_u), (double)(train2.field_70161_v - train.field_70161_v));
            vec = vec.rotateAroundY(NGTMath.wrapAngle((float)(-train.field_70177_z)));
            TrainSet set = new TrainSet(train2.getResourceState().getResourceName(), entry.entryId, (float)vec.getX(), (float)vec.getY(), (float)vec.getZ(), train2.field_70177_z - train.field_70177_z, train2.field_70125_A - train.field_70125_A);
            tagList.func_74742_a((NBTBase)set.writeToNBT());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("formations", (NBTBase)tagList);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static List<TrainSet> getFormationFromItem(ItemStack stack) {
        ArrayList<TrainSet> list = new ArrayList<TrainSet>();
        if (stack.func_77942_o()) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c("formations", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                list.add(TrainSet.readFromNBT(tagList.func_150305_b(i)));
            }
        }
        return list;
    }

    public static class TrainSet {
        public final String modelName;
        public final int index;
        public final float posX;
        public final float posY;
        public final float posZ;
        public final float yaw;
        public final float pitch;

        public TrainSet(String p1, int p2, float p3, float p4, float p5, float p6, float p7) {
            this.modelName = p1;
            this.index = p2;
            this.posX = p3;
            this.posY = p4;
            this.posZ = p5;
            this.yaw = p6;
            this.pitch = p7;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("model", this.modelName);
            nbt.func_74768_a("index", this.index);
            nbt.func_74776_a("pos_x", this.posX);
            nbt.func_74776_a("pos_y", this.posY);
            nbt.func_74776_a("pos_z", this.posZ);
            nbt.func_74776_a("yaw", this.yaw);
            nbt.func_74776_a("pitch", this.pitch);
            return nbt;
        }

        public static TrainSet readFromNBT(NBTTagCompound nbt) {
            String s = nbt.func_74779_i("model");
            int i = nbt.func_74762_e("index");
            float f0 = nbt.func_74760_g("pos_x");
            float f1 = nbt.func_74760_g("pos_y");
            float f2 = nbt.func_74760_g("pos_z");
            float f3 = nbt.func_74760_g("yaw");
            float f4 = nbt.func_74760_g("pitch");
            return new TrainSet(s, i, f0, f1, f2, f3, f4);
        }
    }
}

