/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.event.TickProcessEntry;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.item.ItemGun;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RazerBullet
implements TickProcessEntry {
    protected static final int RANGE = 4;
    protected static final float SPEED = 2.0f;
    protected static final int MAX_AGE = 128;
    protected final EntityLivingBase shooter;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected int age;

    public RazerBullet(EntityPlayer shooter) {
        this.shooter = shooter;
        this.posX = shooter.field_70165_t;
        this.posY = shooter.field_70163_u + (double)shooter.func_70047_e();
        this.posZ = shooter.field_70161_v;
        float yawRad = NGTMath.toRadians((float)shooter.field_70177_z);
        float pitchRad = NGTMath.toRadians((float)shooter.field_70125_A);
        this.motionX = (double)(-MathHelper.func_76126_a((float)yawRad) * MathHelper.func_76134_b((float)pitchRad)) * 2.0;
        this.motionZ = (double)(MathHelper.func_76134_b((float)yawRad) * MathHelper.func_76134_b((float)pitchRad)) * 2.0;
        this.motionY = (double)(-MathHelper.func_76126_a((float)pitchRad)) * 2.0;
        double recoilCoe = 0.01;
        this.shooter.field_70159_w -= this.motionX * (recoilCoe *= (double)(ItemGun.GunType.razer_gun.speed / 2.0f));
        this.shooter.field_70181_x -= this.motionY * recoilCoe;
        this.shooter.field_70179_y -= this.motionZ * recoilCoe;
        this.shooter.field_70133_I = true;
    }

    public boolean process(World world) {
        for (int i = 0; i < 128; ++i) {
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            ++this.age;
            this.deleteBlocks(this.shooter.func_130014_f_());
            this.deleteEntities(this.shooter.func_130014_f_());
            if (!(this.posY < 0.0) && !(this.posY > 256.0)) continue;
            return true;
        }
        return true;
    }

    protected void deleteBlocks(World world) {
        int blockX = NGTMath.floor((double)this.posX);
        int blockY = NGTMath.floor((double)this.posY);
        int blockZ = NGTMath.floor((double)this.posZ);
        for (int i = -4; i < 4; ++i) {
            for (int j = -4; j < 4; ++j) {
                for (int k = -4; k < 4; ++k) {
                    BlockPos pos;
                    Block block;
                    int len2 = i * i + j * j + k * k;
                    int rng2 = 16;
                    if (len2 > rng2 || (block = BlockUtil.getBlock((IBlockAccess)world, (BlockPos)(pos = new BlockPos(blockX + i, blockY + j, blockZ + k)))) == Blocks.field_150350_a || block == Blocks.field_150357_h) continue;
                    if (len2 >= rng2 - 6) {
                        BlockUtil.setBlock((World)world, (BlockPos)pos, (Block)Blocks.field_189877_df, (int)0, (int)3);
                        continue;
                    }
                    BlockUtil.setBlock((World)world, (BlockPos)pos, (Block)Blocks.field_150350_a, (int)0, (int)3);
                }
            }
        }
    }

    protected void deleteEntities(World world) {
        List list = world.func_72839_b((Entity)this.shooter, new AxisAlignedBB(this.posX - 4.0, this.posY - 4.0, this.posZ - 4.0, this.posX + 4.0, this.posY + 4.0, this.posZ + 4.0));
        double rng2 = 16.0;
        for (Entity entity : list) {
            if (!(entity.func_70092_e(this.posX, this.posY, this.posZ) <= rng2)) continue;
            entity.func_70097_a(DamageSource.field_76376_m, 10000.0f);
        }
    }
}

