/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.io.ResourceLocationCustom;
import jp.ngt.ngtlib.renderer.model.EncryptedModel;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.NGTOModel;
import jp.ngt.ngtlib.renderer.model.NGTZModel;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.block.tt.TimeTableManager;
import jp.ngt.rtm.entity.util.CollisionHelper;
import jp.ngt.rtm.modelpack.ModelPackException;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.cfg.RRSConfig;
import jp.ngt.rtm.modelpack.cfg.ResourceConfig;
import jp.ngt.rtm.modelpack.init.ModelPackLoadThread;
import jp.ngt.rtm.modelpack.init.ProgressStateHolder;
import jp.ngt.rtm.modelpack.model.RTMClassModels;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.network.PacketModelSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModelPackManager {
    public static final ModelPackManager INSTANCE = new ModelPackManager();
    private static final Pattern SC_INCLUDE = Pattern.compile("//include <(.+)>");
    private static final String[] ENCODING = new String[]{"UTF-8", "SJIS"};
    private final Map<String, ResourceType> typeMap = new HashMap<String, ResourceType>(32);
    private final Map<ResourceType, Map<String, ResourceSet>> allModelSetMap = new HashMap<ResourceType, Map<String, ResourceSet>>(256);
    private final Map<ResourceType, Map<String, ResourceSet>> smpModelSetMap = new HashMap<ResourceType, Map<String, ResourceSet>>(256);
    private final Map<String, ResourceSet> dummyMap = new HashMap<String, ResourceSet>(32);
    public final List<ResourceSet> unconstructSets = new ArrayList<ResourceSet>(256);
    private final Map<String, IModelNGT> modelCache = new HashMap<String, IModelNGT>(128);
    private final Map<String, Map<String, ResourceLocation>> resourceCache = new HashMap<String, Map<String, ResourceLocation>>(256);
    private final Map<String, String> scriptCache = new HashMap<String, String>(64);
    public final List<File> fileCache = new ArrayList<File>(1024);
    public boolean modelLoaded;
    private static final String DEFAULT_DOMAIN = "minecraft";

    private ModelPackManager() {
    }

    public void load(ModelPackLoadThread par1) {
        List fileListTemp = NGTFileLoader.findFile(file -> {
            String path = file.getAbsolutePath();
            String name = file.getName();
            return !path.contains("block") && !path.contains("item") && !name.endsWith(".json");
        });
        this.fileCache.addAll(fileListTemp);
        NGTLog.debug((String)"[ModelPack] Start searching json");
        par1.setBarValue(0, ProgressStateHolder.ProgressState.SEARCHING_MODEL);
        par1.setBarMaxValue(1, 0, "Searching...");
        List fileList = NGTFileLoader.findFile(file -> {
            String path = file.getAbsolutePath();
            String name = file.getName();
            return !path.contains("block") && !path.contains("item") && name.endsWith(".json");
        });
        NGTLog.debug((String)"[ModelPack] Find %d json", (Object[])new Object[]{fileList.size()});
        NGTLog.debug((String)"[ModelPack] Start registering json");
        par1.setBarValue(0, ProgressStateHolder.ProgressState.LOADING_MODEL);
        par1.setBarMaxValue(1, fileList.size(), "");
        int count = 0;
        for (File file2 : fileList) {
            if (!file2.getName().contains("_")) continue;
            String typeName = file2.getName().split("_")[0];
            par1.setBarValue(1, count + 1, file2.getName());
            if (!this.typeMap.containsKey(typeName)) continue;
            ResourceType type = this.typeMap.get(typeName);
            try {
                this.registerResourceSet(type, file2);
            }
            catch (ModelPackException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ModelPackException("Can't load model", file2.getAbsolutePath(), e);
            }
            ++count;
        }
        NGTLog.debug((String)"[ModelPack] Register %d json", (Object[])new Object[]{count});
        par1.setBarValue(0, ProgressStateHolder.ProgressState.SEARCHING_RRS);
        par1.setBarMaxValue(1, 0, "Loading...");
        List fileList2 = NGTFileLoader.findFile(file -> file.getName().startsWith("rrs_") && file.getName().endsWith(".png"));
        par1.setBarValue(0, ProgressStateHolder.ProgressState.LOADING_RRS);
        par1.setBarMaxValue(1, fileList2.size(), "");
        count = 0;
        for (File file3 : fileList2) {
            String name = file3.getName();
            par1.setBarValue(1, ++count, name);
            RRSConfig cfg = new RRSConfig(name);
            this.registerResourceSet(RTMResource.RRS, cfg, "dummy_str");
        }
        TimeTableManager.INSTANCE.load();
        par1.loadFinished = true;
        this.modelLoaded = true;
    }

    public void registerType(ResourceType type) {
        boolean isSubType;
        boolean bl = isSubType = type.hasSubType && type.subType != null;
        if (isSubType) {
            ResourceSet dummy = this.getNewModelSet(type, new Class[0], new Object[0]);
            this.dummyMap.put(type.subType, dummy);
            this.unconstructSets.add(dummy);
        } else {
            this.typeMap.put(type.name, type);
            this.allModelSetMap.put(type, new HashMap());
            this.smpModelSetMap.put(type, new HashMap());
            ResourceSet dummy = this.getNewModelSet(type, new Class[0], new Object[0]);
            this.dummyMap.put(type.name, dummy);
        }
    }

    public ResourceType getType(String name) {
        return this.typeMap.get(name);
    }

    public String registerResourceSet(ResourceType type, File file) throws IOException {
        for (String enc : ENCODING) {
            try {
                String json = NGTText.readText((File)file, (boolean)false, (String)enc);
                ResourceConfig cfg = (ResourceConfig)NGTJson.getObjectFromJson((String)json, type.cfgClass);
                return this.registerResourceSet(type, cfg, json);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new ModelPackException("Can't load model", file.getAbsolutePath());
    }

    public String registerResourceSet(ResourceType type, ResourceConfig cfg, String origJson) {
        cfg.init();
        ResourceSet set = this.getNewModelSet(type, new Class[]{type.cfgClass}, cfg);
        if (set != null) {
            NGTLog.debug((String)"Registr resource : %s (%s)", (Object[])new Object[]{cfg.getName(), type.name});
            this.allModelSetMap.get(type).put(cfg.getName(), set);
            this.unconstructSets.add(set);
            set.md5 = EncryptedModel.getMD5((String)EncryptedModel.formatJson((String)origJson));
            return cfg.getName();
        }
        throw new ModelPackException("Failed to create ResourceSet", cfg.getName());
    }

    public void sendModelSetsToClient(EntityPlayerMP player) {
        int count = 0;
        for (Map.Entry<ResourceType, Map<String, ResourceSet>> entry : this.allModelSetMap.entrySet()) {
            for (ResourceSet modelSet : entry.getValue().values()) {
                Object cfg = modelSet.getConfig();
                RTMCore.NETWORK_WRAPPER.sendTo((IMessage)new PacketModelSet(count, entry.getKey().name, ((ResourceConfig)cfg).getName()), player);
                NGTLog.debug((String)("[RTM] Send model to client : " + ((ResourceConfig)cfg).getName()));
                ++count;
            }
        }
    }

    public void addModelSetName(int count, String typeName, String name) {
        ResourceType type;
        ResourceSet modelSet;
        assert (NGTUtil.isSMP() && !NGTUtil.isServer());
        if (count == 0) {
            for (Map<String, ResourceSet> map : this.smpModelSetMap.values()) {
                map.clear();
            }
        }
        if ((modelSet = this.allModelSetMap.get(type = this.typeMap.get(typeName)).get(name)) != null) {
            this.smpModelSetMap.get(type).put(name, modelSet);
            NGTLog.debug((String)("[RTM] Add model to SMP map : " + name));
            if (modelSet instanceof ModelSetBase) {
                CollisionHelper.INSTANCE.syncCollisionObj(type, (ModelSetBase)modelSet);
            }
        }
    }

    private ResourceSet getNewModelSet(ResourceType type, Class[] parameterTypes, Object ... parameters) {
        try {
            Constructor cons0 = type.setClass.getConstructor(parameterTypes);
            return (ResourceSet)cons0.newInstance(parameters);
        }
        catch (ReflectiveOperationException e) {
            String name = "";
            if (parameters.length > 0) {
                name = ((ResourceConfig)parameters[0]).getName();
            }
            throw new ModelPackException("On construct ModelSet", name, e);
        }
    }

    public <T extends ResourceSet> T getResourceSet(ResourceType type, String name) {
        boolean isSMPClient;
        Map<ResourceType, Map<String, ResourceSet>> map;
        ResourceSet modelSet;
        ResourceType parent = type;
        if (type.parent != null) {
            parent = type.parent;
        }
        if ((modelSet = (map = (isSMPClient = NGTUtil.isSMP() && !NGTUtil.isServer()) ? this.smpModelSetMap : this.allModelSetMap).get(parent).get(name)) == null && (modelSet = this.dummyMap.get(type.hasSubType ? type.subType : type.name)) == null) {
            throw new ModelPackException("Default model is not registered.", name);
        }
        return (T)modelSet;
    }

    public List<ResourceSet> getModelList(ResourceType type) {
        if (type.parent != null) {
            type = type.parent;
        }
        ArrayList<ResourceSet> list = new ArrayList<ResourceSet>();
        Map<ResourceType, Map<String, ResourceSet>> map = NGTUtil.isSMP() ? this.smpModelSetMap : this.allModelSetMap;
        list.addAll(map.get(type).values());
        Collections.sort(list, (o1, o2) -> ((ResourceConfig)o1.getConfig()).getName().compareTo(((ResourceConfig)o2.getConfig()).getName()));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public IModelNGT loadModel(String modelName, int drawMode, boolean addModelMap, ModelConfig cfg, byte[] md5) {
        if (addModelMap && this.modelCache.containsKey(modelName)) {
            return this.modelCache.get(modelName);
        }
        VecAccuracy accuracy = cfg.accuracy == null || cfg.accuracy.equals(VecAccuracy.MEDIUM.toString()) ? VecAccuracy.MEDIUM : VecAccuracy.LOW;
        String resource = "models/" + modelName;
        Object model = null;
        try {
            model = FileType.CLASS.match(modelName) ? RTMClassModels.getModel(modelName) : (FileType.NGTO.match(modelName) ? new NGTOModel((ResourceLocation)new ResourceLocationCustom(DEFAULT_DOMAIN, resource), cfg.scale) : (FileType.NGTZ.match(modelName) ? new NGTZModel((ResourceLocation)new ResourceLocationCustom(DEFAULT_DOMAIN, resource), cfg.scale) : ModelLoader.loadModel((String)resource, (VecAccuracy)accuracy, (Object[])new Object[]{drawMode, md5})));
        }
        catch (ModelFormatException e) {
            throw new ModelFormatException("Can't load model : " + modelName, (Throwable)e);
        }
        if (model == null) {
            throw new ModelPackException("Can't find model file", cfg.getName());
        }
        if (addModelMap) {
            this.modelCache.put(modelName, (IModelNGT)model);
        }
        return model;
    }

    public ResourceLocation getResource(String path) {
        String domain = DEFAULT_DOMAIN;
        if (path.contains(":")) {
            String[] sa = path.split(":");
            domain = sa[0];
            path = sa[1];
        }
        return this.getResource(domain, path);
    }

    public ResourceLocation getResource(String domain, String path) {
        Map<String, ResourceLocation> map = this.resourceCache.get(domain);
        if (map == null) {
            map = new HashMap<String, ResourceLocation>();
            this.resourceCache.put(domain, map);
        } else if (map.containsKey(path)) {
            return map.get(path);
        }
        ResourceLocationCustom resource = new ResourceLocationCustom(domain, path);
        map.put(path, (ResourceLocation)resource);
        return resource;
    }

    public String getScript(String fileName) {
        try {
            return this.loadScript(fileName);
        }
        catch (IOException e) {
            throw new ModelPackException("Failed to load script", fileName, e);
        }
    }

    private String loadScript(String fileName) throws IOException {
        Matcher matcher;
        if (this.scriptCache.containsKey(fileName)) {
            return this.scriptCache.get(fileName);
        }
        String rawScript = NGTText.append((List)NGTText.readText((ResourceLocation)this.getResource(fileName)), (boolean)true);
        while ((matcher = SC_INCLUDE.matcher(rawScript)).find()) {
            String path = matcher.group(1);
            String rep = this.loadScript(path);
            rawScript = matcher.replaceFirst(rep);
        }
        this.scriptCache.put(fileName, rawScript);
        return rawScript;
    }

    public void clearCache() {
        this.modelCache.clear();
        this.resourceCache.clear();
        this.scriptCache.clear();
        this.fileCache.clear();
    }
}

