/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.cfg;

import jp.ngt.rtm.modelpack.cfg.IConfigWithType;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;

public class TrainConfig
extends VehicleBaseConfig
implements IConfigWithType {
    private String trainName;
    private String trainType;
    private ModelConfig.ModelSource trainModel2;
    private ModelConfig.ModelSource[] bogieModel3;
    @Deprecated
    private ModelConfig.ModelSource bogieModel2;
    @Deprecated
    private String trainModel;
    @Deprecated
    private String bogieModel;
    @Deprecated
    private String trainTexture;
    @Deprecated
    private String bogieTexture;
    public String sound_BrakeRelease;
    public String sound_BrakeRelease2;
    public boolean muteJointSound;
    public float[][] jointDelay;
    public boolean isSingleTrain;
    private float[][] bogiePos;
    public float trainDistance;
    public float accelerateion;
    public float[] maxSpeed;
    public float rolling;
    public float[][] pantoPos;
    public float rollSpeedCoefficient;
    public float rollVariationCoefficient;
    public float rollWidthCoefficient;

    @Override
    public void init() {
        super.init();
        if (this.trainModel2 == null) {
            this.trainModel2 = new ModelConfig.ModelSource();
            this.trainModel2.modelFile = this.trainModel;
            this.trainModel2.textures = new String[][]{{"default", this.trainTexture}};
        }
        if (this.bogieModel3 == null) {
            this.bogieModel3 = new ModelConfig.ModelSource[2];
            if (this.bogieModel2 != null) {
                this.bogieModel3[0] = this.bogieModel3[1] = this.bogieModel2;
            } else {
                ModelConfig.ModelSource model = new ModelConfig.ModelSource();
                model.modelFile = this.bogieModel;
                model.textures = new String[][]{{"default", this.bogieTexture}};
                this.bogieModel3[0] = this.bogieModel3[1] = model;
            }
        }
        this.sound_BrakeRelease = this.fixSoundPath(this.sound_BrakeRelease);
        this.sound_BrakeRelease2 = this.fixSoundPath(this.sound_BrakeRelease2);
        if (this.bogiePos == null) {
            this.bogiePos = new float[][]{{0.0f, 0.0f, 7.125f}, {0.0f, 0.0f, -7.125f}};
        }
        if (this.trainDistance <= 0.0f) {
            this.trainDistance = 10.125f;
        }
        if (this.accelerateion <= 0.0f) {
            this.accelerateion = 0.001736f;
        }
        if (this.maxSpeed == null || this.maxSpeed.length < 5) {
            this.maxSpeed = new float[]{0.36f, 0.72f, 1.08f, 1.44f, 1.8f};
        }
        this.rolling *= 5.0f;
        if (this.jointDelay == null) {
            float f0 = 1.9f;
            this.jointDelay = new float[][]{{0.0f, f0}, {0.0f, f0}};
        }
    }

    @Override
    public String getName() {
        return this.trainName;
    }

    @Override
    public ModelConfig.ModelSource getModel() {
        return this.trainModel2;
    }

    public ModelConfig.ModelSource getBogieModel(int par1) {
        return this.bogieModel3[par1];
    }

    public float[][] getBogiePos() {
        return this.bogiePos;
    }

    public static TrainConfig getDummyConfig() {
        TrainConfig config = new TrainConfig();
        config.trainName = "Dummy";
        config.trainType = "N";
        config.init();
        return config;
    }

    @Override
    public String getSubType() {
        return this.trainType;
    }
}

