/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.cfg;

import jp.ngt.rtm.modelpack.cfg.ModelConfig;

public abstract class VehicleBaseConfig
extends ModelConfig {
    private float[] size;
    public String rollsignTexture;
    public String[] rollsignNames;
    public Rollsign[] rollsigns;
    public String[][] customButtons;
    public String[] customButtonTips;
    public VehicleParts[] door_left;
    public VehicleParts[] door_right;
    public VehicleParts[] pantograph_front;
    public VehicleParts[] pantograph_back;
    public String sound_Stop;
    public String sound_S_A;
    public String sound_Acceleration;
    public String sound_Deceleration;
    public String sound_D_S;
    public String sound_Horn;
    public String sound_DoorOpen;
    public String sound_DoorClose;
    public String[][] sound_Announcement;
    public String soundScriptPath;
    public Object[][] smoke;
    public Light[] headLights;
    public Light[] tailLights;
    public Light[] interiorLights;
    private float[][] seatPosF;
    @Deprecated
    private int[][] seatPos;
    protected float[][] playerPos;
    public boolean notDisplayCab;
    public float wheelRotationSpeed;

    @Override
    public void init() {
        int i;
        super.init();
        if (this.size == null) {
            this.size = new float[]{2.75f, 1.25f};
        }
        this.sound_Stop = this.fixSoundPath(this.sound_Stop);
        this.sound_S_A = this.fixSoundPath(this.sound_S_A);
        this.sound_Acceleration = this.fixSoundPath(this.sound_Acceleration);
        this.sound_Deceleration = this.fixSoundPath(this.sound_Deceleration);
        this.sound_D_S = this.fixSoundPath(this.sound_D_S);
        this.sound_Horn = this.fixSoundPath(this.sound_Horn);
        this.sound_DoorOpen = this.fixSoundPath(this.sound_DoorOpen);
        this.sound_DoorClose = this.fixSoundPath(this.sound_DoorClose);
        if (this.sound_Announcement != null) {
            for (i = 0; i < this.sound_Announcement.length; ++i) {
                this.sound_Announcement[i][1] = this.fixSoundPath(this.sound_Announcement[i][1]);
            }
        }
        if (this.seatPosF == null) {
            if (this.seatPos != null) {
                this.seatPosF = new float[this.seatPos.length][];
                for (i = 0; i < this.seatPosF.length; ++i) {
                    float x = (float)this.seatPos[i][0] * 0.0625f;
                    float y = (float)this.seatPos[i][1] * 0.0625f;
                    float z = (float)this.seatPos[i][2] * 0.0625f;
                    float type = this.seatPos[i][3];
                    this.seatPosF[i] = new float[]{x, y, z, type};
                }
            } else {
                this.seatPosF = new float[0][];
            }
        }
        if (this.playerPos == null) {
            this.playerPos = new float[][]{{0.8f, 0.0f, 9.187f}, {-0.8f, 0.0f, -9.187f}};
        }
        if (this.wheelRotationSpeed <= 0.0f) {
            this.wheelRotationSpeed = 1.0f;
        }
        if (this.customButtons == null) {
            this.customButtons = new String[0][];
        }
        if (this.customButtonTips == null) {
            this.customButtonTips = new String[this.customButtons.length];
        }
    }

    public abstract ModelConfig.ModelSource getModel();

    public float[] getSize() {
        return this.size;
    }

    public float[][] getSlotPos() {
        return this.seatPosF;
    }

    public float[][] getPlayerPos() {
        return this.playerPos;
    }

    public class VehicleParts
    extends ModelConfig.Parts {
        public VehicleParts[] childParts;
        public float[][] transform;
    }

    public class Light {
        public byte type;
        public int color;
        public float[] pos;
        public float r;
        public boolean reverse;
    }

    public class Rollsign {
        public float[] uv;
        public float[][][] pos;
        public boolean doAnimation;
        public boolean disableLighting;
    }
}

