/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.init;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.modelpack.init.Advertisement;

public final class MPLAdButton
extends JButton {
    public static final int BUTTON_WIDTH = 400;
    public static final int BUTTON_HEIGHT = 225;
    private static final int IMAGE_WIDTH = 1024;
    private static final int IMAGE_HEIGHT = 576;
    private Advertisement[] ads;
    private Icon[] images;
    private int index;

    public MPLAdButton(int scale) {
        this.setBorder(new BevelBorder(0, Color.WHITE, Color.GRAY));
        this.initAd(scale);
    }

    private void initAd(int scale) {
        this.ads = this.getAds();
        if (this.ads != null) {
            this.shuffleAds();
            this.loadImages(scale);
            this.changeImage(0);
            this.addActionListener(event -> this.onClick());
        }
    }

    private Advertisement[] getAds() {
        try {
            URL url = new URL("https://dl.dropboxusercontent.com/s/7rpcd4ycxjfnwrr/advertisement.json");
            String json = NGTText.append((List)NGTText.readTextL((InputStream)url.openStream(), (String)""), (boolean)true);
            return (Advertisement[])NGTJson.getObjectFromJson((String)json, Advertisement[].class);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void shuffleAds() {
        ArrayList list = new ArrayList();
        NGTUtil.addArray(list, (Object[])this.ads);
        Collections.shuffle(list);
        this.ads = list.toArray(new Advertisement[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImages(int scale) {
        this.images = new Icon[this.ads.length];
        for (int i = 0; i < this.ads.length; ++i) {
            BufferedImage image;
            try {
                BufferedImage bi;
                URLConnection urlc = new URL(this.ads[i].picture).openConnection();
                if (urlc instanceof HttpsURLConnection) {
                    X509TrustManager x509mng = new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }
                    };
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, new X509TrustManager[]{x509mng}, new SecureRandom());
                    ((HttpsURLConnection)urlc).setSSLSocketFactory(sslContext.getSocketFactory());
                }
                InputStream istream = urlc.getInputStream();
                ImageInputStream stream = ImageIO.createImageInputStream(istream);
                try {
                    bi = ImageIO.read(stream);
                    if (bi == null) {
                        stream.close();
                    }
                }
                finally {
                    istream.close();
                }
                image = bi;
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                e.printStackTrace();
                image = new BufferedImage(1024, 576, 2);
                NGTLog.debug((String)("[ModelPack] Failed to load image : " + this.ads[i].picture));
            }
            Image img2 = image.getScaledInstance(400 * scale, 225 * scale, 2);
            this.images[i] = new ImageIcon(img2);
        }
    }

    public void changeImage(int move) {
        if (this.ads == null) {
            return;
        }
        this.index += move;
        if (this.index < 0) {
            this.index += this.ads.length;
        } else if (this.index >= this.ads.length) {
            this.index -= this.ads.length;
        }
        this.setIcon(this.images[this.index]);
    }

    private void onClick() {
        if (this.ads == null) {
            return;
        }
        try {
            URI uri = new URI(this.ads[this.index].url);
            Desktop.getDesktop().browse(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

