/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.init;

import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.ResourceConfig;
import jp.ngt.rtm.modelpack.init.ModelPackLoadThread;
import jp.ngt.rtm.modelpack.init.ProgressStateHolder;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.fml.relauncher.Side;

public final class ModelPackConstructThread
extends Thread {
    private final Side threadSide;
    private final ModelPackLoadThread parent;
    private boolean loading;
    private int index;
    private boolean barStateChanged;

    public ModelPackConstructThread(Side par1, ModelPackLoadThread par2) {
        super("RTM ModelPack Construct");
        this.threadSide = par1;
        this.parent = par2;
        this.loading = true;
    }

    @Override
    public void run() {
        try {
            this.runThread();
        }
        catch (Throwable e) {
            if (this.threadSide == Side.CLIENT) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Constructing RTM ModelPack");
                crashReport.func_85058_a("Initialization");
                crashReport = NGTUtilClient.getMinecraft().func_71396_d(crashReport);
                NGTUtilClient.getMinecraft().func_71377_b(crashReport);
            }
            e.printStackTrace();
        }
    }

    private void runThread() throws InterruptedException {
        while (this.loading) {
            while (ModelPackManager.INSTANCE.unconstructSets.size() > this.index) {
                ResourceSet set = ModelPackManager.INSTANCE.unconstructSets.get(this.index);
                if (this.threadSide == Side.SERVER) {
                    set.constructOnServer();
                } else {
                    set.constructOnClient();
                    set.finishConstruct();
                }
                NGTLog.debug((String)"Construct Model : %s (%d / %d)", (Object[])new Object[]{((ResourceConfig)set.getConfig()).getName(), this.index + 1, ModelPackManager.INSTANCE.unconstructSets.size()});
                ++this.index;
                if (!this.parent.loadFinished) continue;
                if (!this.barStateChanged) {
                    this.parent.setBarValue(0, ProgressStateHolder.ProgressState.CONSTRUCTING_MODEL);
                    int size = ModelPackManager.INSTANCE.unconstructSets.size();
                    this.parent.setBarMaxValue(1, size, "");
                    this.barStateChanged = true;
                }
                this.parent.setBarValue(1, this.index, ((ResourceConfig)set.getConfig()).getName());
            }
            ModelPackConstructThread.sleep(500L);
        }
    }

    public boolean setFinish() {
        if (ModelPackManager.INSTANCE.unconstructSets.size() == this.index) {
            ModelPackManager.INSTANCE.unconstructSets.clear();
            ModelPackManager.INSTANCE.clearCache();
            this.loading = false;
            return true;
        }
        return false;
    }
}

