/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.init;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.init.MPLAdButton;
import jp.ngt.rtm.modelpack.init.MPLBarPanel;
import jp.ngt.rtm.modelpack.init.MPLFrame;
import jp.ngt.rtm.modelpack.init.MPLMoveButton;
import jp.ngt.rtm.modelpack.init.ModelPackConstructThread;
import jp.ngt.rtm.modelpack.init.ProgressStateHolder;
import jp.ngt.rtm.network.PacketModelPack;
import jp.ngt.rtm.network.PacketNotice;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public final class ModelPackLoadThread
extends Thread {
    private final Side threadSide;
    private final boolean displayWindow;
    private MPLFrame mainFrame;
    private MPLAdButton adButton;
    private JProgressBar[] bars;
    private JLabel[] labels;
    private int[] maxValue;
    public boolean finished;
    public boolean loadFinished;
    private boolean debug = false;

    public ModelPackLoadThread(Side par1) {
        super("RTM ModelPack Load");
        this.threadSide = par1;
        boolean bl = this.displayWindow = par1 == Side.CLIENT && !GraphicsEnvironment.isHeadless();
        if (this.displayWindow) {
            this.initWindow();
        }
    }

    private void initWindow() {
        int size = 2;
        this.bars = new JProgressBar[size];
        this.labels = new JLabel[size];
        this.maxValue = new int[size];
        int scWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth();
        int scale = scWidth / 1024;
        float fontSize = 16.0f;
        this.mainFrame = new MPLFrame(scale);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBackground(Color.BLACK);
        JPanel adPanel = new JPanel();
        adPanel.setBackground(Color.BLACK);
        adPanel.setLayout(new BoxLayout(adPanel, 0));
        this.adButton = new MPLAdButton(scale);
        MPLMoveButton buttonL = new MPLMoveButton(this.adButton, -1, scale);
        MPLMoveButton buttonR = new MPLMoveButton(this.adButton, 1, scale);
        adPanel.add(buttonL);
        adPanel.add(this.adButton);
        adPanel.add(buttonR);
        mainPanel.add(adPanel);
        this.labels[0] = new JLabel("Start Loading");
        this.bars[0] = new JProgressBar();
        MPLBarPanel barPanel1 = new MPLBarPanel(this.labels[0], this.bars[0], scale);
        mainPanel.add(barPanel1);
        this.labels[1] = new JLabel("Ready");
        this.bars[1] = new JProgressBar();
        MPLBarPanel barPanel2 = new MPLBarPanel(this.labels[1], this.bars[1], scale);
        mainPanel.add(barPanel2);
        this.mainFrame.getContentPane().add(mainPanel);
    }

    @Override
    public void run() {
        if (this.displayWindow) {
            this.mainFrame.setVisible(true);
        }
        try {
            Thread winUpdate = new Thread(){
                private int count;

                @Override
                public void run() {
                    while (!ModelPackLoadThread.this.finished) {
                        if (ModelPackLoadThread.this.displayWindow) {
                            ++this.count;
                            if (this.count >= 30) {
                                ModelPackLoadThread.this.adButton.changeImage(1);
                                this.count = 0;
                            }
                        }
                        try {
                            1.sleep(150L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            winUpdate.start();
            this.runThread();
        }
        catch (Throwable e) {
            this.finish();
            if (this.threadSide == Side.CLIENT) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Loading RTM ModelPack");
                crashReport.func_85058_a("Initialization");
                crashReport = NGTUtilClient.getMinecraft().func_71396_d(crashReport);
                NGTUtilClient.getMinecraft().func_71377_b(crashReport);
            } else {
                e.printStackTrace();
            }
        }
        finally {
            if (this.displayWindow && !this.debug) {
                this.mainFrame.dispose();
            }
        }
    }

    private void runThread() throws InterruptedException {
        if (this.threadSide == Side.CLIENT && RTMCore.useServerModelPack) {
            this.setBarMaxValue(0, 0, "Waiting for connecting to Server");
            this.setBarMaxValue(1, 0, "You can start game");
            while (RTMCore.proxy.getConnectionState() == 0) {
                RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNotice(0, "getModelPack"));
                ModelPackLoadThread.sleep(500L);
            }
            while (!PacketModelPack.MP_WRITER.finish) {
                ModelPackLoadThread.sleep(500L);
            }
        }
        this.setBarMaxValue(0, ProgressStateHolder.ProgressState.values().length, "");
        NGTLog.startTimer();
        ModelPackConstructThread thread2 = new ModelPackConstructThread(this.threadSide, this);
        thread2.start();
        ModelPackManager.INSTANCE.load(this);
        while (!thread2.setFinish()) {
            ModelPackLoadThread.sleep(500L);
        }
        this.finish();
        NGTLog.stopTimer((String)"Model load time");
    }

    public void finish() {
        this.finished = true;
    }

    public void setBarMaxValue(int barId, int value, String label) {
        if (!this.displayWindow) {
            return;
        }
        if (value > 0) {
            if (this.bars[barId].isIndeterminate()) {
                this.bars[barId].setIndeterminate(false);
            }
            this.maxValue[barId] = value;
        } else {
            this.bars[barId].setIndeterminate(true);
        }
        if (label != null && label.length() > 0) {
            this.labels[barId].setText(label);
        }
    }

    public void setBarValue(int barId, ProgressStateHolder.ProgressState state) {
        this.setBarValue(barId, state.ordinal(), state.message);
    }

    public void setBarValue(int barId, int value, String label) {
        if (!this.displayWindow) {
            return;
        }
        int max = this.maxValue[barId];
        int i = (int)((float)value / (float)max * 100.0f);
        this.bars[barId].setValue(i);
        this.bars[barId].setStringPainted(true);
        this.bars[barId].setString(String.format("%d/%d", value, max));
        if (label != null && label.length() > 0) {
            this.labels[barId].setText(label);
        }
    }
}

