/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.network.PacketModelPack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ModelPackUploadThread
extends Thread {
    private ByteBuffer buffer = ByteBuffer.allocate(512);

    public ModelPackUploadThread() {
        super("RTM ModelPack Upload");
    }

    public static void startThread() {
        if (!RTMCore.useServerModelPack) {
            return;
        }
        ModelPackUploadThread thread = new ModelPackUploadThread();
        thread.start();
    }

    @Override
    public void run() {
        NGTLog.debug((String)"[RTM](UploadThread) Start uploading ModelPack");
        List fileList = NGTFileLoader.findFile(file -> file.getName().startsWith("ModelPack_") && file.getName().endsWith(".zip"));
        for (File file2 : fileList) {
            try {
                NGTLog.debug((String)("[RTM](UploadThread) Start uploading " + file2.getName()));
                RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketModelPack("start_file:" + file2.getName(), 0L, ByteBuffer.allocate(512)));
                FileChannel channel = new FileInputStream(file2).getChannel();
                long size = channel.size();
                while (channel.read(this.buffer) >= 0) {
                    this.buffer.flip();
                    RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketModelPack(file2.getName(), size, this.buffer));
                    this.buffer.clear();
                    ModelPackUploadThread.sleep(100L);
                }
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketModelPack("finish", 0L, ByteBuffer.allocate(512)));
        NGTLog.debug((String)"[RTM](UploadThread) Finish uploading ModelPack");
    }
}

