/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.init;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.modelpack.init.ModelPackDownloadThread;

public class ModelPackWriter {
    private final ModelPackDownloadThread thread = null;
    private final File modsDir = (File)NGTFileLoader.getModsDir().get(0);
    public boolean finish = false;

    public void onPacket(String par1, long par2, byte[] par3) {
        if (par1.startsWith("start_file")) {
            int index = par1.indexOf(":");
            this.deleteModelPack(par1.substring(index + 1));
        } else if (par1.equals("finish")) {
            this.finish = true;
        } else {
            this.writeModelPack(par1, par2, ByteBuffer.wrap(par3));
        }
    }

    public void writeModelPack(String par1, long par2, ByteBuffer par3) {
        try {
            FileChannel channel = new FileOutputStream(new File(this.modsDir, "Temp#" + par1)).getChannel();
            channel.write(par3);
            channel.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteModelPack(String par1) {
        String name = "Temp#" + par1;
        File file = new File(this.modsDir, name);
        if (file.exists()) {
            file.delete();
            NGTLog.debug((String)("[RTM](Client) Delete ModelPack : " + name));
        }
    }

    public synchronized void startWriting(String par1Name) {
        while (this.thread.writingStatus == 1 || this.thread.writingStatus == 2) {
            try {
                NGTLog.debug((String)"wait (start writing)");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        NGTLog.debug((String)"start writing");
        this.thread.writingStatus = 1;
        this.thread.fileName = "Temp_" + par1Name;
    }

    public synchronized void writeBytes(long par2, ByteBuffer par3) {
        while (this.thread.writingStatus == 0 || this.thread.writingStatus == 1) {
            try {
                NGTLog.debug((String)"wait (write bytes)");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ByteBuffer buffer = par3;
        buffer.position(0);
        try {
            this.thread.channel.write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void endWriting() {
        while (this.thread.writingStatus == 0 || this.thread.writingStatus == 1) {
            try {
                NGTLog.debug((String)"wait (end writing)");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        NGTLog.debug((String)"end writing");
        this.thread.writingStatus = 0;
    }

    public synchronized void finishWriting() {
        while (this.thread.writingStatus == 1 || this.thread.writingStatus == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        NGTLog.debug((String)"finish writing");
        this.thread.writingStatus = 3;
    }

    public synchronized void resume() {
        this.notify();
    }
}

