/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.modelset;

import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.rtm.entity.util.ColFace;
import jp.ngt.rtm.entity.util.CollisionObj;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.render.ModelObject;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ModelSetBase<T extends ModelConfig>
extends ResourceSet<T> {
    @SideOnly(value=Side.CLIENT)
    public ModelObject modelObj;
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation buttonTexture;
    @SideOnly(value=Side.CLIENT)
    public ScriptEngine guiSE;
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation guiTexture;
    private CollisionObj collisionObj;
    private boolean syncFinished;
    public ScriptEngine serverSE;

    public ModelSetBase() {
    }

    public ModelSetBase(T par1) {
        super(par1);
    }

    @Override
    public void constructOnServer() {
        if (((ModelConfig)this.cfg).serverScriptPath != null) {
            this.serverSE = ScriptUtil.doScript((String)ModelPackManager.INSTANCE.getScript(((ModelConfig)this.cfg).serverScriptPath));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void constructOnClient() {
        if (!this.isDummy()) {
            if (((ModelConfig)this.cfg).serverScriptPath != null) {
                this.serverSE = ScriptUtil.doScript((String)ModelPackManager.INSTANCE.getScript(((ModelConfig)this.cfg).serverScriptPath));
            }
            if (((ModelConfig)this.cfg).guiScriptPath != null) {
                this.guiSE = ScriptUtil.doScript((String)ModelPackManager.INSTANCE.getScript(((ModelConfig)this.cfg).guiScriptPath));
                this.guiTexture = ModelPackManager.INSTANCE.getResource(((ModelConfig)this.cfg).guiTexture);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void finishConstruct() {
        if (this.modelObj != null) {
            this.collisionObj = new CollisionObj(this.modelObj.model, (ModelConfig)this.getConfig());
        }
    }

    @Override
    public T getConfig() {
        return (T)((ModelConfig)this.cfg);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderModelInGui(Minecraft mc) {
        this.modelObj.render(null, (ModelConfig)this.getConfig(), 0, 0.0f);
    }

    public void addColFace(String partsName, ColFace face, byte status) {
        if (!this.syncFinished) {
            if (this.collisionObj == null) {
                this.collisionObj = new CollisionObj();
            }
            this.collisionObj.addColFace(partsName, face, status);
            this.syncFinished = status == 2;
        }
    }

    public CollisionObj getCollisionObj() {
        return this.collisionObj;
    }
}

