/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.modelset;

import jp.ngt.rtm.entity.util.CollisionObj;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.cfg.NPCConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.render.ModelObject;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelSetNPC
extends ModelSetBase<NPCConfig> {
    public final ResourceLocation texture;
    public final ResourceLocation lightTexture;

    public ModelSetNPC() {
        this.texture = ModelPackManager.INSTANCE.getResource("textures/container/19g_JRF_0.png");
        this.lightTexture = null;
    }

    public ModelSetNPC(NPCConfig cfg) {
        super(cfg);
        this.texture = cfg.texture != null ? ModelPackManager.INSTANCE.getResource(cfg.texture) : null;
        this.lightTexture = cfg.lightTexture != null ? ModelPackManager.INSTANCE.getResource(cfg.lightTexture) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void constructOnClient() {
        super.constructOnClient();
        if (this.isDummy()) {
            this.modelObj = ModelObject.getDummy();
            this.buttonTexture = ModelPackManager.INSTANCE.getResource("textures/container/button_19g_JRF_0.png");
        } else {
            NPCConfig cfg = (NPCConfig)this.getConfig();
            if (cfg.model != null) {
                this.modelObj = new ModelObject(cfg.model, this, null, new Object[0]);
            }
            this.buttonTexture = ModelPackManager.INSTANCE.getResource(cfg.buttonTexture);
        }
    }

    @Override
    public NPCConfig getDummyConfig() {
        return NPCConfig.getDummy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderModelInGui(Minecraft par1) {
        if (this.modelObj != null) {
            this.modelObj.render(null, (ModelConfig)this.getConfig(), 0, 0.0f);
        }
    }

    @Override
    public CollisionObj getCollisionObj() {
        return null;
    }
}

