/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.state;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.ResourceConfig;
import jp.ngt.rtm.modelpack.state.DataEntry;
import jp.ngt.rtm.modelpack.state.DataMap;
import jp.ngt.rtm.modelpack.state.DataType;
import jp.ngt.rtm.modelpack.state.IDataFilter;

public final class DataFormatter {
    private final Map<String, IDataFilter> filterMap = new HashMap<String, IDataFilter>();
    private final Map<String, String[]> suggestionMap = new HashMap<String, String[]>();
    private final ResourceConfig.DMInitValue[] initValues;

    public DataFormatter(@Nullable ResourceConfig cfg) {
        if (cfg == null || cfg.defaultValues == null) {
            this.initValues = new ResourceConfig.DMInitValue[0];
        } else {
            this.initValues = cfg.defaultValues;
            for (ResourceConfig.DMInitValue val : cfg.defaultValues) {
                DataType type = DataType.getType(val.type);
                if (type == null) continue;
                this.addValue(type, val);
            }
        }
    }

    private void addValue(DataType type, ResourceConfig.DMInitValue val) {
        IDataFilter filter = null;
        if (type == DataType.INT || type == DataType.HEX) {
            if (val.minmax != null) {
                filter = data -> {
                    int iData = data instanceof String ? Integer.valueOf((String)data).intValue() : ((Integer)data).intValue();
                    return (double)iData >= val.minmax[0] && (double)iData <= val.minmax[1];
                };
            }
        } else if (type == DataType.DOUBLE) {
            if (val.minmax != null) {
                filter = data -> {
                    double dData = data instanceof String ? Double.valueOf((String)data).doubleValue() : ((Double)data).doubleValue();
                    return dData >= val.minmax[0] && dData <= val.minmax[1];
                };
            }
        } else if (type == DataType.STRING && val.pattern != null) {
            filter = data -> {
                String s0 = (String)data;
                String start = val.pattern[0];
                String contains = val.pattern[1];
                String end = val.pattern[2];
                return !(!start.isEmpty() && !s0.startsWith(start) || !contains.isEmpty() && !s0.contains(contains) || !end.isEmpty() && !s0.endsWith(end));
            };
        }
        if (filter != null) {
            this.filterMap.put(val.key, filter);
        }
        if (type == DataType.BOOLEAN) {
            val.suggestions = new String[]{String.valueOf(false), String.valueOf(true)};
        } else if (val.suggestions != null) {
            if (val.suggestions[0].equals("-file")) {
                if (filter != null) {
                    List<File> list = ModelPackManager.INSTANCE.fileCache;
                    ArrayList<String> tempList = new ArrayList<String>();
                    for (File file : list) {
                        String path = file.getAbsolutePath();
                        if (!filter.check(path)) continue;
                        tempList.add(DataFormatter.pathToRL(path));
                    }
                    val.suggestions = tempList.toArray(new String[tempList.size()]);
                }
            } else if (val.suggestions[0].equals("-value")) {
                int min = (int)Double.valueOf(val.minmax[0]).doubleValue();
                int max = (int)Double.valueOf(val.minmax[1]).doubleValue();
                val.suggestions = new String[max - min + 1];
                for (int i = 0; i < val.suggestions.length; ++i) {
                    val.suggestions[i] = String.valueOf(i + min);
                }
            }
        }
        if (val.suggestions != null) {
            this.suggestionMap.put(val.key, val.suggestions);
        }
    }

    private static String pathToRL(String path) {
        path = path.replace('\\', '/');
        int i0 = path.indexOf("assets") + 7;
        String s0 = path.substring(i0);
        int i1 = s0.indexOf(47);
        String domain = s0.substring(0, i1);
        String path2 = s0.substring(i1 + 1);
        return domain + ":" + path2;
    }

    public void initDataMap(DataMap dm) {
        dm.setFormatter(this);
        for (ResourceConfig.DMInitValue val : this.initValues) {
            String key = val.key;
            String value = String.format("(%s)%s", val.type, val.value);
            if (dm.contains(key) || dm.set(key, value, 3)) continue;
            NGTLog.debug((String)"Failed to set value : %s=%s", (Object[])new Object[]{key, value});
        }
    }

    public boolean check(String key, DataEntry value) {
        IDataFilter filter = this.filterMap.get(key);
        if (filter != null) {
            return filter.check(value.get());
        }
        return true;
    }

    public IDataFilter getFilter(String key) {
        return this.filterMap.get(key);
    }

    public String[] getSuggestions(String key) {
        return this.suggestionMap.get(key);
    }
}

