/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.state;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.state.DataEntry;
import jp.ngt.rtm.modelpack.state.DataEntryBoolean;
import jp.ngt.rtm.modelpack.state.DataEntryDouble;
import jp.ngt.rtm.modelpack.state.DataEntryHex;
import jp.ngt.rtm.modelpack.state.DataEntryInt;
import jp.ngt.rtm.modelpack.state.DataEntryString;
import jp.ngt.rtm.modelpack.state.DataEntryVec;
import jp.ngt.rtm.modelpack.state.DataFormatter;
import jp.ngt.rtm.network.PacketNotice;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class DataMap {
    public static final byte SYNC_FLAG = 1;
    public static final byte SAVE_FLAG = 2;
    private static final Pattern VAL_TYPE = Pattern.compile("\\([a-zA-Z]+\\)");
    private final Map<String, DataEntry> map = new HashMap<String, DataEntry>();
    private Object entity;
    private DataFormatter dataFormatter = new DataFormatter(null);

    public void setEntity(Object par1) {
        this.entity = par1;
    }

    public void setFormatter(DataFormatter formatter) {
        this.dataFormatter = formatter;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("DataList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            String type = entry.func_74779_i("Type");
            String name = entry.func_74779_i("Name");
            int flag = entry.func_74762_e("Flag");
            DataEntry de = DataEntry.getEntry(type, "", flag);
            de.readFromNBT(entry);
            this.set(name, de, flag);
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, DataEntry> entry : this.map.entrySet()) {
            if ((entry.getValue().flag & 2) == 0) continue;
            NBTTagCompound nbt2 = new NBTTagCompound();
            nbt2.func_74778_a("Name", entry.getKey());
            nbt2.func_74768_a("Flag", entry.getValue().flag);
            entry.getValue().writeToNBT(nbt2);
            list.func_74742_a((NBTBase)nbt2);
        }
        nbt.func_74782_a("DataList", (NBTBase)list);
        return nbt;
    }

    private void sendPacket(String key, DataEntry value, boolean toClient) {
        PacketNotice packet = null;
        if (this.entity instanceof Entity) {
            Entity entity = (Entity)this.entity;
            String msg = String.format("DM,%s,%d,%s,%s,%s,%d", "E", entity.func_145782_y(), key, value.getType().key, value.toString(), value.flag);
            packet = toClient ? new PacketNotice(1, msg, entity) : new PacketNotice(0, msg, entity);
        } else if (this.entity instanceof TileEntity) {
            TileEntity te = (TileEntity)this.entity;
            String pos = String.format("%d %d %d", te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
            String msg = String.format("DM,%s,%s,%s,%s,%s,%d", "T", pos, key, value.getType().key, value.toString(), value.flag);
            PacketNotice packetNotice = packet = toClient ? new PacketNotice(1, msg, te) : new PacketNotice(0, msg, te);
        }
        if (packet != null) {
            if (toClient) {
                RTMCore.NETWORK_WRAPPER.sendToAll(packet);
            } else {
                RTMCore.NETWORK_WRAPPER.sendToServer(packet);
            }
        }
    }

    public static void receivePacket(String msg, PacketNotice packet, World world, boolean onClient) {
        String[] sa2;
        BlockPos pos;
        TileEntity entity;
        String[] sa = msg.split(",");
        String target = sa[1];
        String targetId = sa[2];
        String key = sa[3];
        String type = sa[4];
        String data = sa[5];
        int flag = Integer.valueOf(sa[6]);
        int fSync = flag & 1;
        int fSave = flag & 2;
        if (onClient) {
            fSync = 0;
        }
        flag = fSync | fSave;
        DataEntry de = DataEntry.getEntry(type, data, flag);
        if (target.equals("E")) {
            int id = Integer.valueOf(targetId);
            Entity entity2 = world.func_73045_a(id);
            if (entity2 instanceof IResourceSelector) {
                ((IResourceSelector)entity2).getResourceState().getDataMap().set(key, de, flag);
            }
        } else if (target.equals("T") && (entity = world.func_175625_s(pos = new BlockPos(Integer.valueOf((sa2 = targetId.split(" "))[0]).intValue(), Integer.valueOf(sa2[1]).intValue(), Integer.valueOf(sa2[2]).intValue()))) instanceof IResourceSelector) {
            ((IResourceSelector)entity).getResourceState().getDataMap().set(key, de, flag);
        }
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    private <T extends DataEntry> T get(String key) {
        return (T)this.map.get(key);
    }

    private void set(String key, DataEntry value, int flag) {
        if (!this.dataFormatter.check(key, value)) {
            NGTLog.debug((String)"Invalid data : %s=%s", (Object[])new Object[]{key, value.toString()});
            return;
        }
        boolean sync = (flag & 1) != 0;
        boolean onServerSide = NGTUtil.isServer();
        if (onServerSide || !sync || this.entity == null) {
            this.map.put(key, value);
        }
        if (sync) {
            this.sendPacket(key, value, onServerSide);
        }
    }

    public boolean set(String key, String value, int flag) {
        Matcher matcher = VAL_TYPE.matcher(value);
        DataEntry entry = null;
        if (matcher.find()) {
            String type = matcher.group().replace("(", "").replace(")", "");
            String val2 = matcher.replaceAll("");
            entry = DataEntry.getEntry(type, val2, flag);
        } else {
            entry = (DataEntry)this.get(key);
            entry = DataEntry.getEntry(entry.getType().key, value, flag);
        }
        if (entry != null) {
            this.set(key, entry, flag);
            return true;
        }
        NGTLog.debug((String)"[DataMap] Invalid Data (Key:%s, Value:%s)", (Object[])new Object[]{key, value});
        return false;
    }

    public Map<String, DataEntry> getEntries() {
        return this.map;
    }

    public String getArg() {
        StringBuilder sb = new StringBuilder("");
        int count = 0;
        for (Map.Entry<String, DataEntry> entry : this.map.entrySet()) {
            ++count;
            sb.append(entry.getKey());
            sb.append("=(");
            sb.append(entry.getValue().getType().key);
            sb.append(")");
            sb.append(entry.getValue().data.toString());
            if (count >= this.map.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void setArg(String par1, boolean overwrite) {
        String[][] array;
        for (String[] sa : array = DataMap.convertArg(par1)) {
            if (this.map.containsKey(sa[0]) && !overwrite) continue;
            this.set(sa[0], String.format("(%s)%s", sa[1], sa[2]), 3);
        }
    }

    public static String[][] convertArg(String par1) {
        String[] sa = par1.split(",");
        String[][] array = new String[sa.length][];
        for (int i = 0; i < array.length; ++i) {
            String s = sa[i];
            int idxEq = s.indexOf(61);
            int idxBr = s.indexOf(41);
            if (idxEq < 0 || idxBr < 0) {
                NGTLog.debug((String)"Invalid data : %s", (Object[])new Object[]{s});
                return new String[0][0];
            }
            String key = s.substring(0, idxEq);
            String type = s.substring(idxEq + 2, idxBr);
            String value = s.substring(idxBr + 1);
            array[i] = new String[]{key, type, value};
        }
        return array;
    }

    public int getInt(String key) {
        try {
            DataEntryInt de = (DataEntryInt)this.get(key);
            return de != null ? (Integer)de.get() : 0;
        }
        catch (Exception e) {
            NGTLog.debug((String)"%s is not Integer", (Object[])new Object[]{key});
            return 0;
        }
    }

    public void setInt(String key, int value, int flag) {
        this.set(key, new DataEntryInt(value, flag), flag);
    }

    public double getDouble(String key) {
        try {
            DataEntryDouble de = (DataEntryDouble)this.get(key);
            double value = de != null ? (Double)de.get() : 0.0;
            return value;
        }
        catch (Exception e) {
            NGTLog.debug((String)"%s is not Double", (Object[])new Object[]{key});
            return 0.0;
        }
    }

    public void setDouble(String key, double value, int flag) {
        this.set(key, new DataEntryDouble(value, flag), flag);
    }

    public boolean getBoolean(String key) {
        try {
            DataEntryBoolean de = (DataEntryBoolean)this.get(key);
            return de != null ? (Boolean)de.get() : false;
        }
        catch (Exception e) {
            NGTLog.debug((String)"%s is not Boolean", (Object[])new Object[]{key});
            return false;
        }
    }

    public void setBoolean(String key, boolean value, int flag) {
        this.set(key, new DataEntryBoolean(value, flag), flag);
    }

    public String getString(String key) {
        try {
            DataEntryString de = (DataEntryString)this.get(key);
            return de != null ? (String)de.get() : "";
        }
        catch (Exception e) {
            NGTLog.debug((String)"%s is not String", (Object[])new Object[]{key});
            return "";
        }
    }

    public void setString(String key, String value, int flag) {
        this.set(key, new DataEntryString(value, flag), flag);
    }

    public Vec3 getVec(String key) {
        try {
            DataEntryVec de = (DataEntryVec)this.get(key);
            return de != null ? (Vec3)de.get() : Vec3.ZERO;
        }
        catch (Exception e) {
            NGTLog.debug((String)"%s is not Vec", (Object[])new Object[]{key});
            return Vec3.ZERO;
        }
    }

    public void setVec(String key, Vec3 value, int flag) {
        this.set(key, new DataEntryVec(value, flag), flag);
    }

    public int getHex(String key) {
        try {
            DataEntryHex de = (DataEntryHex)this.get(key);
            return de != null ? (Integer)de.get() : 0;
        }
        catch (Exception e) {
            NGTLog.debug((String)"%s is not Hex", (Object[])new Object[]{key});
            return 0;
        }
    }

    public void setHex(String key, int value, int flag) {
        this.set(key, new DataEntryHex(value, flag), flag);
    }
}

