/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.network.PacketCustom;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.rail.TileEntityMarker;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMarkerRPClient
extends PacketCustom
implements IMessageHandler<PacketMarkerRPClient, IMessage> {
    private RailPosition[] railPositions;

    public PacketMarkerRPClient() {
    }

    public PacketMarkerRPClient(TileEntityMarker marker) {
        super((TileEntity)marker);
        this.railPositions = marker.getAllRP();
    }

    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte(this.railPositions.length);
        for (RailPosition rp : this.railPositions) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)rp.writeToNBT());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        int size = buffer.readByte();
        if (size > 0) {
            this.railPositions = new RailPosition[size];
            for (int i = 0; i < size; ++i) {
                NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buffer);
                this.railPositions[i] = RailPosition.readFromNBT(nbt);
            }
        }
    }

    public IMessage onMessage(PacketMarkerRPClient message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        for (RailPosition rp : message.railPositions) {
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)rp.blockX, (int)rp.blockY, (int)rp.blockZ);
            if (!(tile instanceof TileEntityMarker)) continue;
            ((TileEntityMarker)tile).setMarkerRP(rp);
        }
        TileEntity tile = message.getTileEntity(world);
        if (tile instanceof TileEntityMarker) {
            TileEntityMarker marker = (TileEntityMarker)tile;
            RTMBlock.marker.onMarkerActivated(world, marker.func_174877_v().func_177958_n(), marker.func_174877_v().func_177956_o(), marker.func_174877_v().func_177952_p(), (EntityPlayer)ctx.getServerHandler().field_147369_b, false);
        }
        return null;
    }
}

