/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.block.BlockArgHolder;
import jp.ngt.ngtlib.block.BlockContainerCustomWithMeta;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMRail;
import jp.ngt.rtm.item.ItemRail;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.TileEntityLargeRailSwitchBase;
import jp.ngt.rtm.rail.TileEntityLargeRailSwitchCore;
import jp.ngt.rtm.rail.TileEntityMarker;
import jp.ngt.rtm.rail.TileEntityTurnTableCore;
import jp.ngt.rtm.rail.util.RailMaker;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailMapSwitch;
import jp.ngt.rtm.rail.util.RailMapTurntable;
import jp.ngt.rtm.rail.util.RailPosition;
import jp.ngt.rtm.rail.util.SwitchType;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMarker
extends BlockContainerCustomWithMeta {
    public final MarkerType markerType;

    public BlockMarker(MarkerType type) {
        super(Material.field_151592_s);
        this.markerType = type;
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setAABB(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        switch (this.markerType) {
            case STANDARD: {
                items.add((Object)new ItemStack((Block)this, 1, 0));
                items.add((Object)new ItemStack((Block)this, 1, 4));
                break;
            }
            case SWITCH: {
                items.add((Object)new ItemStack((Block)this, 1, 0));
                items.add((Object)new ItemStack((Block)this, 1, 4));
            }
        }
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityMarker();
    }

    public static int getFacing(EntityLivingBase placer, boolean isDiagonal) {
        if (isDiagonal) {
            return NGTMath.floor((double)(NGTMath.normalizeAngle((double)((double)placer.field_70177_z + 180.0)) / 90.0)) & 3;
        }
        return NGTMath.floor((double)(NGTMath.normalizeAngle((double)((double)placer.field_70177_z + 180.0)) / 90.0 + 0.5)) & 3;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int meta = stack.func_77952_i();
        int playerFacing = BlockMarker.getFacing(placer, meta >= 4);
        int i = meta / 4;
        BlockUtil.setBlock((World)world, (BlockPos)pos, (Block)this, (int)(playerFacing + i * 4), (int)2);
    }

    protected boolean onBlockActivated(BlockArgHolder holder, float hitX, float hitY, float hitZ) {
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        int x = holder.getBlockPos().func_177958_n();
        int y = holder.getBlockPos().func_177956_o();
        int z = holder.getBlockPos().func_177952_p();
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null) {
            TileEntity tile = world.func_175625_s(holder.getBlockPos());
            if (!(tile instanceof TileEntityMarker)) {
                return true;
            }
            TileEntityMarker marker = (TileEntityMarker)tile;
            if (item.func_77973_b() == Item.func_150898_a((Block)RTMBlock.marker) || item.func_77973_b() == Item.func_150898_a((Block)RTMBlock.markerSwitch)) {
                if (world.field_72995_K) {
                    player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdRailMarker, world, x, y, z);
                }
                return true;
            }
        }
        if (!world.field_72995_K && this.onMarkerActivated(world, x, y, z, player, true) && !player.field_71075_bZ.field_75098_d) {
            item.func_190918_g(1);
        }
        return true;
    }

    public void makeRailMap(TileEntityMarker marker, int x, int y, int z) {
        this.onMarkerActivated(marker.func_145831_w(), x, y, z, null, false);
    }

    public boolean onMarkerActivated(World world, int x, int y, int z, EntityPlayer player, boolean makeRail) {
        ResourceStateRail prop = this.hasRail(player, makeRail);
        if (prop != null) {
            boolean isCreative = player == null || player.field_71075_bZ.field_75098_d;
            List<RailPosition> rps = this.searchAllMarker(world, x, y, z);
            for (RailPosition rp : rps) {
                rp.addHeight(prop.blockHeight - 0.0625f);
            }
            return BlockMarker.createRail(world, x, y, z, rps, prop, makeRail, isCreative);
        }
        return false;
    }

    private List<RailPosition> searchAllMarker(World world, int x, int y, int z) {
        ArrayList<RailPosition> list = new ArrayList<RailPosition>();
        short dis1 = RTMCore.railGeneratingDistance;
        int dis2 = dis1 * 2;
        short hei1 = RTMCore.railGeneratingHeight;
        int hei2 = hei1 * 2;
        for (int i = 0; i < dis2; ++i) {
            for (int j = 0; j < hei2; ++j) {
                for (int k = 0; k < dis2; ++k) {
                    int x0 = x - dis1 + i;
                    int y0 = y - hei1 + j;
                    int z0 = z - dis1 + k;
                    RailPosition rp = this.getRailPosition(world, x0, y0, z0);
                    if (rp == null) continue;
                    list.add(rp);
                }
            }
        }
        list.sort((arg0, arg1) -> {
            if (arg0.switchType != arg1.switchType) {
                return arg1.switchType - arg0.switchType;
            }
            if (arg0.blockY != arg1.blockY) {
                return arg0.blockY - arg1.blockY;
            }
            return arg0.hashCode() - arg1.hashCode();
        });
        return list;
    }

    public static boolean createRail(World world, int x, int y, int z, List<RailPosition> rps, ResourceStateRail state, boolean makeRail, boolean isCreative) {
        if (rps.size() == 2) {
            RailPosition rp1 = rps.get(0);
            RailPosition rp2 = rps.get(1);
            if (rp1.switchType == 1 && rp2.switchType == 1) {
                BlockMarker.createTurntable(world, rp1, rp2, state, makeRail, isCreative);
            } else {
                RailPosition start = rp2.blockY >= rp1.blockY ? rp1 : rp2;
                RailPosition end = rp2.blockY >= rp1.blockY ? rp2 : rp1;
                BlockMarker.createNormalRail(world, start, end, state, makeRail, isCreative);
            }
        } else if (rps.size() > 2) {
            BlockMarker.createSwitchRail(world, x, y, z, rps, state, makeRail, isCreative);
        }
        return false;
    }

    private static boolean createNormalRail(World world, RailPosition start, RailPosition end, ResourceStateRail prop, boolean makeRail, boolean isCreative) {
        RailMap railMap = new RailMap(start, end);
        if (makeRail && railMap.canPlaceRail(world, isCreative, prop)) {
            railMap.setRail(world, RTMRail.largeRailBase, start.blockX, start.blockY, start.blockZ, prop);
            BlockUtil.setBlock((World)world, (int)start.blockX, (int)start.blockY, (int)start.blockZ, (Block)RTMRail.largeRailCore, (int)0, (int)3);
            TileEntityLargeRailCore tile = (TileEntityLargeRailCore)BlockUtil.getTileEntity((IBlockAccess)world, (int)start.blockX, (int)start.blockY, (int)start.blockZ);
            tile.setRailPositions(new RailPosition[]{start, end});
            tile.getResourceState().readFromNBT(prop.writeToNBT());
            tile.setStartPoint(start.blockX, start.blockY, start.blockZ);
            tile.createRailMap();
            tile.sendPacket();
            if (BlockUtil.getBlock((IBlockAccess)world, (int)end.blockX, (int)end.blockY, (int)end.blockZ) instanceof BlockMarker) {
                BlockUtil.setAir((World)world, (int)end.blockX, (int)end.blockY, (int)end.blockZ);
            }
            return true;
        }
        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)start.blockX, (int)start.blockY, (int)start.blockZ);
        if (tile instanceof TileEntityMarker) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            list.add(new BlockPos(start.blockX, start.blockY, start.blockZ));
            list.add(new BlockPos(end.blockX, end.blockY, end.blockZ));
            ((TileEntityMarker)tile).setMarkersPos(list);
        }
        return false;
    }

    private static boolean createSwitchRail(World world, int x, int y, int z, List<RailPosition> list, ResourceStateRail prop, boolean makeRail, boolean isCreative) {
        RailMaker railMaker = new RailMaker(world, list);
        SwitchType st = railMaker.getSwitch();
        if (st == null) {
            return false;
        }
        RailMapSwitch[] railMaps = st.getAllRailMap();
        if (railMaps == null) {
            return false;
        }
        boolean flag = false;
        for (RailMapSwitch rm : railMaps) {
            if (rm.canPlaceRail(world, isCreative, prop)) continue;
            flag = true;
        }
        if (!makeRail || flag) {
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
            if (tile instanceof TileEntityMarker) {
                ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                for (int i = 0; i < list.size(); ++i) {
                    RailPosition rp = list.get(i);
                    posList.add(new BlockPos(rp.blockX, rp.blockY, rp.blockZ));
                }
                ((TileEntityMarker)tile).setMarkersPos(posList);
            }
            return false;
        }
        RailPosition rps = list.get(0);
        x = rps.blockX;
        y = rps.blockY;
        z = rps.blockZ;
        for (RailMapSwitch rm : railMaps) {
            rm.setRail(world, RTMRail.largeRailBase, x, y, z, prop);
        }
        for (RailPosition rp : list) {
            BlockUtil.setBlock((World)world, (int)rp.blockX, (int)rp.blockY, (int)rp.blockZ, (Block)RTMRail.largeRailSwitchBase, (int)0, (int)3);
            TileEntityLargeRailSwitchBase tile = (TileEntityLargeRailSwitchBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)rp.blockX, (int)rp.blockY, (int)rp.blockZ);
            tile.setStartPoint(x, y, z);
        }
        BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)RTMRail.largeRailSwitchCore, (int)0, (int)3);
        TileEntityLargeRailSwitchCore tile = (TileEntityLargeRailSwitchCore)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
        tile.setRailPositions(list.toArray(new RailPosition[list.size()]));
        tile.getResourceState().readFromNBT(prop.writeToNBT());
        tile.setStartPoint(x, y, z);
        tile.createRailMap();
        tile.sendPacket();
        return true;
    }

    private static boolean createTurntable(World world, RailPosition start, RailPosition end, ResourceStateRail prop, boolean makeRail, boolean isCreative) {
        int cx = 0;
        int cy = start.blockY;
        int cz = 0;
        int r = 0;
        if (start.blockX == end.blockX && (start.blockZ - end.blockZ) % 2 == 0) {
            cx = start.blockX;
            cz = (start.blockZ + end.blockZ) / 2;
            r = Math.abs(start.blockZ - end.blockZ) / 2;
        }
        if (start.blockZ == end.blockZ && (start.blockX - end.blockX) % 2 == 0) {
            cx = (start.blockX + end.blockX) / 2;
            cz = start.blockZ;
            r = Math.abs(start.blockX - end.blockX) / 2;
        }
        if (r == 0) {
            return false;
        }
        RailMapTurntable railMap = new RailMapTurntable(start, end, cx, cy, cz, r);
        if (makeRail && railMap.canPlaceRail(world, isCreative, prop)) {
            railMap.setRail(world, RTMRail.largeRailBase, cx, cy, cz, prop);
            BlockUtil.setBlock((World)world, (int)cx, (int)cy, (int)cz, (Block)RTMRail.TURNTABLE_CORE, (int)0, (int)3);
            TileEntityTurnTableCore tile = (TileEntityTurnTableCore)BlockUtil.getTileEntity((IBlockAccess)world, (int)cx, (int)cy, (int)cz);
            tile.setRailPositions(new RailPosition[]{start, end});
            tile.getResourceState().readFromNBT(prop.writeToNBT());
            tile.setStartPoint(cx, cy, cz);
            tile.createRailMap();
            tile.sendPacket();
            return true;
        }
        return false;
    }

    public static byte getMarkerDir(Block block, int meta) {
        int i0 = meta & 3;
        int i1 = (6 - i0 & 3) * 2;
        if ((block == RTMBlock.marker || block == RTMBlock.markerSwitch) && meta >= 4) {
            i1 = i1 + 7 & 7;
        }
        return (byte)i1;
    }

    private RailPosition getRailPosition(World world, int x, int y, int z) {
        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (tile instanceof TileEntityMarker) {
            return ((TileEntityMarker)tile).getMarkerRP();
        }
        return null;
    }

    public ResourceStateRail hasRail(@Nullable EntityPlayer player, boolean par2) {
        if (player == null) {
            return ItemRail.getDefaultProperty();
        }
        if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editRail")) {
            ItemStack item = player.field_71071_by.func_70448_g();
            if (item.func_77973_b() == RTMItem.itemLargeRail) {
                return ((ItemRail)RTMItem.itemLargeRail).getModelState(item);
            }
            if (player.field_71075_bZ.field_75098_d || !par2) {
                return ItemRail.getDefaultProperty();
            }
        }
        return null;
    }

    public static enum MarkerType {
        STANDARD(0xFF0000),
        SWITCH(255);

        public final int color;

        private MarkerType(int par1) {
            this.color = par1;
        }
    }
}

