/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.protection.Lockable;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.network.PacketLargeRailBase;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import jp.ngt.rtm.rail.ILargeRail;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityLargeRailBase
extends TileEntityCustom
implements ILargeRail,
Lockable,
ITickable {
    private static final int SPLIT = 128;
    protected int[] startPoint = new int[3];
    private boolean finishSetupBlockBounds;
    private float[] blockHeights;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int x = nbt.func_74762_e("spX");
        int y = nbt.func_74762_e("spY");
        int z = nbt.func_74762_e("spZ");
        this.setStartPoint(x, y, z);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("spX", this.startPoint[0]);
        nbt.func_74768_a("spY", this.startPoint[1]);
        nbt.func_74768_a("spZ", this.startPoint[2]);
        return nbt;
    }

    public int[] getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(int x, int y, int z) {
        this.startPoint[0] = x;
        this.startPoint[1] = y;
        this.startPoint[2] = z;
        if (this.func_145831_w() == null || !this.func_145831_w().field_72995_K) {
            this.func_70296_d();
            this.sendPacket();
        }
    }

    public boolean isTrainOnRail() {
        TileEntityLargeRailCore tile = this.getRailCore();
        if (tile != null) {
            return tile.isCollidedTrain;
        }
        return false;
    }

    protected void sendPacket() {
        RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketLargeRailBase(this));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && !this.finishSetupBlockBounds && this.getRailCore() != null) {
            BlockUtil.markBlockForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
            this.finishSetupBlockBounds = true;
        }
    }

    @Override
    public RailMap getRailMap(Entity entity) {
        TileEntityLargeRailCore tile = this.getRailCore();
        if (tile != null) {
            return tile.getRailMap(entity);
        }
        return null;
    }

    public TileEntityLargeRailCore getRailCore() {
        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_145831_w(), (int)this.startPoint[0], (int)this.startPoint[1], (int)this.startPoint[2]);
        if (tile != null && tile instanceof TileEntityLargeRailCore) {
            return (TileEntityLargeRailCore)tile;
        }
        return null;
    }

    public static TileEntityLargeRailBase getRailFromCoordinates(World world, double px, double py, double pz, int minY) {
        Block block;
        int y;
        int x = NGTMath.floor((double)px);
        int z = NGTMath.floor((double)pz);
        for (y = NGTMath.floor((double)py); y > minY && !((block = BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)y, (int)z)) instanceof BlockLargeRailBase); --y) {
        }
        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (tile != null && tile instanceof TileEntityLargeRailBase) {
            return (TileEntityLargeRailBase)tile;
        }
        return null;
    }

    public static RailMap getRailMapFromCoordinates(World world, Entity entity, double px, double py, double pz) {
        TileEntityLargeRailBase rail = TileEntityLargeRailBase.getRailFromCoordinates(world, px, py, pz, 0);
        if (rail != null) {
            return rail.getRailMap(entity);
        }
        return null;
    }

    public Block func_145838_q() {
        Block block;
        if (this.field_145854_h == null && (block = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()) instanceof BlockLargeRailBase) {
            this.field_145854_h = block;
        }
        return this.field_145854_h;
    }

    public float[] getBlockHeights(int x, int y, int z, float defaultHeight, boolean useCache) {
        float[] fa;
        if (useCache && this.blockHeights != null) {
            return this.blockHeights;
        }
        if ((this.finishSetupBlockBounds || !useCache) && (fa = this.getBlockHeights(x, y, z, defaultHeight)) != null) {
            if (useCache) {
                this.blockHeights = fa;
                if (!this.field_145850_b.field_72995_K) {
                    this.finishSetupBlockBounds = true;
                }
            }
            return fa;
        }
        float f0 = 0.0625f;
        return new float[]{f0, f0, f0, f0};
    }

    private float[] getBlockHeights(int x, int y, int z, float defaultHeight) {
        TileEntityLargeRailCore core = this.getRailCore();
        if (core == null) {
            return null;
        }
        RailMap[] rms = core.getAllRailMaps();
        if (rms == null) {
            return null;
        }
        float[] fa = new float[]{defaultHeight, defaultHeight, defaultHeight, defaultHeight};
        for (int i = 0; i < fa.length; ++i) {
            int x0 = x + (i == 1 || i == 2 ? 1 : 0);
            int z0 = z + (i == 0 || i == 1 ? 1 : 0);
            double distanceSq = Double.MAX_VALUE;
            for (RailMap rm : rms) {
                double[] rpos;
                double dSq2;
                int index = rm.getNearlestPoint(128, x0, z0);
                if (index < 0) {
                    index = 0;
                }
                if (!((dSq2 = NGTMath.getDistanceSq((double)x0, (double)z0, (double)(rpos = rm.getRailPos(128, index))[1], (double)rpos[0])) < distanceSq)) continue;
                distanceSq = dSq2;
                double height = rm.getRailHeight(128, index);
                float yaw = rm.getRailRotation(128, index);
                float cant = rm.getCant(128, index);
                float yaw2 = (float)NGTMath.toDegrees((double)Math.atan2(rpos[1] - (double)x0, rpos[0] - (double)z0));
                double len = Math.sqrt((rpos[1] - (double)x0) * (rpos[1] - (double)x0) + (rpos[0] - (double)z0) * (rpos[0] - (double)z0));
                boolean dirFlag = NGTMath.wrapAngle((float)(yaw2 - yaw)) > 0.0f;
                double h2 = (double)NGTMath.sin((float)cant) * len * (double)(dirFlag ? -1.0f : 1.0f);
                fa[i] = (float)(height - (double)y + h2);
            }
        }
        return fa;
    }

    public boolean isReberbSound() {
        IBlockState state;
        ResourceStateRail property;
        TileEntityLargeRailCore core = this.getRailCore();
        return core != null && !(property = core.getResourceState()).getBlockState().func_185914_p() && !(state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b())).func_185914_p();
    }

    public void setPos(int x, int y, int z, int prevX, int prevY, int prevZ) {
        int difX = x - prevX;
        int difY = y - prevY;
        int difZ = z - prevZ;
        this.startPoint[0] = this.startPoint[0] + difX;
        this.startPoint[1] = this.startPoint[1] + difY;
        this.startPoint[2] = this.startPoint[2] + difZ;
        super.setPos(x, y, z, prevX, prevY, prevZ);
    }

    public Object getTarget(World world, int x, int y, int z) {
        return this.getRailCore();
    }

    public boolean lock(EntityPlayer player, String code) {
        return true;
    }

    public boolean unlock(EntityPlayer player, String code) {
        return true;
    }

    public int getProhibitedAction() {
        return 1;
    }
}

