/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.gui.InternalButton;
import jp.ngt.rtm.gui.InternalGUI;
import jp.ngt.rtm.item.ItemRail;
import jp.ngt.rtm.rail.BlockMarker;
import jp.ngt.rtm.rail.util.MarkerState;
import jp.ngt.rtm.rail.util.RailMaker;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailPosition;
import jp.ngt.rtm.rail.util.SwitchType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMarker
extends TileEntityCustom
implements ITickable {
    private RailPosition rp;
    private BlockPos startPos;
    private RailMap[] railMaps;
    private List<BlockPos> markerPosList = new ArrayList<BlockPos>();
    private List<int[]> grid;
    public float startPlayerPitch;
    public float startPlayerYaw;
    public byte startMarkerHeight;
    public int editMode;
    private int markerState = MarkerState.ANCHOR21.set(this.markerState, false);
    @SideOnly(value=Side.CLIENT)
    public InternalGUI gui;
    @SideOnly(value=Side.CLIENT)
    public InternalButton[] buttons;
    @SideOnly(value=Side.CLIENT)
    public float[][][] linePos;
    private int count;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("RP")) {
            this.rp = RailPosition.readFromNBT(nbt.func_74775_l("RP"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.rp != null) {
            nbt.func_74782_a("RP", (NBTBase)this.rp.writeToNBT());
        }
        return nbt;
    }

    public void func_73660_a() {
        if (this.rp == null) {
            byte dir = BlockMarker.getMarkerDir(this.func_145838_q(), this.func_145832_p());
            byte type = (byte)(this.func_145838_q() == RTMBlock.markerSwitch ? 1 : 0);
            this.rp = new RailPosition(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), dir, type);
        }
        if (this.func_145831_w().field_72995_K) {
            if (this.count >= 60) {
                this.updateStartPos();
                this.count = 0;
            }
            ++this.count;
        }
    }

    private void updateStartPos() {
        if (this.startPos != null) {
            TileEntity tileEntity = this.func_145831_w().func_175625_s(this.startPos);
            if (!(tileEntity instanceof TileEntityMarker)) {
                this.startPos = null;
            }
        } else {
            ((BlockMarker)this.func_145838_q()).makeRailMap(this, this.getX(), this.getY(), this.getZ());
        }
    }

    public RailPosition getMarkerRP() {
        return this.rp;
    }

    public void setMarkerRP(RailPosition par1) {
        this.rp = par1;
    }

    private RailPosition getMarkerRP(BlockPos pos) {
        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_145831_w(), (BlockPos)pos);
        if (tile instanceof TileEntityMarker) {
            return ((TileEntityMarker)tile).rp;
        }
        return null;
    }

    public List<int[]> getGrid() {
        return this.grid;
    }

    public RailMap[] getRailMaps() {
        return this.railMaps;
    }

    public void onChangeRailShape() {
        if (!this.isCoreMarker()) {
            TileEntityMarker marker = this.getCoreMarker();
            if (marker != null) {
                marker.onChangeRailShape();
            }
        } else {
            RailMap[] maps = new RailMap[this.railMaps.length];
            for (int i = 0; i < maps.length; ++i) {
                RailPosition rp0 = this.railMaps[i].getStartRP();
                RailPosition rp1 = this.railMaps[i].getEndRP();
                rp1.cantCenter = -rp0.cantCenter;
                maps[i] = new RailMap(rp0, rp1);
            }
            this.railMaps = maps;
            this.linePos = null;
            this.createGrids();
            for (BlockPos pos : this.markerPosList) {
                TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_145831_w(), (BlockPos)pos);
                if (!(tile instanceof TileEntityMarker)) continue;
                TileEntityMarker marker = (TileEntityMarker)tile;
                marker.railMaps = maps;
            }
        }
    }

    public void setMarkersPos(List<BlockPos> list) {
        BlockPos newStartPos = null;
        if (list.size() == 2) {
            if (list.get(0) != null && list.get(1) != null) {
                RailPosition rp0 = this.getMarkerRP(list.get(0));
                RailPosition rp1 = this.getMarkerRP(list.get(1));
                if (rp0 != null && rp1 != null) {
                    RailMap rm = new RailMap(rp0, rp1);
                    this.railMaps = new RailMap[]{rm};
                    newStartPos = new BlockPos(rp0.blockX, rp0.blockY, rp0.blockZ);
                }
            }
        } else {
            ArrayList<RailPosition> list2 = new ArrayList<RailPosition>();
            for (BlockPos pos : list) {
                RailPosition rp0 = this.getMarkerRP(pos);
                if (rp0 == null) continue;
                list2.add(rp0);
            }
            SwitchType type = new RailMaker(this.func_145831_w(), list2).getSwitch();
            if (type != null) {
                this.railMaps = type.getAllRailMap();
                if (this.railMaps != null) {
                    RailPosition rp0 = this.railMaps[0].getStartRP();
                    newStartPos = new BlockPos(rp0.blockX, rp0.blockY, rp0.blockZ);
                }
            }
        }
        if (this.railMaps == null) {
            return;
        }
        this.markerPosList = list;
        this.createGrids();
        if (newStartPos != null) {
            for (int i = 0; i < list.size(); ++i) {
                BlockPos pos = list.get(i);
                TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_145831_w(), (BlockPos)pos);
                if (!(tile instanceof TileEntityMarker)) continue;
                TileEntityMarker marker = (TileEntityMarker)tile;
                marker.setStartPos(newStartPos, this.railMaps);
            }
        }
    }

    private void createGrids() {
        this.grid = new ArrayList<int[]>();
        for (RailMap rm : this.railMaps) {
            this.grid.addAll(rm.getRailBlockList(ItemRail.getDefaultProperty(), true));
        }
    }

    private void setStartPos(BlockPos pos, RailMap[] maps) {
        NGTLog.debug((String)"[Marker] Start pos %s", (Object[])new Object[]{pos.toString()});
        this.startPos = pos;
        this.railMaps = maps;
        if (!this.isCoreMarker()) {
            this.markerPosList.clear();
            this.grid = null;
        }
    }

    public boolean isCoreMarker() {
        if (this.startPos == null) {
            return false;
        }
        return this.startPos.func_177958_n() == this.getX() && this.startPos.func_177956_o() == this.getY() && this.startPos.func_177952_p() == this.getZ();
    }

    public TileEntityMarker getCoreMarker() {
        if (this.startPos == null) {
            return null;
        }
        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_145831_w(), (BlockPos)this.startPos);
        if (tile instanceof TileEntityMarker) {
            return (TileEntityMarker)tile;
        }
        return null;
    }

    public RailPosition[] getAllRP() {
        if (this.markerPosList.isEmpty()) {
            return new RailPosition[]{this.rp};
        }
        ArrayList<RailPosition> list2 = new ArrayList<RailPosition>();
        for (BlockPos pos : this.markerPosList) {
            RailPosition rp0 = this.getMarkerRP(pos);
            if (rp0 == null) continue;
            list2.add(rp0);
        }
        return list2.toArray(new RailPosition[list2.size()]);
    }

    public boolean getState(MarkerState state) {
        return state.get(this.markerState);
    }

    public void flipState(MarkerState state) {
        boolean data = state.get(this.markerState);
        this.setState(state, data ^ true);
    }

    public void setState(MarkerState state, boolean data) {
        block3: {
            block1: {
                block2: {
                    if (this.isCoreMarker()) break block1;
                    TileEntityMarker marker = this.getCoreMarker();
                    if (marker == null) break block2;
                    marker.setState(state, data);
                    break block3;
                }
                if (state != MarkerState.DISTANCE) break block3;
                this.markerState = state.set(this.markerState, data);
                break block3;
            }
            this.markerState = state.set(this.markerState, data);
            for (BlockPos pos : this.markerPosList) {
                TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_145831_w(), (BlockPos)pos);
                if (!(tile instanceof TileEntityMarker)) continue;
                TileEntityMarker marker = (TileEntityMarker)tile;
                marker.markerState = this.markerState;
            }
        }
    }

    public String getStateString(MarkerState state) {
        boolean data = state.get(this.markerState);
        return String.format("%s : %s", state.toString(), data ? "ON" : "OFF");
    }
}

