/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.rail.util.RailDir;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailMapSwitch;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class Point {
    private static final int MAX_COUNT = 80;
    public final RailPosition rpRoot;
    public final RailMapSwitch rmMain;
    public final RailMapSwitch rmBranch;
    public final RailDir branchDir;
    public final boolean mainDirIsPositive;
    public final boolean branchDirIsPositive;
    private int moveCount;
    private int crossPosMain = -1;
    private int crossPosBranch = -1;
    private float crossAngle = 0.0f;

    public Point(RailPosition railPos, RailMapSwitch rms1, RailMapSwitch rms2) {
        this.rpRoot = railPos;
        boolean b0 = rms1.getLength() <= rms2.getLength();
        this.rmMain = b0 ? rms1 : rms2;
        this.rmBranch = b0 ? rms2 : rms1;
        this.branchDir = this.getDir(this.rpRoot, this.rmMain, this.rmBranch);
        this.mainDirIsPositive = this.rmMain.getStartRP() == this.rpRoot;
        this.branchDirIsPositive = this.rmBranch.getStartRP() == this.rpRoot;
    }

    public Point(RailPosition railPos, RailMapSwitch rms1) {
        this.rpRoot = railPos;
        this.rmMain = rms1;
        this.rmBranch = null;
        this.branchDir = RailDir.NONE;
        this.mainDirIsPositive = rms1.getStartRP() == railPos;
        this.branchDirIsPositive = false;
    }

    private RailDir getDir(RailPosition rpr, RailMapSwitch rms1, RailMapSwitch rms2) {
        RailPosition rp1 = rms1.startRP == rpr ? rms1.endRP : rms1.startRP;
        RailPosition rp2 = rms2.startRP == rpr ? rms2.endRP : rms2.startRP;
        return rpr.getDir(rp1, rp2);
    }

    public void onUpdate(World world) {
        boolean hasRSInput = this.rpRoot.checkRSInput(world);
        if (hasRSInput) {
            if (this.moveCount < 80) {
                ++this.moveCount;
            }
        } else if (this.moveCount > 0) {
            --this.moveCount;
        }
    }

    public float getMovement() {
        return (float)this.moveCount / 80.0f;
    }

    public RailMap getActiveRailMap(World world) {
        if (this.branchDir == RailDir.NONE) {
            return this.rmMain;
        }
        boolean hasRSInput = this.rpRoot.checkRSInput(world);
        return hasRSInput ? this.rmBranch : this.rmMain;
    }

    public int getCrossPosMain(float hGauge, int splitM, int splitB) {
        if (this.crossPosMain < 0) {
            this.crossPosMain = this.getCrossPos(hGauge, splitM, splitB, true);
        }
        return this.crossPosMain;
    }

    public int getCrossPosBranch(float hGauge, int splitM, int splitB) {
        if (this.crossPosBranch < 0) {
            this.crossPosBranch = this.getCrossPos(hGauge, splitM, splitB, false);
        }
        return this.crossPosBranch;
    }

    public int getCrossPos(float hGauge, int splitM, int splitB, boolean isMain) {
        float vxM = hGauge * (this.mainDirIsPositive && this.branchDir == RailDir.LEFT || !this.mainDirIsPositive && this.branchDir == RailDir.RIGHT ? 1.0f : -1.0f);
        float vxB = hGauge * (this.branchDirIsPositive && this.branchDir == RailDir.RIGHT || !this.branchDirIsPositive && this.branchDir == RailDir.LEFT ? 1.0f : -1.0f);
        int indexM = 0;
        int indexB = 0;
        double distanceSq = Double.MAX_VALUE;
        for (int i = 0; i <= splitM; ++i) {
            double[] posM = this.rmMain.getRailPos(splitM, i);
            float yawM = this.rmMain.getRailRotation(splitM, i);
            Vec3 vecM = PooledVec3.create((double)vxM, (double)0.0, (double)0.0);
            vecM = vecM.rotateAroundY(yawM);
            for (int j = 0; j <= splitB; ++j) {
                double difZ;
                double[] posB = this.rmBranch.getRailPos(splitB, j);
                float yawB = this.rmBranch.getRailRotation(splitB, j);
                Vec3 vecB = PooledVec3.create((double)vxB, (double)0.0, (double)0.0);
                vecB = vecB.rotateAroundY(yawB);
                double difX = posM[1] + vecM.getX() - (posB[1] + vecB.getX());
                double d0 = difX * difX + (difZ = posM[0] + vecM.getZ() - (posB[0] + vecB.getZ())) * difZ;
                if (!(d0 < distanceSq)) continue;
                this.crossAngle = MathHelper.func_76142_g((float)(yawM - yawB)) % 90.0f;
                indexM = i;
                indexB = j;
                distanceSq = d0;
            }
        }
        return isMain ? indexM : indexB;
    }

    public float getCrossAngle() {
        return this.crossAngle;
    }
}

