/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.BezierCurve;
import jp.ngt.ngtlib.math.ILine;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.StraightLine;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.modelpack.cfg.RailConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetRail;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import jp.ngt.rtm.rail.BlockMarker;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RailMap {
    protected final RailPosition startRP;
    protected final RailPosition endRP;
    protected ILine lineHorizontal;
    protected ILine lineVertical;
    protected final List<int[]> rails = new ArrayList<int[]>();
    protected double length;

    public RailMap(RailPosition par1, RailPosition par2) {
        this.startRP = par1;
        this.endRP = par2;
        this.endRP.cantCenter = this.startRP.cantCenter;
        this.createLine();
    }

    public void rebuild() {
        this.createLine();
    }

    protected void createLine() {
        boolean flagV1;
        boolean flag3;
        double x0 = this.startRP.posX;
        double y0 = this.startRP.posY;
        double z0 = this.startRP.posZ;
        double x1 = this.endRP.posX;
        double y1 = this.endRP.posY;
        double z1 = this.endRP.posZ;
        boolean flag1 = (this.endRP.direction - this.startRP.direction) % 4 == 0;
        boolean flag2 = z0 == z1 || x0 == x1;
        boolean bl = flag3 = Math.abs(z0 - z1) == Math.abs(x0 - x1) && this.startRP.direction % 2 != 0 && this.endRP.direction % 2 != 0;
        if (flag1 && (flag2 || flag3)) {
            this.lineHorizontal = new StraightLine(z0, x0, z1, x1);
        } else {
            double d1;
            boolean b0;
            double min;
            double ddx;
            double ddz = Math.abs(z1 - z0);
            double max = ddz >= (ddx = Math.abs(x1 - x0)) ? ddz : ddx;
            double d = min = ddz <= ddx ? ddz : ddx;
            if (this.startRP.anchorLengthHorizontal <= 0.0f) {
                b0 = this.startRP.direction % 2 == 0;
                d1 = b0 ? max : min;
                this.startRP.anchorLengthHorizontal = (float)(d1 * 0.5522847771644592);
            }
            if (this.endRP.anchorLengthHorizontal <= 0.0f) {
                b0 = this.endRP.direction % 2 == 0;
                d1 = b0 ? max : min;
                this.endRP.anchorLengthHorizontal = (float)(d1 * 0.5522847771644592);
            }
            double d12 = NGTMath.cos((float)this.startRP.anchorYaw) * this.startRP.anchorLengthHorizontal;
            double d2 = NGTMath.sin((float)this.startRP.anchorYaw) * this.startRP.anchorLengthHorizontal;
            double d3 = NGTMath.cos((float)this.endRP.anchorYaw) * this.endRP.anchorLengthHorizontal;
            double d4 = NGTMath.sin((float)this.endRP.anchorYaw) * this.endRP.anchorLengthHorizontal;
            this.lineHorizontal = new BezierCurve(z0, x0, z0 + d12, x0 + d2, z1 + d3, x1 + d4, z1, x1);
        }
        double lenXZ = Math.sqrt(NGTMath.pow((double)(x1 - x0), (int)2) + NGTMath.pow((double)(z1 - z0), (int)2));
        boolean bl2 = flagV1 = this.startRP.anchorLengthVertical == 0.0f && this.endRP.anchorLengthVertical == 0.0f;
        if (flagV1) {
            this.lineVertical = new StraightLine(0.0, y0, lenXZ, y1);
        } else {
            double d1 = NGTMath.cos((float)this.startRP.anchorPitch) * this.startRP.anchorLengthVertical;
            double d2 = NGTMath.sin((float)this.startRP.anchorPitch) * this.startRP.anchorLengthVertical;
            double d3 = NGTMath.cos((float)this.endRP.anchorPitch) * this.endRP.anchorLengthVertical;
            double d4 = NGTMath.sin((float)this.endRP.anchorPitch) * this.endRP.anchorLengthVertical;
            this.lineVertical = new BezierCurve(0.0, y0, d1, y0 + d2, lenXZ - d3, y1 + d4, lenXZ, y1);
        }
    }

    protected void createRailList(ResourceStateRail prop) {
        ModelSetRail modelSet = (ModelSetRail)prop.getResourceSet();
        int halfWidth = ((RailConfig)modelSet.getConfig()).ballastWidth >> 1;
        this.rails.clear();
        int split = (int)(this.lineHorizontal.getLength() * 4.0);
        double halfPi = 1.5707963267948966;
        for (int j = 0; j < split; ++j) {
            double[] point = this.lineHorizontal.getPoint(split, j);
            double x = point[1];
            double z = point[0];
            double slope = this.lineHorizontal.getSlope(split, j);
            double height = this.getRailHeight(split, j);
            int y = (int)height;
            for (int i = 0; i <= halfWidth; ++i) {
                double d0 = (double)i + 0.25;
                int x1 = NGTMath.floor((double)(x + Math.sin(slope + halfPi) * d0));
                int z1 = NGTMath.floor((double)(z + Math.cos(slope + halfPi) * d0));
                this.addRailBlock(x1, y, z1);
                int x2 = NGTMath.floor((double)(x + Math.sin(slope - halfPi) * d0));
                int z2 = NGTMath.floor((double)(z + Math.cos(slope - halfPi) * d0));
                this.addRailBlock(x2, y, z2);
            }
            int x0 = NGTMath.floor((double)x);
            int z0 = NGTMath.floor((double)z);
            this.addRailBlock(x0, y, z0);
        }
    }

    protected void addRailBlock(int x, int y, int z) {
        for (int i = 0; i < this.rails.size(); ++i) {
            int[] ia = this.rails.get(i);
            if (ia[0] != x || ia[2] != z) continue;
            if (ia[1] <= y) {
                return;
            }
            this.rails.remove(i);
            --i;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!pos.equals((Object)this.getStartRP().getNeighborBlockPos()) && !pos.equals((Object)this.getEndRP().getNeighborBlockPos())) {
            this.rails.add(new int[]{x, y, z});
        }
    }

    public void setRail(World world, Block block, int x0, int y0, int z0, ResourceStateRail prop) {
        this.createRailList(prop);
        this.setBaseBlock(world, x0, y0, z0);
        for (int i = 0; i < this.rails.size(); ++i) {
            int z;
            int y;
            int x = this.rails.get(i)[0];
            Block block2 = BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y = this.rails.get(i)[1]), (int)(z = this.rails.get(i)[2]));
            if (block2 instanceof BlockLargeRailBase && block2 != block) continue;
            BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)2);
            TileEntityLargeRailBase tile = (TileEntityLargeRailBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
            tile.setStartPoint(x0, y0, z0);
        }
        this.rails.clear();
    }

    private void setBaseBlock(World world, int x0, int y0, int z0) {
        int split = (int)(this.lineHorizontal.getLength() * 4.0);
        RailPosition rp = this.getStartRP();
        int minWidth = NGTMath.floor((float)(rp.constLimitWN + 0.5f));
        int maxWidth = NGTMath.floor((float)(rp.constLimitWP + 0.5f));
        int minHeight = NGTMath.floor((float)rp.constLimitHN);
        int maxHeight = NGTMath.floor((float)rp.constLimitHP);
        IBlockState[][] template = new IBlockState[maxHeight - minHeight + 1][maxWidth - minWidth + 1];
        for (int k = 0; k < split - 1; ++k) {
            double[] point = this.lineHorizontal.getPoint(split, k);
            double x = point[1];
            double z = point[0];
            double y = this.getRailHeight(split, k);
            double slope = this.lineHorizontal.getSlope(split, k);
            float yaw = NGTMath.wrapAngle((float)((float)NGTMath.toDegrees((double)slope)));
            for (int i = 0; i < template.length; ++i) {
                int h = minHeight + i;
                for (int j = 0; j < template[i].length; ++j) {
                    int w = minWidth + j;
                    Vec3 vec = new Vec3((double)w, (double)h, 0.0);
                    vec = vec.rotateAroundY(yaw);
                    BlockPos pos = new BlockPos(x + vec.getX(), y + vec.getY(), z + vec.getZ());
                    if (k == 0) {
                        IBlockState state = world.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (block instanceof BlockMarker || block instanceof BlockLargeRailBase) continue;
                        template[i][j] = state;
                        continue;
                    }
                    if (template[i][j] == null || world.func_180495_p(pos).func_177230_c() instanceof BlockLargeRailBase) continue;
                    world.func_175656_a(pos, template[i][j]);
                }
            }
        }
    }

    public void breakRail(World world, ResourceStateRail prop, TileEntityLargeRailCore core) {
        this.createRailList(prop);
        for (int i = 0; i < this.rails.size(); ++i) {
            TileEntityLargeRailCore core2;
            TileEntityLargeRailBase rail;
            int z;
            int y;
            int x = this.rails.get(i)[0];
            if (!(BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y = this.rails.get(i)[1]), (int)(z = this.rails.get(i)[2])) instanceof BlockLargeRailBase) || (rail = (TileEntityLargeRailBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z)) == core || (core2 = rail.getRailCore()) != null && core2 != core) continue;
            world.func_175698_g(new BlockPos(x, y, z));
        }
        world.func_175698_g(core.func_174877_v());
        this.rails.clear();
    }

    public boolean canPlaceRail(World world, boolean isCreative, ResourceStateRail prop) {
        this.createRailList(prop);
        boolean flag = true;
        for (int i = 0; i < this.rails.size(); ++i) {
            boolean b0;
            int z;
            int y;
            int x = this.rails.get(i)[0];
            IBlockState state = world.func_180495_p(new BlockPos(x, y = this.rails.get(i)[1], z = this.rails.get(i)[2]));
            Block block = state.func_177230_c();
            boolean bl = b0 = block.func_149688_o(state) == Material.field_151579_a || block == RTMBlock.marker || block == RTMBlock.markerSwitch || block instanceof BlockLargeRailBase && !((BlockLargeRailBase)block).isCore();
            if (!isCreative && !b0) {
                NGTLog.sendChatMessageToAll((String)"message.rail.obstacle", (Object[])new Object[]{":" + x + "," + y + "," + z});
                return false;
            }
            flag = b0 && flag;
        }
        return isCreative || flag;
    }

    public List<int[]> getRailBlockList(ResourceStateRail prop, boolean regenerate) {
        if (this.rails.isEmpty() || regenerate) {
            this.createRailList(prop);
        }
        return new ArrayList<int[]>(this.rails);
    }

    public int getNearlestPoint(int par1, double par2, double par3) {
        return this.lineHorizontal.getNearlestPoint(par1, par2, par3);
    }

    public double[] getRailPos(int par1, int par2) {
        return this.lineHorizontal.getPoint(par1, par2);
    }

    public double getRailHeight(int par1, int par2) {
        float railWidth = 3.0f;
        double height = this.lineVertical.getPoint(par1, par2)[1];
        float cant = this.getCant(par1, par2);
        if (cant != 0.0f) {
            double h2 = Math.abs(NGTMath.sin((float)cant) * railWidth * 0.5f);
            height += h2;
        }
        return height;
    }

    public float getRailRotation(int par1, int par2) {
        return NGTMath.toDegrees((float)((float)this.lineHorizontal.getSlope(par1, par2)));
    }

    public float getRailPitch(int par1, int par2) {
        return NGTMath.toDegrees((float)((float)this.lineVertical.getSlope(par1, par2)));
    }

    public float getCant(int split, int t) {
        float ft = 2.0f * (float)t / (float)split;
        float c1 = ft <= 1.0f ? (1.0f - ft) * this.startRP.cantEdge : (ft - 1.0f) * -this.endRP.cantEdge;
        float c2 = ft <= 1.0f ? ft * this.startRP.cantCenter : (2.0f - ft) * this.startRP.cantCenter;
        float cunt = c1 + c2;
        float rand = 0.0f;
        if (this.startRP.cantRandom > 0.0f) {
            float x = (float)(this.getLength() * (double)t / (double)split) * this.startRP.cantRandom;
            float scale = 3.0f;
            rand = NGTMath.getSin((float)x) + NGTMath.getSin((float)(x * 0.51f)) + NGTMath.getSin((float)(x * 0.252f)) + NGTMath.getSin((float)(x * 0.1253f)) * 0.25f * scale;
        }
        return cunt + rand;
    }

    public double getLength() {
        if (this.length <= 0.0) {
            double height = this.endRP.posY - this.startRP.posY;
            if (height == 0.0) {
                this.length = this.lineHorizontal.getLength();
            } else {
                double d0 = this.lineHorizontal.getLength();
                this.length = Math.sqrt(d0 * d0 + height * height);
            }
        }
        return this.length;
    }

    public boolean hasPoint(int x, int z) {
        boolean flag1 = this.startRP.blockX == x && this.startRP.blockZ == z;
        boolean flag2 = this.endRP.blockX == x && this.endRP.blockZ == z;
        return flag1 || flag2;
    }

    public boolean isGettingPowered(World world) {
        return this.startRP.checkRSInput(world) && this.endRP.checkRSInput(world);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RailMap) {
            RailMap rm = (RailMap)obj;
            if (this.startRP.blockX == rm.startRP.blockX && this.startRP.blockY == rm.startRP.blockY && this.startRP.blockZ == rm.startRP.blockZ) {
                return true;
            }
        }
        return false;
    }

    public boolean canConnect(RailMap railMap) {
        if (railMap == null) {
            return false;
        }
        if (this.equals(railMap)) {
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double[] p1;
                double[] p0 = this.lineHorizontal.getPoint(10, i * 10);
                if (!NGTMath.compare((double)p0[0], (double)(p1 = railMap.lineHorizontal.getPoint(10, j * 10))[0], (int)5) || !NGTMath.compare((double)p0[1], (double)p1[1], (int)5)) continue;
                return true;
            }
        }
        return false;
    }

    public RailPosition getStartRP() {
        return this.startRP;
    }

    public RailPosition getEndRP() {
        return this.endRP;
    }

    public void showRailProp() {
        NGTLog.sendChatMessageToAll((String)String.format("SP X%5.1f Z%5.1f", this.getStartRP().posX, this.getStartRP().posZ), (Object[])new Object[0]);
        NGTLog.sendChatMessageToAll((String)String.format("SA L%5.1f Y%5.1f", Float.valueOf(this.getStartRP().anchorLengthHorizontal), Float.valueOf(this.getStartRP().anchorYaw)), (Object[])new Object[0]);
        NGTLog.sendChatMessageToAll((String)String.format("EP X%5.1f Z%5.1f", this.getEndRP().posX, this.getEndRP().posZ), (Object[])new Object[0]);
        NGTLog.sendChatMessageToAll((String)String.format("EA L%5.1f Y%5.1f", Float.valueOf(this.getEndRP().anchorLengthHorizontal), Float.valueOf(this.getEndRP().anchorYaw)), (Object[])new Object[0]);
    }
}

