/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.StraightLine;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailPosition;

public final class RailMapTurntable
extends RailMap {
    public final int centerX;
    public final int centerY;
    public final int centerZ;
    public final int radius;
    private float rotation;

    public RailMapTurntable(RailPosition par1, RailPosition par2, int x, int y, int z, int r) {
        super(par1, par2);
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
        this.radius = r;
    }

    @Override
    protected void createLine() {
        double x0 = this.startRP.posX;
        double y0 = this.startRP.posY;
        double z0 = this.startRP.posZ;
        double x1 = this.endRP.posX;
        double y1 = this.endRP.posY;
        double z1 = this.endRP.posZ;
        this.lineHorizontal = new StraightLine(z0, x0, z1, x1);
        this.lineVertical = new StraightLine(0.0, y0, (double)(this.radius * 2 + 1), y1);
    }

    private void recreateLine() {
        double cx = (double)this.centerX + 0.5;
        double cz = (double)this.centerZ + 0.5;
        double sx = this.startRP.posX - cx;
        double sz = this.startRP.posZ - cz;
        double ex = this.endRP.posX - cx;
        double ez = this.endRP.posZ - cz;
        double gain = 0.5;
        if (this.startRP.blockX == this.endRP.blockX) {
            ez += ez > (sz += sz > ez ? gain : -gain) ? gain : -gain;
        } else {
            ex += ex > (sx += sx > ex ? gain : -gain) ? gain : -gain;
        }
        Vec3 vStart = PooledVec3.create((double)sx, (double)0.0, (double)sz);
        Vec3 vEnd = PooledVec3.create((double)ex, (double)0.0, (double)ez);
        vStart = vStart.rotateAroundY(this.rotation);
        vEnd = vEnd.rotateAroundY(this.rotation);
        this.lineHorizontal = new StraightLine(vStart.getZ() + cz, vStart.getX() + cx, vEnd.getZ() + cz, vEnd.getX() + cx);
    }

    @Override
    protected void createRailList(ResourceStateRail prop) {
        this.rails.clear();
        for (int i = -this.radius; i < this.radius + 1; ++i) {
            for (int j = -this.radius; j < this.radius + 1; ++j) {
                double radSq = i * i + j * j;
                if (!(radSq <= (double)(((float)this.radius + 0.4999f) * ((float)this.radius + 0.4999f)))) continue;
                this.addRailBlock(this.centerX + i, this.centerY, this.centerZ + j);
            }
        }
    }

    @Override
    public int getNearlestPoint(int par1, double par2, double par3) {
        this.recreateLine();
        return super.getNearlestPoint(par1, par2, par3);
    }

    @Override
    public double[] getRailPos(int par1, int par2) {
        this.recreateLine();
        return super.getRailPos(par1, par2);
    }

    @Override
    public float getRailRotation(int par1, int par2) {
        this.recreateLine();
        return super.getRailRotation(par1, par2);
    }

    @Override
    public double getLength() {
        return this.radius * 2 + 1;
    }

    @Override
    public boolean canConnect(RailMap railMap) {
        this.recreateLine();
        return super.canConnect(railMap);
    }

    public void setRotation(float par1) {
        this.rotation = par1;
    }
}

