/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.renderer.model.Vertex;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.render.ActionType;
import jp.ngt.rtm.render.Parts;
import jp.ngt.rtm.render.PartsRenderer;
import jp.ngt.rtm.render.RenderPass;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class ActionParts
extends Parts {
    private static final float OUTLINE_THICKNESS = 0.005f;
    public final ActionType behavior;
    private GroupObject[] outlineModels;
    public int id;

    public ActionParts(ActionType par1, String ... par2) {
        super(par2);
        this.behavior = par1;
    }

    @Override
    public void init(PartsRenderer renderer) {
        super.init(renderer);
        this.setupOutlineModel(renderer);
    }

    private void setupOutlineModel(PartsRenderer renderer) {
        GroupObject[] objs = this.getObjects(renderer.modelObj.model);
        this.outlineModels = new GroupObject[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            GroupObject go = objs[i].copy("outline_" + i);
            go.smoothingAngle = 180.0f;
            go.calcVertexNormals(VecAccuracy.MEDIUM);
            for (int j = 0; j < go.faces.size(); ++j) {
                Face face = (Face)go.faces.get(j);
                for (int k = 0; k < face.vertices.length; ++k) {
                    Vertex vNormal = face.vertexNormals[k].copy(VecAccuracy.MEDIUM);
                    face.vertices[k] = face.vertices[k].add(vNormal.expand(0.005f));
                }
                face.calculateFaceNormal(VecAccuracy.MEDIUM);
            }
            this.outlineModels[i] = go;
        }
    }

    @Override
    public void render(PartsRenderer renderer) {
        if (renderer.currentPass == RenderPass.OUTLINE.id) {
            boolean hit = this.equals(renderer.hittedParts.get(renderer.hittedEntity));
            if (hit) {
                int color = Mouse.isButtonDown((int)1) ? 0xFF8000 : 0xFFFFFF;
                this.renderOutline(renderer, color);
            }
        } else if (renderer.currentPass == RenderPass.PICK.id) {
            GL11.glLoadName((int)this.id);
            boolean smoothing = ((ModelConfig)((ModelSetBase)renderer.modelSet).getConfig()).smoothing;
            IModelNGT model = renderer.modelObj.model;
            model.renderOnly(smoothing, this.objNames);
        } else {
            super.render(renderer);
        }
    }

    private void renderOutline(PartsRenderer par1, int color) {
        GL11.glPushMatrix();
        GL11.glCullFace((int)1028);
        GLHelper.disableLighting();
        GL11.glDisable((int)3553);
        GLHelper.setColor((int)color, (int)255);
        for (GroupObject obj : this.outlineModels) {
            obj.render(false);
        }
        GLHelper.setColor((int)0xFFFFFF, (int)255);
        GL11.glEnable((int)3553);
        GLHelper.enableLighting();
        GL11.glCullFace((int)1029);
        GL11.glPopMatrix();
    }

    @Override
    public boolean ignoreMatId(PartsRenderer renderer) {
        return renderer.currentPass == RenderPass.PICK.id;
    }
}

