/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.entity.npc.EntityNPC;
import jp.ngt.rtm.item.ItemGun;
import jp.ngt.rtm.modelpack.modelset.ModelSetNPC;
import jp.ngt.rtm.render.EntityPartsRenderer;
import jp.ngt.rtm.render.ModelObject;
import jp.ngt.rtm.render.Parts;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import org.lwjgl.opengl.GL11;

public class NPCPartsRenderer
extends EntityPartsRenderer<ModelSetNPC> {
    public float headAngleX;
    public float headAngleY;
    public float headAngleZ;
    public float bodyAngleX;
    public float bodyAngleY;
    public float bodyAngleZ;
    public float leftArmAngleX;
    public float leftArmAngleY;
    public float leftArmAngleZ;
    public float rightArmAngleX;
    public float rightArmAngleY;
    public float rightArmAngleZ;
    public float leftLegAngleX;
    public float leftLegAngleY;
    public float leftLegAngleZ;
    public float rightLegAngleX;
    public float rightLegAngleY;
    public float rightLegAngleZ;

    public NPCPartsRenderer(String ... par1) {
        super(par1);
    }

    @Override
    public void init(ModelSetNPC par1, ModelObject par2) {
        super.init(par1, par2);
    }

    public void rotateAndRender(Parts parts, float x, float y, float z, float rotationX, float rotationY, float rotationZ) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)NGTMath.toDegrees((float)rotationZ), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)NGTMath.toDegrees((float)rotationY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)NGTMath.toDegrees((float)rotationX), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)(-z));
        parts.render(this);
        GL11.glPopMatrix();
    }

    public void setRotationAngles(EntityLivingBase entity, float partialTicks) {
        if (entity == null) {
            return;
        }
        this.setupRotateCorpse(entity, partialTicks);
        float arg1 = this.getRendererArg1(entity, partialTicks);
        float arg2 = this.getRendererArg2(entity, partialTicks);
        float arg3 = this.getRendererArg3(entity, partialTicks);
        float arg4 = this.getRendererArg4(entity, partialTicks);
        float arg5 = this.getRendererArg5(entity, partialTicks);
        int heldItemRight = this.heldItemRight(entity);
        int heldItemLeft = this.heldItemLeft(entity);
        float radPIdiv10 = NGTMath.PI / 10.0f;
        this.headAngleY = NGTMath.toRadians((float)arg4);
        this.headAngleX = NGTMath.toRadians((float)arg5);
        this.rightArmAngleX = NGTMath.getCos((float)(arg1 * 0.6662f + NGTMath.PI)) * 2.0f * arg2 * 0.5f;
        this.leftArmAngleX = NGTMath.getCos((float)(arg1 * 0.6662f)) * 2.0f * arg2 * 0.5f;
        this.rightArmAngleZ = 0.0f;
        this.leftArmAngleZ = 0.0f;
        this.rightLegAngleX = NGTMath.getCos((float)(arg1 * 0.6662f)) * 1.4f * arg2;
        this.leftLegAngleX = NGTMath.getCos((float)(arg1 * 0.6662f + NGTMath.PI)) * 1.4f * arg2;
        this.rightLegAngleY = 0.0f;
        this.leftLegAngleY = 0.0f;
        if (this.isRiding(entity)) {
            this.rightArmAngleX += -(NGTMath.PI / 5.0f);
            this.leftArmAngleX += -(NGTMath.PI / 5.0f);
            this.rightLegAngleX = -(NGTMath.PI * 2.0f / 5.0f);
            this.leftLegAngleX = -(NGTMath.PI * 2.0f / 5.0f);
            this.rightLegAngleY = radPIdiv10;
            this.leftLegAngleY = -radPIdiv10;
        }
        if (heldItemLeft > 0) {
            this.leftArmAngleX = this.leftArmAngleX * 0.5f - radPIdiv10 * (float)heldItemLeft;
        }
        this.rightArmAngleY = 0.0f;
        this.leftArmAngleY = 0.0f;
        switch (heldItemRight) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.rightArmAngleX = this.rightArmAngleX * 0.5f - radPIdiv10 * (float)heldItemRight;
                break;
            }
            case 3: {
                this.rightArmAngleX = this.rightArmAngleX * 0.5f - radPIdiv10 * (float)heldItemRight;
                this.rightArmAngleY = -0.5235988f;
            }
        }
        float swingProgress = this.getSwingProgress(entity, partialTicks);
        if (swingProgress > 0.0f) {
            this.bodyAngleY = NGTMath.getSin((float)((float)(Math.sqrt(swingProgress) * (double)NGTMath.PI * 2.0))) * 0.2f;
            this.rightArmAngleY += this.bodyAngleY;
            this.leftArmAngleY += this.bodyAngleY;
            this.leftArmAngleX += this.bodyAngleY;
            float f = 1.0f - swingProgress;
            f = f * f * f * f;
            f = 1.0f - f;
            float f1 = NGTMath.getSin((float)(f * NGTMath.PI));
            float f2 = NGTMath.getSin((float)(swingProgress * NGTMath.PI)) * -(this.headAngleX - 0.7f) * 0.75f;
            this.rightArmAngleX = (float)((double)this.rightArmAngleX - ((double)f1 * 1.2 + (double)f2));
            this.rightArmAngleY += this.bodyAngleY * 2.0f;
            this.rightArmAngleZ += NGTMath.getSin((float)(swingProgress * NGTMath.PI)) * -0.4f;
        }
        if (this.isSneak(entity)) {
            this.bodyAngleX = 0.5f;
            this.rightArmAngleX += 0.4f;
            this.leftArmAngleX += 0.4f;
        } else {
            this.bodyAngleX = 0.0f;
        }
        this.rightArmAngleZ += NGTMath.getCos((float)(arg3 * 0.09f)) * 0.05f + 0.05f;
        this.leftArmAngleZ -= NGTMath.getCos((float)(arg3 * 0.09f)) * 0.05f + 0.05f;
        this.rightArmAngleX += NGTMath.getSin((float)(arg3 * 0.067f)) * 0.05f;
        this.leftArmAngleX -= NGTMath.getSin((float)(arg3 * 0.067f)) * 0.05f;
        if (this.aimedBow(entity)) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            this.rightArmAngleZ = 0.0f;
            this.leftArmAngleZ = 0.0f;
            this.rightArmAngleY = -(0.1f - f3 * 0.6f) + this.headAngleY;
            this.leftArmAngleY = 0.1f - f3 * 0.6f + this.headAngleY + 0.4f;
            this.rightArmAngleX = -NGTMath.toRadians((float)90.0f) + this.headAngleX;
            this.leftArmAngleX = -NGTMath.toRadians((float)90.0f) + this.headAngleX;
            this.rightArmAngleX -= f3 * 1.2f - f4 * 0.4f;
            this.leftArmAngleX -= f3 * 1.2f - f4 * 0.4f;
            this.rightArmAngleZ += NGTMath.getCos((float)(arg3 * 0.09f)) * 0.05f + 0.05f;
            this.leftArmAngleZ -= NGTMath.getCos((float)(arg3 * 0.09f)) * 0.05f + 0.05f;
            this.rightArmAngleX += NGTMath.getSin((float)(arg3 * 0.067f)) * 0.05f;
            this.leftArmAngleX -= NGTMath.getSin((float)(arg3 * 0.067f)) * 0.05f;
        }
        float f0 = this.rightArmAngleY;
        this.rightArmAngleY = this.leftArmAngleY;
        this.leftArmAngleY = f0;
        f0 = this.rightArmAngleZ;
        this.rightArmAngleZ = this.leftArmAngleZ;
        this.leftArmAngleZ = f0;
        f0 = this.rightLegAngleX;
        this.rightLegAngleX = this.leftLegAngleX;
        this.leftLegAngleX = f0;
        f0 = this.rightLegAngleY;
        this.rightLegAngleY = this.leftLegAngleY;
        this.leftLegAngleY = f0;
        f0 = this.rightLegAngleZ;
        this.rightLegAngleZ = this.leftLegAngleZ;
        this.leftLegAngleZ = f0;
        this.headAngleY = -this.headAngleY;
        this.bodyAngleY = -this.bodyAngleY;
    }

    public boolean aimedBow(EntityLivingBase entity) {
        ItemStack heldItem = entity.func_184586_b(EnumHand.MAIN_HAND);
        boolean hasGun = heldItem != null && heldItem.func_77973_b() instanceof ItemGun;
        boolean usingGun = hasGun && ((EntityNPC)entity).isUsingItem();
        return usingGun;
    }

    public boolean isRiding(EntityLivingBase entity) {
        return entity.func_184218_aH();
    }

    public int heldItemLeft(EntityLivingBase entity) {
        return 0;
    }

    public int heldItemRight(EntityLivingBase entity) {
        ItemStack heldItem = entity.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return 0;
        }
        return 1;
    }

    public float getSwingProgress(EntityLivingBase entity, float partialTicks) {
        return entity.func_70678_g(partialTicks);
    }

    public boolean isSneak(EntityLivingBase entity) {
        return entity.func_70093_af();
    }

    public float getRendererArg1(EntityLivingBase entity, float partialTicks) {
        return entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
    }

    public float getRendererArg2(EntityLivingBase entity, float partialTicks) {
        return entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
    }

    public float getRendererArg3(EntityLivingBase entity, float partialTicks) {
        return (float)entity.field_70173_aa + partialTicks;
    }

    public float getRendererArg4(EntityLivingBase entity, float partialTicks) {
        float f = this.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
        float f1 = this.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTicks);
        float f2 = f1 - f;
        if (entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityLivingBase) {
            EntityLivingBase riding = (EntityLivingBase)entity.func_184187_bx();
            f = this.interpolateRotation(riding.field_70760_ar, riding.field_70761_aq, partialTicks);
            f2 = f1 - f;
        }
        return f2;
    }

    public float getRendererArg5(EntityLivingBase entity, float partialTicks) {
        return entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
    }

    public float interpolateRotation(float par1, float par2, float par3) {
        float f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par1 + par3 * f;
    }

    public void setupRotateCorpse(EntityLivingBase entity, float partialTicks) {
        float f = this.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
        float f8 = this.handleRotationFloat(entity, partialTicks);
        this.rotateCorpse(entity, f8, f, partialTicks);
    }

    public void rotateCorpse(EntityLivingBase entity, float p_77043_2_, float yaw, float partialTicks) {
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entity.field_70725_aQ > 0) {
            float f = (float)NGTMath.firstSqrt((double)(((float)entity.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f));
            if (f > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.getDeathMaxRotation(entity)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public float handleRotationFloat(EntityLivingBase entity, float partialTicks) {
        return (float)entity.field_70173_aa + partialTicks;
    }

    public float getDeathMaxRotation(EntityLivingBase entity) {
        return 90.0f;
    }
}

