/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.render.PartsRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Parts {
    public final String[] objNames;
    private GroupObject[] objs;
    private GLObject[] gLists;
    protected boolean ignoreCollision;

    public Parts(String ... par1) {
        this.objNames = par1;
    }

    public void init(PartsRenderer renderer) {
        this.gLists = new GLObject[renderer.modelObj.textures.length];
    }

    public GroupObject[] getObjects(IModelNGT model) {
        if (this.objs == null) {
            this.objs = new GroupObject[this.objNames.length];
            block0: for (int i = 0; i < this.objs.length; ++i) {
                for (GroupObject obj : model.getGroupObjects()) {
                    if (!this.objNames[i].equals(obj.name)) continue;
                    this.objs[i] = obj;
                    continue block0;
                }
            }
        }
        return this.objs;
    }

    public boolean containsName(String name) {
        return NGTUtil.contains((Object[])this.objNames, (Object)name);
    }

    public void render(PartsRenderer renderer) {
        boolean smoothing = ((ModelConfig)((ModelSetBase)renderer.modelSet).getConfig()).smoothing;
        IModelNGT model = renderer.modelObj.model;
        if (model.getGroupObjects().isEmpty()) {
            model.renderOnly(smoothing, this.objNames);
        } else {
            int i = renderer.currentMatId;
            if (!GLHelper.isValid((GLObject)this.gLists[i])) {
                this.gLists[i] = GLHelper.generateGLList((GLObject)this.gLists[i]);
                GLHelper.startCompile((GLObject)this.gLists[i]);
                NGTRenderHelper.renderCustomModel((IModelNGT)model, (byte)((byte)i), (boolean)smoothing, (String[])this.objNames);
                GLHelper.endCompile();
            } else {
                if (smoothing) {
                    GL11.glShadeModel((int)7425);
                }
                if (this.ignoreMatId(renderer)) {
                    for (GLObject glo : this.gLists) {
                        GLHelper.callList((GLObject)glo);
                    }
                } else {
                    GLHelper.callList((GLObject)this.gLists[i]);
                }
                if (smoothing) {
                    GL11.glShadeModel((int)7424);
                }
            }
        }
    }

    public boolean ignoreMatId(PartsRenderer renderer) {
        return false;
    }

    public void ignoreCollision(boolean par1) {
        this.ignoreCollision = par1;
    }
}

