/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.MCWrapperClient;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.render.ActionParts;
import jp.ngt.rtm.render.ActionType;
import jp.ngt.rtm.render.ModelObject;
import jp.ngt.rtm.render.Parts;
import jp.ngt.rtm.render.RenderPass;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public abstract class PartsRenderer<T, MS extends ModelSetBase> {
    public static final String PACKAGE_NAME = "jp.ngt.rtm.render";
    public static final Calendar CALENDAR = Calendar.getInstance();
    public static final ResourceLocation TEX_LIGHT = new ResourceLocation("rtm", "textures/effect/light.png");
    protected MS modelSet;
    protected ModelObject modelObj;
    private ScriptEngine script;
    protected List<Parts> partsList = new ArrayList<Parts>();
    protected List<ActionParts> targetsList = new ArrayList<ActionParts>();
    protected Map<Integer, Object> dataMap = new HashMap<Integer, Object>();
    public int currentMatId;
    public int currentPass;
    public T hittedEntity;
    protected Map<T, ActionParts> hittedParts = new HashMap<T, ActionParts>();
    private int mouseHoldCount;
    private int dragStartPos;
    protected static final double BRIGHTNESS_RATE = 0.00390625;
    protected static final boolean DEBUG = false;
    protected static final byte DIV_NUM = 32;
    protected static final float ANGLE = 11.25f;

    public PartsRenderer(String ... par1) {
    }

    public void setScript(ScriptEngine se, ResourceLocation rl) {
        this.script = se;
    }

    public ScriptEngine getScript() {
        return this.script;
    }

    private void execScriptFunc(String func, Object ... args) {
        try {
            ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)func, (Object[])args);
        }
        catch (Exception e) {
            throw new RuntimeException("On init script : " + ((ModelSetBase)this.modelSet).getConfig().getName(), e);
        }
    }

    public Parts registerParts(Parts par1) {
        this.partsList.add(par1);
        if (par1 instanceof ActionParts) {
            ActionParts actionParts = (ActionParts)par1;
            actionParts.id = this.targetsList.size() + 1;
            this.targetsList.add(actionParts);
        }
        return par1;
    }

    public void init(MS par1, ModelObject par2) {
        this.modelSet = par1;
        this.modelObj = par2;
        if (this.script != null) {
            this.execScriptFunc("init", par1, par2);
        }
        for (Parts parts : this.partsList) {
            parts.init(this);
        }
    }

    public void preRender(T t, boolean smoothing, boolean culling, float par3) {
    }

    public void postRender(T t, boolean smoothing, boolean culling, float par3) {
    }

    private ActionParts selectHits(T t, int hits) {
        if (hits <= 0) {
            return Mouse.isButtonDown((int)1) ? this.hittedParts.get(t) : null;
        }
        int hitIndex = 1;
        double minDepth = Double.MAX_VALUE;
        for (int i = 0; i < hits; ++i) {
            int hitNo;
            double depth = GLHelper.getPickedObjDepth((int)i);
            if (!(depth < minDepth)) continue;
            hitIndex = hitNo = GLHelper.getPickedObjId((int)i);
            minDepth = depth;
        }
        return this.targetsList.get(hitIndex - 1);
    }

    private void checkMouseAction(T t) {
        if (Mouse.isButtonDown((int)1)) {
            ActionParts parts = this.hittedParts.get(t);
            if (parts != null && this.hittedEntity == t) {
                if (parts.behavior == ActionType.TOGGLE) {
                    if (this.mouseHoldCount == 0) {
                        this.onRightClick(this.hittedEntity, parts);
                    }
                    ++this.mouseHoldCount;
                } else {
                    int currentPos;
                    int n = currentPos = parts.behavior == ActionType.DRAG_X ? Mouse.getX() : Mouse.getY();
                    if (this.mouseHoldCount == 0) {
                        this.dragStartPos = currentPos;
                    }
                    this.onRightDrag(t, parts, currentPos - this.dragStartPos);
                    ++this.mouseHoldCount;
                }
            }
        } else {
            this.mouseHoldCount = 0;
            this.dragStartPos = 0;
        }
    }

    private void onRightClick(T t, ActionParts parts) {
        this.execScriptFunc("onRightClick", t, parts);
    }

    private void onRightDrag(T t, ActionParts parts, int move) {
        this.execScriptFunc("onRightDrag", t, parts, move);
    }

    public void render(T t, RenderPass pass, float partialTick) {
        if (t != null && pass == RenderPass.NORMAL && this.currentMatId == 0 && !this.targetsList.isEmpty()) {
            this.render(t, RenderPass.PICK, partialTick);
        }
        this.currentPass = pass.id;
        if (pass == RenderPass.PICK) {
            GLHelper.startMousePicking((float)1.0f);
        }
        this.execScriptFunc("render", t, pass.id, Float.valueOf(partialTick));
        if (pass == RenderPass.PICK) {
            int hits = GLHelper.finishMousePicking();
            ActionParts parts = this.selectHits(t, hits);
            if (parts != null) {
                this.hittedEntity = t;
            }
            this.hittedParts.put(t, parts);
            this.checkMouseAction(t);
        }
    }

    public boolean shouldRenderOutline(Object entity) {
        return this.hittedEntity == entity && this.hittedParts.get(entity) != null;
    }

    public String getModelName() {
        return ((ModelSetBase)this.modelSet).getConfig().getName();
    }

    @Deprecated
    public float sigmoid(float par1) {
        return (float)NGTMath.sigmoid((double)par1, (double)5.0);
    }

    public void rotate(float angle, char axis, float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
        switch (axis) {
            case 'X': {
                GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 'Y': {
                GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 'Z': {
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GL11.glTranslatef((float)(-x), (float)(-y), (float)(-z));
    }

    public int getMCTime() {
        return (int)NGTUtil.getClientWorld().func_72820_D() % 24000;
    }

    public int getMCHour() {
        int t0 = this.getMCTime();
        return (t0 / 1000 + 6) % 24;
    }

    public int getMCMinute() {
        int t0 = this.getMCTime();
        return (int)((float)(t0 % 1000) * 0.06f);
    }

    public int getSystemTime() {
        return (int)(System.currentTimeMillis() / 1000L % 86400L);
    }

    public long getSystemTimeMillis() {
        return System.currentTimeMillis();
    }

    public int getSystemHour() {
        return CALENDAR.get(11);
    }

    public int getSystemMinute() {
        return CALENDAR.get(12);
    }

    public int getSystemSecond() {
        return CALENDAR.get(13);
    }

    public int getSystemMillisecond() {
        return CALENDAR.get(14);
    }

    public Object getData(int id) {
        if (this.dataMap.containsKey(id)) {
            return this.dataMap.get(id);
        }
        return 0;
    }

    public void setData(int id, Object value) {
        this.dataMap.put(id, value);
    }

    public static Vector3f getViewerVec(double x, double y, double z) {
        Entity viewer = NGTUtilClient.getMinecraft().func_175606_aa();
        float vx = (float)(viewer.field_70165_t - x);
        float vy = (float)(viewer.field_70163_u + (double)viewer.func_70047_e() - y);
        float vz = (float)(viewer.field_70161_v - z);
        return new Vector3f(vx, vy, vz);
    }

    public void renderLightEffect(Vector3f normal, double[] pos, float rL, float rS, float length, int color, int type, boolean reverse) {
        GL11.glDisable((int)2884);
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        PartsRenderer.renderLightEffectS(normal, pos[0], pos[1], pos[2], rL, rS, length, color, type, reverse);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GLHelper.enableLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
    }

    public static void renderLightEffectS(Vector3f normal, double x, double y, double z, float rL, float rS, float length, int color, int type, boolean reverse) {
        boolean useVec = normal != null;
        Vector3f viewerVec = null;
        float viewerAngle = 0.0f;
        if (useVec) {
            viewerVec = PartsRenderer.getViewerVec(x, y, z);
            viewerAngle = NGTMath.toDegrees((float)Vector3f.angle((Vector3f)normal, (Vector3f)viewerVec));
        }
        if (reverse) {
            viewerAngle = NGTMath.wrapAngle((float)(viewerAngle + 180.0f));
        }
        if (viewerAngle > 90.0f) {
            viewerAngle = 180.0f - viewerAngle;
        }
        float lightStrength = 1.0f;
        if (viewerAngle > 45.0f) {
            lightStrength = (90.0f - viewerAngle) / 45.0f;
        }
        NGTTessellator tessellator = NGTTessellator.instance;
        if (type == 0) {
            tessellator.startDrawing(6);
            tessellator.setColorRGBA_I(color, 255);
            tessellator.addVertex(0.0f, 0.0f, 0.0f);
            tessellator.setColorRGBA_I(0, 0);
            for (int i = 0; i <= 32; ++i) {
                float rad = NGTMath.toRadians((float)((float)i * 11.25f));
                tessellator.addVertex(NGTMath.getCos((float)rad) * rL * lightStrength, NGTMath.getSin((float)rad) * rL * lightStrength, 0.0f);
            }
            tessellator.draw();
        } else if (type == 1) {
            float angle = NGTMath.toDegrees((float)((float)Math.atan2(rL, length)));
            float distance = 256.0f;
            if (useVec) {
                distance = viewerVec.lengthSquared();
            }
            float brightness = 0.0f;
            if (viewerAngle < angle) {
                brightness = 1.0f - viewerAngle / angle;
            } else {
                float b0 = (viewerAngle - angle) / (90.0f - angle);
                float b1 = (float)((double)distance * 0.00390625);
                if (b1 > 1.0f) {
                    b1 = 1.0f;
                }
                brightness = b0 * b1;
            }
            if (brightness > 0.0f) {
                int alpha = (int)(255.0f * brightness);
                tessellator.startDrawing(6);
                tessellator.setColorRGBA_I(color, alpha);
                tessellator.addVertex(0.0f, 0.0f, 0.0f);
                tessellator.setColorRGBA_I(0, 0);
                for (int i = 0; i <= 32; ++i) {
                    float rad = NGTMath.toRadians((float)((float)(-i) * 11.25f));
                    tessellator.addVertex(NGTMath.getCos((float)rad) * rL, NGTMath.getSin((float)rad) * rL, length);
                }
                tessellator.draw();
                float b3 = (float)((double)distance * 0.00390625);
                if (b3 > 1.0f) {
                    b3 = 1.0f;
                }
                float f3 = rS * b3;
                tessellator.startDrawing(4);
                for (int i = 0; i <= 32; ++i) {
                    float rad = NGTMath.toRadians((float)((float)i * 11.25f));
                    float sin = NGTMath.getSin((float)rad);
                    float cos = NGTMath.getCos((float)rad);
                    tessellator.setColorRGBA_I(0, 0);
                    tessellator.addVertex(cos * rL, sin * rL, length);
                    tessellator.setColorRGBA_I(color, alpha >> 1);
                    tessellator.addVertex(0.0f, 0.0f, 0.0f);
                    tessellator.setColorRGBA_I(0, 0);
                    tessellator.addVertex(cos * f3, sin * f3, 0.0f);
                }
                tessellator.draw();
            }
        }
    }

    private static void renderLightSurface(Vector3f normal, double x, double y, double z, float rL, float rS, float length) {
        Vec3d vecOrig = new Vec3d(x, y, z);
        double lenS = 1.0;
        Vec3d vecStart = vecOrig.func_72441_c((double)normal.x * lenS, (double)normal.y * lenS, (double)normal.z * lenS);
        double lenE = 128.0;
        Vec3d vecEnd = vecOrig.func_72441_c((double)normal.x * lenE, (double)normal.y * lenE, (double)normal.z * lenE);
        RayTraceResult ray = NGTUtil.getClientWorld().func_72933_a(vecStart, vecEnd);
        if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        float centerZ = (float)(ray.field_72307_f.func_72433_c() - vecOrig.func_72433_c());
        float size = rS + (rL - rS) * (centerZ / length);
        GL11.glEnable((int)3553);
        NGTUtilClient.bindTexture((ResourceLocation)TEX_LIGHT);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(7);
        tessellator.setColorRGBA_I(0xFFFFFF, 128);
        tessellator.addVertexWithUV(size, size, centerZ, 1.0f, 0.0f);
        tessellator.addVertexWithUV(size, -size, centerZ, 1.0f, 1.0f);
        tessellator.addVertexWithUV(-size, -size, centerZ, 0.0f, 1.0f);
        tessellator.addVertexWithUV(-size, size, centerZ, 0.0f, 0.0f);
        tessellator.draw();
    }

    public void bindTexture(ResourceLocation texture) {
        NGTUtilClient.bindTexture((ResourceLocation)texture);
    }

    public abstract World getWorld(T var1);

    public int getColor(T entity) {
        if (entity instanceof IResourceSelector) {
            return ((IResourceSelector)entity).getResourceState().color;
        }
        return 0;
    }

    public ItemStack getInventoryItem(T entity, int slotIndex) {
        if (entity instanceof IInventory) {
            IInventory inv = (IInventory)entity;
            if (slotIndex >= 0 && slotIndex < inv.func_70302_i_()) {
                return inv.func_70301_a(slotIndex);
            }
        }
        return null;
    }

    public int getStackSize(ItemStack stack) {
        return stack.func_190916_E();
    }

    public void renderItem(T entity, ItemStack stack) {
        GL11.glPushMatrix();
        GLHelper.enableLighting();
        NGTUtilClient.getMinecraft().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GLHelper.enableLighting();
        GL11.glPopMatrix();
    }

    @Deprecated
    public void spawnParticle(T entity, String name, double posX, double posY, double posZ, double speedX, double speedY, double speedZ) {
        MCWrapperClient.spawnParticle((World)this.getWorld(entity), (String)name, (double)posX, (double)posY, (double)posZ, (double)speedX, (double)speedY, (double)speedZ);
    }

    @Deprecated
    public void playSound(T entity, String name, double posX, double posY, double posZ, float volume, float pitch, boolean distanceDelay) {
        MCWrapperClient.playSound((World)this.getWorld(entity), (String)name, (double)posX, (double)posY, (double)posZ, (float)volume, (float)pitch, (boolean)distanceDelay);
    }

    public void debug(String msg, Object ... args) {
        NGTLog.debug((String)msg, (Object[])args);
    }

    public static boolean validPath(String par1) {
        return par1 != null && par1.length() > 0;
    }
}

