/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.nio.FloatBuffer;
import java.util.List;
import jp.ngt.ngtlib.renderer.IRenderer;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.TextureCoordinate;
import jp.ngt.ngtlib.renderer.model.Vertex;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.render.RailPartsRendererBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RailPartsRenderer
extends RailPartsRendererBase {
    public RailPartsRenderer(String ... par1) {
        super(par1);
    }

    private void genFBuffer(IRenderer renderer, TileEntityLargeRailCore tileEntity, FloatBuffer matrix, int[] brightness, List<GroupObject> gObjList) {
        renderer.startDrawing(4);
        int capacity = matrix.capacity() >> 4;
        int vtxCount = 0;
        for (int sectionIndex = 0; sectionIndex < capacity; ++sectionIndex) {
            renderer.setBrightness(brightness[sectionIndex]);
            for (int j = 0; j < gObjList.size(); ++j) {
                GroupObject group = gObjList.get(j);
                if (group.name.startsWith("side") && sectionIndex != 0 && sectionIndex != capacity - 1 || !this.shouldRenderObject(tileEntity, group.name, capacity, sectionIndex)) continue;
                for (int k = 0; k < group.faces.size(); ++k) {
                    Face face = (Face)group.faces.get(k);
                    renderer.setNormal(face.faceNormal.getX(), face.faceNormal.getY(), face.faceNormal.getZ());
                    for (int i = 0; i < face.vertices.length; ++i) {
                        this.addFace(i, face, renderer, matrix, sectionIndex);
                        ++vtxCount;
                    }
                }
            }
        }
        renderer.draw();
    }

    private void addFace(int index, Face face, IRenderer renderer, FloatBuffer matrix, int sectionIndex) {
        Vertex vtx = face.vertices[index];
        TextureCoordinate tex = face.textureCoordinates[index];
        NGTRenderHelper.addVertexWithMatrix((float)vtx.getX(), (float)vtx.getY(), (float)vtx.getZ(), (float)tex.getU(), (float)tex.getV(), (IRenderer)renderer, (FloatBuffer)matrix, (int)sectionIndex);
    }
}

