/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.TextureCoordinate;
import jp.ngt.ngtlib.renderer.model.Vertex;
import jp.ngt.rtm.modelpack.modelset.ModelSetRail;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailPosition;
import jp.ngt.rtm.render.RailPartsRendererBase;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

@Deprecated
@SideOnly(value=Side.CLIENT)
public class RailPartsRenderer2
extends RailPartsRendererBase {
    public RailPartsRenderer2(String ... par1) {
        super(par1);
    }

    @Override
    public void renderRail(TileEntityLargeRailCore tileEntity, double par2, double par4, double par6, float par8) {
        this.renderRailStatic(tileEntity, par2, par4, par6, par8);
        this.renderRailDynamic(tileEntity, par2, par4, par6, par8);
    }

    @Override
    public void renderStaticParts(TileEntityLargeRailCore tileEntity, double par2, double par4, double par6) {
        boolean hasGLList = GLHelper.isValid((GLObject)tileEntity.glList);
        if (hasGLList && tileEntity.shouldRerenderRail) {
            hasGLList = false;
        }
        if (!hasGLList) {
            float[][] fa = this.createRailPos(tileEntity);
            if (fa != null) {
                BlockPos pos = tileEntity.func_174877_v();
                int[] brightness = this.getRailBrightness(tileEntity.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), fa);
                FloatBuffer fb = this.createMatrix(fa);
                FloatBuffer buffer = this.genFBuffer(tileEntity, fb, brightness, ((ModelSetRail)this.modelSet).modelObj.model.getGroupObjects());
                tileEntity.glList = this.genVBO(buffer);
                tileEntity.shouldRerenderRail = false;
                hasGLList = true;
            } else {
                tileEntity.glList = null;
            }
        }
        if (hasGLList) {
            RailPosition rp = tileEntity.getRailPositions()[0];
            double x = rp.posX - (double)rp.blockX;
            double y = rp.posY - (double)rp.blockY - 0.0625;
            double z = rp.posZ - (double)rp.blockZ;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)(par2 + x)), (float)((float)(par4 + y)), (float)((float)(par6 + z)));
            this.bindTexture(this.getModelObject().textures[0].material.texture);
            this.renderVBO(tileEntity.glList);
            GL11.glPopMatrix();
        }
    }

    private FloatBuffer genFBuffer(TileEntityLargeRailCore tileEntity, FloatBuffer matrix, int[] brightness, List<GroupObject> gObjList) {
        ArrayList<Float> list = new ArrayList<Float>();
        int capacity = matrix.capacity() >> 4;
        for (int i = 0; i < capacity; ++i) {
            for (int j = 0; j < gObjList.size(); ++j) {
                GroupObject group = gObjList.get(j);
                if (group.name.startsWith("side") && i != 0 && i != capacity - 1 || !this.shouldRenderObject(tileEntity, group.name, capacity, i)) continue;
                for (int k = 0; k < group.faces.size(); ++k) {
                    Face face = (Face)group.faces.get(k);
                    for (int l = 0; l < face.vertices.length; ++l) {
                        Vertex vtx = face.vertices[l];
                        TextureCoordinate tex = face.textureCoordinates[l];
                        int pos = l << 4;
                        float x0 = vtx.getX() * matrix.get(pos + 0) + vtx.getY() * matrix.get(pos + 4) + vtx.getZ() * matrix.get(pos + 8) + matrix.get(pos + 12);
                        float y0 = vtx.getX() * matrix.get(pos + 1) + vtx.getY() * matrix.get(pos + 5) + vtx.getZ() * matrix.get(pos + 9) + matrix.get(pos + 13);
                        float z0 = vtx.getX() * matrix.get(pos + 2) + vtx.getY() * matrix.get(pos + 6) + vtx.getZ() * matrix.get(pos + 10) + matrix.get(pos + 14);
                        list.add(Float.valueOf(x0));
                        list.add(Float.valueOf(y0));
                        list.add(Float.valueOf(z0));
                        list.add(Float.valueOf(face.faceNormal.getX()));
                        list.add(Float.valueOf(face.faceNormal.getY()));
                        list.add(Float.valueOf(face.faceNormal.getZ()));
                        list.add(Float.valueOf(tex.getU()));
                        list.add(Float.valueOf(tex.getV()));
                    }
                }
            }
        }
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            buffer.put(((Float)list.get(i)).floatValue());
        }
        buffer.flip();
        return buffer;
    }

    private GLObject genVBO(FloatBuffer buffer) {
        int vtxCout = buffer.capacity() / 5;
        GLObject glObj = GLHelper.generateVAO((int)vtxCout);
        GL30.glBindVertexArray((int)glObj.value);
        int vboId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vboId);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        int stride = 32;
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)12L);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)stride, (long)24L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        return glObj;
    }

    private void renderVBO(GLObject glObj) {
        GL30.glBindVertexArray((int)glObj.value);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glDisableVertexAttribArray((int)0);
        GL30.glBindVertexArray((int)0);
    }
}

