/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.IRenderer;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.PolygonRenderer;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.modelpack.modelset.ModelSetRail;
import jp.ngt.rtm.rail.RenderMarkerBlock;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.TileEntityLargeRailSwitchCore;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailPosition;
import jp.ngt.rtm.render.ModelObject;
import jp.ngt.rtm.render.Parts;
import jp.ngt.rtm.render.TileEntityPartsRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RailPartsRendererBase
extends TileEntityPartsRenderer<ModelSetRail> {
    private final FloatBuffer convBuf = FloatBuffer.wrap(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});

    public RailPartsRendererBase(String ... par1) {
        super(par1);
    }

    @Override
    public void init(ModelSetRail par1, ModelObject par2) {
        super.init(par1, par2);
    }

    public void renderRail(TileEntityLargeRailCore tileEntity, double par2, double par4, double par6, float par8) {
        this.renderRailStatic(tileEntity, par2, par4, par6, par8);
        this.renderRailDynamic(tileEntity, par2, par4, par6, par8);
    }

    protected void renderRailStatic(TileEntityLargeRailCore tileEntity, double x, double y, double z, float par8) {
        ScriptUtil.doScriptIgnoreError((ScriptEngine)this.getScript(), (String)"renderRailStatic", (Object[])new Object[]{tileEntity, x, y, z, Float.valueOf(par8), 0});
    }

    protected void renderRailDynamic(TileEntityLargeRailCore tileEntity, double x, double y, double z, float par8) {
        ScriptUtil.doScriptIgnoreError((ScriptEngine)this.getScript(), (String)"renderRailDynamic", (Object[])new Object[]{tileEntity, x, y, z, Float.valueOf(par8), 0});
    }

    protected boolean shouldRenderObject(TileEntityLargeRailCore tileEntity, String objName, int len, int pos) {
        return (Boolean)ScriptUtil.doScriptIgnoreError((ScriptEngine)this.getScript(), (String)"shouldRenderObject", (Object[])new Object[]{tileEntity, objName, len, pos});
    }

    public void renderStaticParts(TileEntityLargeRailCore rail, double par2, double par4, double par6) {
        boolean hasGLList = GLHelper.isValid((GLObject)rail.glList);
        if (!hasGLList) {
            rail.glList = GLHelper.generateGLList((GLObject)rail.glList);
        } else if (rail.shouldRerenderRail) {
            hasGLList = false;
        }
        if (!hasGLList) {
            float[][] fa = this.createRailPos(rail);
            if (fa != null) {
                BlockPos pos = rail.func_174877_v();
                int[] brightness = this.getRailBrightness(rail.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), fa);
                FloatBuffer fb = this.createMatrix(fa);
                GLHelper.startCompile((GLObject)rail.glList);
                this.tessellateParts(rail, fb, brightness, ((ModelSetRail)this.modelSet).modelObj.model.getGroupObjects());
                GLHelper.endCompile();
                rail.shouldRerenderRail = false;
                hasGLList = true;
            } else {
                rail.shouldRerenderRail = true;
                hasGLList = false;
            }
        }
        if (hasGLList) {
            RailPosition rp = rail.getRailPositions()[0];
            double x = rp.posX - (double)rp.blockX;
            double y = rp.posY - (double)rp.blockY - 0.0625;
            double z = rp.posZ - (double)rp.blockZ;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)(par2 + x)), (float)((float)(par4 + y)), (float)((float)(par6 + z)));
            this.bindTexture(this.getModelObject().textures[0].material.texture);
            GLHelper.callList((GLObject)rail.glList);
            GL11.glPopMatrix();
        }
    }

    protected float[][] createRailPos(TileEntityLargeRailCore par1) {
        float[] rev = RailPosition.REVISION[par1.getRailPositions()[0].direction];
        RailMap[] rms = par1.getAllRailMaps();
        if (rms != null) {
            ArrayList<float[]> list = new ArrayList<float[]>();
            for (RailMap rm : rms) {
                int max = (int)(rm.getLength() * 2.0);
                double[] stPoint = rm.getRailPos(max, 0);
                double startH = rm.getStartRP().posY;
                float moveX = (float)(stPoint[1] - ((double)par1.getStartPoint()[0] + 0.5 + (double)rev[0]));
                float moveZ = (float)(stPoint[0] - ((double)par1.getStartPoint()[2] + 0.5 + (double)rev[1]));
                for (int i = 0; i <= max; ++i) {
                    double[] curPoint = rm.getRailPos(max, i);
                    float[] array = new float[]{moveX + (float)(curPoint[1] - stPoint[1]), (float)(rm.getRailHeight(max, i) - startH), moveZ + (float)(curPoint[0] - stPoint[0]), rm.getRailRotation(max, i), -rm.getRailPitch(max, i), rm.getCant(max, i)};
                    list.add(array);
                }
            }
            return (float[][])list.toArray((T[])new float[list.size()][5]);
        }
        return null;
    }

    protected final FloatBuffer createMatrix(float[][] rp) {
        FloatBuffer buffer = FloatBuffer.allocate(rp.length << 4);
        for (int i = 0; i < rp.length; ++i) {
            FloatBuffer fb = this.convBuf;
            fb = NGTRenderHelper.translate((FloatBuffer)fb, (float)rp[i][0], (float)rp[i][1], (float)rp[i][2]);
            fb = NGTRenderHelper.rotate((FloatBuffer)fb, (float)NGTMath.toRadians((float)rp[i][3]), (char)'Y');
            fb = NGTRenderHelper.rotate((FloatBuffer)fb, (float)NGTMath.toRadians((float)rp[i][4]), (char)'X');
            fb = NGTRenderHelper.rotate((FloatBuffer)fb, (float)NGTMath.toRadians((float)rp[i][5]), (char)'Z');
            buffer.put(fb);
        }
        return buffer;
    }

    protected final int[] getRailBrightness(World world, int x, int y, int z, float[][] rp) {
        int[] fa = new int[rp.length];
        for (int i = 0; i < rp.length; ++i) {
            int x0 = x + NGTMath.floor((float)rp[i][0]);
            int y0 = y + NGTMath.floor((float)rp[i][1]);
            int z0 = z + NGTMath.floor((float)rp[i][2]);
            fa[i] = this.getBrightness(world, x0, y0, z0);
        }
        return fa;
    }

    public int getBrightness(World world, int x, int y, int z) {
        int brightness = this.getWorldBrightness(world, x, y, z);
        if (brightness <= 0) {
            brightness = this.getWorldBrightness(world, x, y + 1, z);
        }
        return brightness;
    }

    private final int getWorldBrightness(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        return world.func_175667_e(pos) ? world.func_175626_b(pos, 0) : 0;
    }

    private final void tessellateParts(TileEntityLargeRailCore tileEntity, FloatBuffer matrix, int[] brightness, List<GroupObject> gObjList) {
        PolygonRenderer tessellator = PolygonRenderer.INSTANCE;
        tessellator.startDrawing(4);
        int capacity = matrix.capacity() >> 4;
        for (int i = 0; i < capacity; ++i) {
            tessellator.setBrightness(brightness[i]);
            for (int j = 0; j < gObjList.size(); ++j) {
                GroupObject group = gObjList.get(j);
                if (group.name.startsWith("side") && i != 0 && i != capacity - 1 || !this.shouldRenderObject(tileEntity, group.name, capacity, i)) continue;
                for (int k = 0; k < group.faces.size(); ++k) {
                    Face face = (Face)group.faces.get(k);
                    NGTRenderHelper.addFaceWithMatrix((Face)face, (IRenderer)tessellator, (FloatBuffer)matrix, (int)i, (boolean)false);
                }
            }
        }
        tessellator.draw();
    }

    public String[] getAllObjNames() {
        List gObj = this.modelObj.model.getGroupObjects();
        String[] aStr = new String[gObj.size()];
        for (int i = 0; i < aStr.length; ++i) {
            aStr[i] = ((GroupObject)gObj.get((int)i)).name;
        }
        return aStr;
    }

    public boolean isSwitchRail(TileEntityLargeRailCore tileEntity) {
        return tileEntity.getAllRailMaps().length > 1;
    }

    public void renderRailMapStatic(TileEntityLargeRailSwitchCore tileEntity, RailMap rm, int max, int startIndex, int endIndex, Parts ... pArray) {
        double[] origPos = rm.getRailPos(max, 0);
        double origHeight = rm.getRailHeight(max, 0);
        int[] startPos = tileEntity.getStartPoint();
        float[] revXZ = RailPosition.REVISION[tileEntity.getRailPositions()[0].direction];
        float moveX = (float)(origPos[1] - ((double)startPos[0] + 0.5 + (double)revXZ[0]));
        float moveZ = (float)(origPos[0] - ((double)startPos[2] + 0.5 + (double)revXZ[1]));
        for (int i = startIndex; i <= endIndex; ++i) {
            double[] p1 = rm.getRailPos(max, i);
            double h = rm.getRailHeight(max, i);
            float x0 = moveX + (float)(p1[1] - origPos[1]);
            float y0 = (float)(h - origHeight);
            float z0 = moveZ + (float)(p1[0] - origPos[0]);
            float yaw = rm.getRailRotation(max, i);
            float pitch = rm.getRailPitch(max, i);
            this.setBrightness(this.getBrightness(tileEntity.func_145831_w(), NGTMath.floor((double)(origPos[1] + (double)x0)), tileEntity.func_174877_v().func_177956_o(), NGTMath.floor((double)(origPos[0] + (double)z0))));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x0, (float)y0, (float)z0);
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            for (int j = 0; j < pArray.length; ++j) {
                pArray[j].render(this);
            }
            GL11.glPopMatrix();
        }
    }

    public ModelObject getModelObject() {
        return ((ModelSetRail)this.modelSet).modelObj;
    }

    public void setBrightness(int par1) {
        GLHelper.setBrightness((int)par1);
    }

    protected void renderRailPosArray(RailPosition[] rps, RailMap[] rms) {
        GL11.glDisable((int)3553);
        GLHelper.disableLighting();
        float lineWidth = (float)NGTUtilClient.getMinecraft().field_71440_d * 0.005f;
        float prevLineWidth = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)lineWidth);
        double sx = rps[0].posX;
        double sy = rps[0].posY;
        double sz = rps[0].posZ;
        for (RailPosition rp : rps) {
            this.renderRailPos(rp, sx, sy, sz);
        }
        for (RailMap rm : rms) {
            this.renderRailMap(rm, sx, sy, sz);
        }
        GL11.glLineWidth((float)prevLineWidth);
        GLHelper.enableLighting();
        GL11.glEnable((int)3553);
    }

    private void renderRailPos(RailPosition rp, double sx, double sy, double sz) {
        float lineLen = 2.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(rp.posX - sx)), (float)((float)(rp.posY - sy)), (float)((float)(rp.posZ - sz)));
        RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, 0.0f, lineLen, 0.0f, 0xFF0000);
        GL11.glPushMatrix();
        GL11.glRotatef((float)rp.anchorYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, rp.anchorLengthHorizontal, 0xFF0000);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-rp.anchorPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, rp.anchorLengthVertical, 0xFF0000);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)rp.cantEdge, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, lineLen, 0.0f, 0.0f, 0xFF0000);
        RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, -lineLen, 0.0f, 0.0f, 0xFF0000);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void renderRailMap(RailMap rm, double sx, double sy, double sz) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(rm.getStartRP().posX - sx)), (float)((float)(rm.getStartRP().posY - sy)), (float)((float)(rm.getStartRP().posZ - sz)));
        int split = (int)(rm.getLength() * 2.0);
        double[] stPoint = rm.getRailPos(split, 0);
        double startH = rm.getStartRP().posY;
        float moveX = (float)(stPoint[1] - sx);
        float moveZ = (float)(stPoint[0] - sz);
        for (int i = 0; i <= split; ++i) {
            double[] curPoint = rm.getRailPos(split, i);
            float x = moveX + (float)(curPoint[1] - stPoint[1]);
            float y = (float)(rm.getRailHeight(split, i) - startH);
            float z = moveZ + (float)(curPoint[0] - stPoint[0]);
            RenderMarkerBlock.renderLine(x, y, z, x, y + 1.5f, z, 65280);
        }
        GL11.glPopMatrix();
    }
}

