/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import javax.annotation.Nullable;
import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.rtm.electric.Connection;
import jp.ngt.rtm.electric.TileEntityElectricalWiring;
import jp.ngt.rtm.modelpack.cfg.WireConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetWire;
import jp.ngt.rtm.render.Parts;
import jp.ngt.rtm.render.RenderPass;
import jp.ngt.rtm.render.TileEntityPartsRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WirePartsRenderer
extends TileEntityPartsRenderer<ModelSetWire> {
    private final boolean useScript;

    public WirePartsRenderer(String ... par1) {
        super(par1);
        this.useScript = true;
    }

    public WirePartsRenderer(boolean par1, String ... par2) {
        super(par2);
        this.useScript = par1;
    }

    public void renderWire(TileEntityElectricalWiring tileEntity, Connection connection, Vec3 target, float par8, RenderPass pass) {
        this.bindTexture(((ModelSetWire)this.modelSet).modelObj.textures[0].material.texture);
        this.renderWireStatic(tileEntity, connection, target, par8, pass.id);
        this.renderWireDynamic(tileEntity, connection, target, par8, pass.id);
    }

    protected void renderWireStatic(TileEntityElectricalWiring tileEntity, Connection connection, Vec3 target, float par8, int pass) {
        if (this.useScript) {
            ScriptUtil.doScriptFunction((ScriptEngine)this.getScript(), (String)"renderWireStatic", (Object[])new Object[]{tileEntity, connection, target, Float.valueOf(par8), pass});
        }
    }

    protected void renderWireDynamic(TileEntityElectricalWiring tileEntity, Connection connection, Vec3 target, float par8, int pass) {
        if (this.useScript) {
            ScriptUtil.doScriptFunction((ScriptEngine)this.getScript(), (String)"renderWireDynamic", (Object[])new Object[]{tileEntity, connection, target, Float.valueOf(par8), pass});
        } else if (pass == RenderPass.NORMAL.id) {
            WireConfig cfg = (WireConfig)connection.getResourceState().getResourceSet().getConfig();
            boolean canUseColor = cfg.useCustomColor;
            if (canUseColor) {
                GLHelper.setColor((int)connection.getResourceState().color, (int)255);
            }
            if (cfg.deflectionCoefficient > 0.0f) {
                this.renderWireDeflection(tileEntity, connection, target, par8, pass, null);
            } else {
                this.renderWireStraight(tileEntity, connection, target, par8, pass, null);
            }
            if (canUseColor) {
                GLHelper.setColor((int)0xFFFFFF, (int)255);
            }
        }
    }

    public void renderWireStraight(TileEntityElectricalWiring tileEntity, Connection connection, Vec3 target, float par8, int pass, @Nullable Parts parts) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)(target.getYaw() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(target.getPitch() - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ModelSetWire modelSet = connection.getResourceState().getResourceSet();
        WireConfig cfg = (WireConfig)modelSet.getConfig();
        double length = target.length();
        int split = NGTMath.floor((double)(length / (double)cfg.sectionLength));
        float scaleY = (float)(length / (double)split / (double)cfg.sectionLength);
        GL11.glScalef((float)1.0f, (float)scaleY, (float)1.0f);
        for (int i = 0; i < split; ++i) {
            if (this.shouldRenderObject(tileEntity, split, i, pass)) {
                if (parts == null) {
                    modelSet.modelObj.model.renderAll(cfg.smoothing);
                } else {
                    parts.render(this);
                }
            }
            GL11.glTranslatef((float)0.0f, (float)cfg.sectionLength, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    public void renderWireDeflection(TileEntityElectricalWiring tileEntity, Connection connection, Vec3 target, float par8, int pass, @Nullable Parts parts) {
        double lx = Math.sqrt(target.getX() * target.getX() + target.getZ() * target.getZ());
        if (lx == 0.0) {
            this.renderWireStraight(tileEntity, connection, target, par8, pass, parts);
            return;
        }
        ModelSetWire modelSet = connection.getResourceState().getResourceSet();
        WireConfig cfg = (WireConfig)modelSet.getConfig();
        GL11.glPushMatrix();
        GL11.glRotatef((float)target.getYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
        float pitch = target.getPitch();
        double ly = target.getY();
        float lc = 1.0f + cfg.lengthCoefficient;
        double alpha = (double)(cfg.deflectionCoefficient * NGTMath.cos((float)pitch)) / Math.pow(lc, lx);
        double a = 0.0;
        if (lx > 0.0) {
            a = (lx - ly / (alpha * lx)) / 2.0;
        }
        double x = 0.0;
        int i = 0;
        while (x < lx) {
            GL11.glPushMatrix();
            double y = alpha * (x * x - 2.0 * a * x);
            double slope = 2.0 * alpha * (x - a);
            double slopeRad = Math.atan(slope);
            float dx = NGTMath.getCos((float)((float)slopeRad)) * cfg.sectionLength * 0.99f;
            double nextX = x + (double)dx;
            double nextY = alpha * (nextX * nextX - 2.0 * a * nextX);
            double cX = (x + nextX) * 0.5;
            double cY = (y + nextY) * 0.5;
            double difX = nextX - x;
            double difY = nextY - y;
            float pitchC = -((float)NGTMath.toDegrees((double)Math.atan2(difY, difX)));
            GL11.glTranslatef((float)0.0f, (float)((float)cY), (float)((float)cX));
            GL11.glRotatef((float)(pitchC + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(-cfg.sectionLength * 0.5f), (float)0.0f);
            if (this.shouldRenderObject(tileEntity, 0, i, pass)) {
                if (parts == null) {
                    modelSet.modelObj.model.renderAll(cfg.smoothing);
                } else {
                    parts.render(this);
                }
            }
            GL11.glPopMatrix();
            x = nextX;
            ++i;
        }
        GL11.glPopMatrix();
    }

    private boolean shouldRenderObject(TileEntityElectricalWiring tileEntity, int len, int pos, int pass) {
        if (this.useScript) {
            return (Boolean)ScriptUtil.doScriptFunction((ScriptEngine)this.getScript(), (String)"shouldRenderObject", (Object[])new Object[]{tileEntity, len, pos, pass});
        }
        return true;
    }
}

