/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.sound;

import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.EnumNotch;
import jp.ngt.rtm.entity.train.util.Formation;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.sound.MovingSoundEntity;
import jp.ngt.rtm.sound.MovingSoundMaker;
import jp.ngt.rtm.sound.SoundUpdaterVehicle;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundUpdaterTrain
extends SoundUpdaterVehicle<EntityTrainBase> {
    private MovingSoundEntity[] atsSound = new MovingSoundEntity[2];
    private int currentSignal;

    public SoundUpdaterTrain(SoundHandler par1, EntityTrainBase par2) {
        super(par1, par2);
    }

    @Override
    public void update() {
        EntityTrainBase train = (EntityTrainBase)this.vehicle;
        EntityBogie bogie = train.getBogie(train.getTrainDirection());
        if (bogie == null) {
            return;
        }
        int signal = train.getSignal();
        if (train.getSpeed() > 0.0f) {
            switch (signal) {
                case 1: {
                    if (this.currentSignal == 1) break;
                    if (this.atsSound[0] != null) {
                        this.atsSound[0].stop();
                    }
                    if (this.atsSound[1] != null) {
                        this.atsSound[1].stop();
                    }
                    this.atsSound[0] = MovingSoundMaker.create(bogie, "rtm:sounds/train/ats.ogg", true);
                    this.soundHandler.func_147682_a((ISound)this.atsSound[0]);
                    this.atsSound[1] = MovingSoundMaker.create(bogie, "rtm:sounds/train/ats_bell.ogg", true);
                    this.soundHandler.func_147682_a((ISound)this.atsSound[1]);
                    this.currentSignal = 1;
                    break;
                }
                case -1: {
                    if (this.currentSignal == -1) break;
                    if (this.atsSound[1] != null) {
                        this.atsSound[1].stop();
                    }
                    this.currentSignal = -1;
                }
            }
        } else if (signal != -1 && this.currentSignal != 0) {
            if (this.atsSound[0] != null) {
                this.atsSound[0].stop();
            }
            if (this.atsSound[1] != null) {
                this.atsSound[1].stop();
            }
            this.currentSignal = 0;
        }
        super.update();
    }

    @Override
    protected String getSound(ModelSetVehicleBase modelset) {
        float speed = ((EntityTrainBase)this.vehicle).getSpeed();
        if (speed > 0.0f) {
            float acceleration = EnumNotch.getAcceleration(this.getNotch(), speed);
            if (speed < ((TrainConfig)modelset.getConfig()).maxSpeed[0]) {
                return acceleration > 0.0f ? ((VehicleBaseConfig)modelset.getConfig()).sound_S_A : ((VehicleBaseConfig)modelset.getConfig()).sound_D_S;
            }
            return acceleration > 0.0f ? ((VehicleBaseConfig)modelset.getConfig()).sound_Acceleration : ((VehicleBaseConfig)modelset.getConfig()).sound_Deceleration;
        }
        return ((VehicleBaseConfig)modelset.getConfig()).sound_Stop;
    }

    @Override
    protected boolean changePitch() {
        ModelSetTrain modelset = (ModelSetTrain)((EntityTrainBase)this.vehicle).getResourceState().getResourceSet();
        float speed = ((EntityTrainBase)this.vehicle).getSpeed();
        return speed > 0.0f ? !(speed < ((TrainConfig)modelset.getConfig()).maxSpeed[0]) : false;
    }

    public float getMaxSpeed() {
        return ((TrainConfig)((ModelSetTrain)((EntityTrainBase)this.vehicle).getResourceState().getResourceSet()).getConfig()).maxSpeed[4] * 72.0f;
    }

    public int getNotch() {
        Formation formation = ((EntityTrainBase)this.vehicle).getFormation();
        return formation == null ? 0 : formation.getNotch();
    }

    public byte getState(int id) {
        return ((EntityTrainBase)this.vehicle).getVehicleState(TrainState.TrainStateType.get(id));
    }

    public boolean isComplessorActive() {
        return ((EntityTrainBase)this.vehicle).complessorActive;
    }

    public int complessorCount() {
        return ((EntityTrainBase)this.vehicle).brakeAirCount - 2480;
    }
}

