/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.sound;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.ResourceLocationCustom;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.entity.vehicle.IUpdateVehicle;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.sound.MovingSoundEntity;
import jp.ngt.rtm.sound.MovingSoundMaker;
import jp.ngt.rtm.sound.MovingSoundTrain;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundUpdaterVehicle<T extends EntityVehicleBase>
implements IUpdateVehicle {
    protected final SoundHandler soundHandler;
    protected final T vehicle;
    protected boolean silent;
    protected String prevSoundResource;
    protected MovingSoundEntity prevSound;
    protected final List<MovingSoundEntity> playingSounds = new ArrayList<MovingSoundEntity>();

    public SoundUpdaterVehicle(SoundHandler par1, T par2) {
        this.soundHandler = par1;
        this.vehicle = par2;
    }

    @Override
    public void update() {
        ModelSetVehicleBase modelset = (ModelSetVehicleBase)((EntityVehicleBase)this.vehicle).getResourceState().getResourceSet();
        if (modelset.soundSE != null) {
            ScriptUtil.doScriptIgnoreError((ScriptEngine)modelset.soundSE, (String)"onUpdate", (Object[])new Object[]{this});
        } else if (((EntityVehicleBase)this.vehicle).field_70128_L) {
            if (this.prevSound != null) {
                this.prevSound.stop();
            }
        } else {
            MovingSoundEntity sound;
            String newSound = this.getSound(modelset);
            if (this.prevSoundResource == null || newSound == null || !newSound.equals(this.prevSoundResource)) {
                if (this.prevSound != null) {
                    this.prevSound.stop();
                }
                this.prevSoundResource = newSound;
                this.silent = true;
            }
            if (this.silent && !this.soundHandler.func_147692_c((ISound)this.prevSound) && this.prevSoundResource != null && (sound = MovingSoundMaker.create(this.vehicle, this.prevSoundResource, true)) != null) {
                if (sound instanceof MovingSoundTrain) {
                    ((MovingSoundTrain)sound).changePitch = this.changePitch();
                }
                this.soundHandler.func_147682_a((ISound)sound);
                this.prevSound = sound;
                this.silent = false;
            }
        }
    }

    protected String getSound(ModelSetVehicleBase modelset) {
        float speed = ((EntityVehicleBase)this.vehicle).getSpeed();
        if (speed > 0.0f) {
            return ((VehicleBaseConfig)modelset.getConfig()).sound_Acceleration;
        }
        return ((VehicleBaseConfig)modelset.getConfig()).sound_Stop;
    }

    protected boolean changePitch() {
        return true;
    }

    public float getSpeed() {
        return ((EntityVehicleBase)this.vehicle).getSpeed() * 72.0f;
    }

    public boolean inTunnel() {
        int z;
        int y;
        World world = ((EntityVehicleBase)this.vehicle).field_70170_p;
        int x = NGTMath.floor((double)((EntityVehicleBase)this.vehicle).field_70165_t);
        return !world.func_175678_i(new BlockPos(x + 1, y = NGTMath.floor((double)((EntityVehicleBase)this.vehicle).field_70163_u), (z = NGTMath.floor((double)((EntityVehicleBase)this.vehicle).field_70161_v)) + 1)) && !world.func_175678_i(new BlockPos(x - 1, y, z + 1)) && !world.func_175678_i(new BlockPos(x + 1, y, z - 1)) && !world.func_175678_i(new BlockPos(x - 1, y, z - 1));
    }

    @Deprecated
    public void playSound(String domain, String path, float volume, float pitch) {
        this.playSound(domain, path, volume, pitch, true);
    }

    @Deprecated
    public void playSound(String domain, String path, float volume, float pitch, boolean repeat) {
        boolean isNewSound;
        MovingSoundEntity sound = this.getPlayingSound(domain, path);
        boolean bl = isNewSound = sound == null;
        if (isNewSound) {
            sound = MovingSoundMaker.create(this.vehicle, domain + ":" + path, repeat);
        }
        if (sound != null) {
            sound.setVolume(volume);
            sound.setPitch(pitch);
            if (isNewSound) {
                this.soundHandler.func_147682_a((ISound)sound);
                this.playingSounds.add(sound);
            }
        }
    }

    @Deprecated
    public void stopSound(String domain, String path) {
        MovingSoundEntity sound = this.getPlayingSound(domain, path);
        if (sound != null) {
            sound.stop();
            this.playingSounds.remove((Object)sound);
        }
    }

    public void stopAllSounds() {
        for (MovingSoundEntity sound : this.playingSounds) {
            sound.stop();
        }
        this.playingSounds.clear();
        if (this.prevSound != null) {
            this.prevSound.stop();
            this.prevSound = null;
        }
        this.prevSoundResource = null;
    }

    private MovingSoundEntity getPlayingSound(String domain, String path) {
        for (MovingSoundEntity sound : this.playingSounds) {
            ResourceLocation resource = sound.func_147650_b();
            if (!resource.equals((Object)new ResourceLocationCustom(domain, path))) continue;
            return sound;
        }
        return null;
    }

    @Override
    public void onModelChanged() {
        this.stopAllSounds();
    }

    @Deprecated
    public Object getData(int id) {
        return ((EntityVehicleBase)this.getEntity()).getResourceState().dataMap.getDouble("SU" + id);
    }

    @Deprecated
    public void setData(int id, Object value) {
        double val2 = 0.0;
        if (value instanceof Double) {
            val2 = (Double)value;
        } else if (value instanceof Integer) {
            val2 = ((Integer)value).intValue();
        }
        ((EntityVehicleBase)this.getEntity()).getResourceState().dataMap.setDouble("SU" + id, val2, 0);
    }

    public T getEntity() {
        return this.vehicle;
    }
}

