/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.common.entity.BurningBannerEntity;
import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.minecraftabnormals.savageandravage.core.registry.SRParticles;
import java.util.List;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CreeperSporeCloudEntity
extends ThrowableEntity {
    public int cloudSize = 1;
    private boolean shouldSpawnCreepies = false;
    private static final DataParameter<Integer> TICKS_TILL_REMOVE = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private AreaEffectCloudEntity aoe;

    public CreeperSporeCloudEntity(EntityType<? extends CreeperSporeCloudEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public CreeperSporeCloudEntity(World worldIn, LivingEntity throwerIn) {
        super((EntityType)SREntities.CREEPER_SPORE_CLOUD.get(), throwerIn, worldIn);
    }

    public CreeperSporeCloudEntity(World worldIn, double x, double y, double z) {
        super((EntityType)SREntities.CREEPER_SPORE_CLOUD.get(), x, y, z, worldIn);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(TICKS_TILL_REMOVE, (Object)1);
    }

    public int getTicksTillRemove() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.field_70180_af.func_187227_b(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    protected void func_70227_a(RayTraceResult result) {
        this.summonCreepies();
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
    }

    public void summonCreepies() {
        if (this.aoe == null) {
            this.aoe = new AreaEffectCloudEntity(this.field_70170_p, this.func_213303_ch().func_82615_a(), this.func_174813_aQ().field_72337_e - 0.2, this.func_213303_ch().func_82616_c());
            this.aoe.func_184481_a((LivingEntity)this.func_234616_v_());
            this.aoe.func_195059_a((IParticleData)SRParticles.CREEPER_SPORES.get());
            this.aoe.func_184483_a((float)this.cloudSize + 0.3f);
            this.aoe.func_184495_b(-0.05f);
            this.aoe.func_184486_b(this.cloudSize * 20 + 40);
            this.aoe.func_184487_c(-this.aoe.func_184490_j() / (float)this.aoe.func_184489_o());
            this.field_70170_p.func_217376_c((Entity)this.aoe);
            this.shouldSpawnCreepies = true;
            this.setTicksTillRemove(this.cloudSize * 20 + 40);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("TicksTillRemove", this.getTicksTillRemove());
        compound.func_74768_a("CloudSize", this.cloudSize);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("CloudSize", 99)) {
            this.cloudSize = compound.func_74762_e("CloudSize");
        }
        this.setTicksTillRemove(compound.func_74762_e("TicksTillRemove"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_195594_a((IParticleData)SRParticles.CREEPER_SPORES.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_() - 0.0, 0.0, 0.0, 0.0);
        if (this.shouldSpawnCreepies) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.setTicksTillRemove(this.getTicksTillRemove() - 1);
            if (this.getTicksTillRemove() % 20 == 0) {
                double xPos = this.aoe.func_226282_d_(0.1);
                double zPos = this.aoe.func_226287_g_(0.2);
                BlockPos pos = new BlockPos(xPos, this.func_226278_cu_(), zPos);
                List blockShapes = this.field_70170_p.func_180495_p(pos).func_196954_c((IBlockReader)this.field_70170_p, pos).func_197756_d();
                boolean flag = true;
                for (AxisAlignedBB box : blockShapes) {
                    if (!box.func_72326_a(this.aoe.func_174813_aQ()) || !this.field_70170_p.func_180495_p(pos).func_229980_m_((IBlockReader)this.field_70170_p, pos)) continue;
                    flag = false;
                }
                if (flag) {
                    boolean throwerIsInvisible;
                    CreepieEntity creepie = (CreepieEntity)((EntityType)SREntities.CREEPIE.get()).func_200721_a(this.field_70170_p);
                    creepie.func_70012_b(xPos, this.aoe.func_226278_cu_(), zPos, 0.0f, 0.0f);
                    try {
                        throwerIsInvisible = ((LivingEntity)this.func_234616_v_()).func_70644_a(Effects.field_76441_p);
                    }
                    catch (NullPointerException nullPointer) {
                        throwerIsInvisible = false;
                    }
                    if (!throwerIsInvisible) {
                        try {
                            creepie.setOwnerId(((LivingEntity)this.func_234616_v_()).func_110124_au());
                        }
                        catch (NullPointerException nullPointer) {
                            creepie.setOwnerId(null);
                        }
                    }
                    this.field_70170_p.func_217376_c((Entity)creepie);
                }
            }
            if (!this.aoe.func_70089_S()) {
                this.func_70106_y();
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

