/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity.goals;

import com.minecraftabnormals.savageandravage.common.entity.IOwnableMob;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;

public class FollowMobOwnerGoal
extends Goal {
    private final MobEntity ownedMob;
    private LivingEntity owner;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float minDist;
    private final float maxDist;
    private float oldWaterCost;

    public FollowMobOwnerGoal(MobEntity entityIn, double followSpeed, float minimumDistance, float maximumDistance, boolean canFly) {
        this.ownedMob = entityIn;
        this.followSpeed = followSpeed;
        this.navigator = entityIn.func_70661_as();
        this.minDist = minimumDistance;
        this.maxDist = maximumDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(entityIn.func_70661_as() instanceof GroundPathNavigator) && !(entityIn.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = ((IOwnableMob)this.ownedMob).getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (this.ownedMob.func_70068_e((Entity)livingentity) <= (double)(this.minDist * this.minDist) || this.ownedMob.func_70068_e((Entity)livingentity) >= (double)(this.maxDist * this.maxDist)) {
            return false;
        }
        if (this.ownedMob.func_70638_az() != null) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigator.func_75500_f()) {
            return false;
        }
        if (this.ownedMob.func_70068_e((Entity)this.owner) <= (double)(this.minDist * this.minDist) || this.ownedMob.func_70068_e((Entity)this.owner) >= (double)(this.maxDist * this.maxDist)) {
            return false;
        }
        return this.ownedMob.func_70638_az() == null;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.ownedMob.func_184643_a(PathNodeType.WATER);
        this.ownedMob.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.ownedMob.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.ownedMob.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.ownedMob.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.ownedMob.func_110167_bD() && !this.ownedMob.func_184218_aH()) {
                this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
            }
        }
    }
}

