/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.registry;

import com.minecraftabnormals.savageandravage.client.render.CreepieRenderer;
import com.minecraftabnormals.savageandravage.client.render.GrieferRenderer;
import com.minecraftabnormals.savageandravage.client.render.MischiefArrowRenderer;
import com.minecraftabnormals.savageandravage.client.render.NoModelRenderer;
import com.minecraftabnormals.savageandravage.client.render.RevampedVindicatorRenderer;
import com.minecraftabnormals.savageandravage.client.render.RunePrisonRenderer;
import com.minecraftabnormals.savageandravage.client.render.SkeletonVillagerRenderer;
import com.minecraftabnormals.savageandravage.client.render.SporeBombRenderer;
import com.minecraftabnormals.savageandravage.common.entity.BurningBannerEntity;
import com.minecraftabnormals.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.common.entity.GrieferEntity;
import com.minecraftabnormals.savageandravage.common.entity.MischiefArrowEntity;
import com.minecraftabnormals.savageandravage.common.entity.RunePrisonEntity;
import com.minecraftabnormals.savageandravage.common.entity.SkeletonVillagerEntity;
import com.minecraftabnormals.savageandravage.common.entity.block.SporeBombEntity;
import com.minecraftabnormals.savageandravage.core.SRConfig;
import com.minecraftabnormals.savageandravage.core.SavageAndRavage;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="savageandravage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SREntities {
    public static final RegistryHelper HELPER = SavageAndRavage.REGISTRY_HELPER;
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"savageandravage");
    public static final RegistryObject<EntityType<CreepieEntity>> CREEPIE = HELPER.createLivingEntity("creepie", CreepieEntity::new, EntityClassification.CREATURE, 0.85f, 1.9f);
    public static final RegistryObject<EntityType<SkeletonVillagerEntity>> SKELETON_VILLAGER = HELPER.createLivingEntity("skeleton_villager", SkeletonVillagerEntity::new, EntityClassification.MONSTER, 0.6f, 1.99f);
    public static final RegistryObject<EntityType<GrieferEntity>> GRIEFER = HELPER.createLivingEntity("griefer", GrieferEntity::new, EntityClassification.MONSTER, 0.6f, 1.99f);
    public static final RegistryObject<EntityType<CreeperSporeCloudEntity>> CREEPER_SPORE_CLOUD = ENTITIES.register("creeper_spore_cloud", () -> EntityType.Builder.func_220322_a(CreeperSporeCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.25f, 0.25f).func_206830_a("savageandravage:creeper_spore_cloud"));
    public static final RegistryObject<EntityType<SporeBombEntity>> SPORE_BOMB = ENTITIES.register("spore_bomb", () -> EntityType.Builder.func_220322_a(SporeBombEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f).func_206830_a("savageandravage:spore_bomb"));
    public static final RegistryObject<EntityType<BurningBannerEntity>> BURNING_BANNER = ENTITIES.register("burning_banner", () -> EntityType.Builder.func_220322_a(BurningBannerEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_206830_a("savageandravage:burning_banner"));
    public static final RegistryObject<EntityType<RunePrisonEntity>> RUNE_PRISON = ENTITIES.register("rune_prison", () -> EntityType.Builder.func_220322_a(RunePrisonEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(1.35f, 0.7f).func_206830_a("savageandravage:rune_prison"));
    public static final RegistryObject<EntityType<MischiefArrowEntity>> MISCHIEF_ARROW = HELPER.createEntity("mischief_arrow", MischiefArrowEntity::new, MischiefArrowEntity::new, EntityClassification.MISC, 0.5f, 0.5f);

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRendering() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPIE.get()), CreepieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SKELETON_VILLAGER.get()), SkeletonVillagerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)GRIEFER.get()), GrieferRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPER_SPORE_CLOUD.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SPORE_BOMB.get()), SporeBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BURNING_BANNER.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)RUNE_PRISON.get()), RunePrisonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MISCHIEF_ARROW.get()), MischiefArrowRenderer::new);
        if (((Boolean)SRConfig.CLIENT.vindicatorRemodel.get()).booleanValue()) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200758_ax, RevampedVindicatorRenderer::new);
        }
    }

    public static void registerEntitySpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SKELETON_VILLAGER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        ForgeRegistries.BIOMES.getValues().forEach(SREntities::registerSpawns);
    }

    public static void registerSpawns(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && biome.func_201856_r() != Biome.Category.MUSHROOM && biome.func_201856_r() != Biome.Category.NONE) {
            biome.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry((EntityType)SKELETON_VILLAGER.get(), 5, 5, 5));
        }
    }

    public static void registerAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)CREEPIE.get()), (AttributeModifierMap)CreepieEntity.registerAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)GRIEFER.get()), (AttributeModifierMap)GrieferEntity.registerAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)SKELETON_VILLAGER.get()), (AttributeModifierMap)SkeletonVillagerEntity.func_234275_m_().func_233813_a_());
    }

    public static void registerWaveMembers() {
        Raid.WaveMember.create((String)"griefer", (EntityType)((EntityType)GRIEFER.get()), (int[])new int[]{0, 1, 0, 1, 2, 2, 3, 2});
    }
}

