/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.registry;

import com.minecraftabnormals.savageandravage.common.particles.CreeperSporeParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SRParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"savageandravage");
    public static final RegistryObject<BasicParticleType> CREEPER_SPORES = SRParticles.createParticle("creeper_spores", true);

    private static boolean checkForNonNullWithReflectionCauseForgeIsBaby(RegistryObject<BasicParticleType> registryObject) {
        return ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, registryObject, (String)"value") != null;
    }

    public static RegistryObject<BasicParticleType> createParticle(String name, boolean alwaysShow) {
        RegistryObject particleType = PARTICLES.register(name, () -> new BasicParticleType(alwaysShow));
        return particleType;
    }

    @Mod.EventBusSubscriber(modid="savageandravage", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterParticleFactories {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
            if (SRParticles.checkForNonNullWithReflectionCauseForgeIsBaby((RegistryObject<BasicParticleType>)CREEPER_SPORES)) {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)CREEPER_SPORES.get(), CreeperSporeParticle.Factory::new);
            }
        }
    }
}

